/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaf.ui;

import com.sun.jaf.ui.SortableTableModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SortableTableHeader
extends JTableHeader {
    private Icon descendingIcon;
    private Icon ascendingIcon;

    public SortableTableHeader(TableColumnModel model) {
        super(model);
        this.setDefaultRenderer(new SortHeaderCellRenderer());
        this.addMouseListener(new SortHeaderMouseAdapter());
    }

    public void setDescendingIcon(Icon descend) {
        this.descendingIcon = descend;
    }

    public void setAscendingIcon(Icon ascend) {
        this.ascendingIcon = ascend;
    }

    class SortHeaderMouseAdapter
    extends MouseAdapter {
        SortHeaderMouseAdapter() {
        }

        public void mouseClicked(MouseEvent evt) {
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel columnModel = table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(evt.getX());
            int column = table.convertColumnIndexToModel(viewColumn);
            if (evt.getClickCount() == 1 && column != -1) {
                SortableTableModel model;
                model.sortByColumn(column, !(model = (SortableTableModel)table.getModel()).isAscending());
            }
        }
    }

    class SortHeaderCellRenderer
    extends DefaultTableCellRenderer {
        public SortHeaderCellRenderer() {
            if (SortableTableHeader.this.descendingIcon == null) {
                SortableTableHeader.this.descendingIcon = this.getIcon("/toolbarButtonGraphics/navigation/Down16.gif");
            }
            if (SortableTableHeader.this.ascendingIcon == null) {
                SortableTableHeader.this.ascendingIcon = this.getIcon("/toolbarButtonGraphics/navigation/Up16.gif");
            }
            this.setForeground(SortableTableHeader.this.getForeground());
            this.setBackground(SortableTableHeader.this.getBackground());
            this.setFont(SortableTableHeader.this.getFont());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
        }

        Icon getIcon(String imagePath) {
            URL url;
            if (imagePath != null && !imagePath.equals("") && (url = this.getClass().getResource(imagePath)) != null) {
                return new ImageIcon(url);
            }
            return null;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            SortableTableModel model = (SortableTableModel)table.getModel();
            Icon icon = null;
            if (table.convertColumnIndexToModel(column) == model.getColumn()) {
                icon = model.isAscending() ? SortableTableHeader.this.ascendingIcon : SortableTableHeader.this.descendingIcon;
            }
            this.setIcon(icon);
            return this;
        }
    }
}

