/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;

public class SimpleClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();

    private byte[] getClassImplFromDataBase(String string) {
        System.out.println("        >>>>>> Fetching the implementation of " + string);
        try {
            FileInputStream fileInputStream = new FileInputStream("store\\" + string + ".impl");
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        System.out.println("        >>>>>> Load class : " + string);
        Class<?> clazz = (Class<?>)this.classes.get(string);
        if (clazz != null) {
            System.out.println("        >>>>>> returning cached result.");
            return clazz;
        }
        try {
            clazz = super.findSystemClass(string);
            System.out.println("        >>>>>> returning system class (in CLASSPATH).");
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("        >>>>>> Not a system class.");
            String string2 = string.replace('.', '/');
            File file = new File("build/" + string2 + ".class");
            System.out.println("Try to load" + file.getAbsolutePath());
            byte[] byArray = this.loadBinaryLocalClass(file);
            if (byArray == null) {
                throw new ClassNotFoundException();
            }
            clazz = this.defineClass(null, byArray, 0, byArray.length);
            if (clazz == null) {
                throw new ClassFormatError();
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            this.classes.put(string, clazz);
            System.out.println("        >>>>>> Returning newly loaded class.");
            return clazz;
        }
    }

    private byte[] loadBinaryLocalClass(File file) {
        System.out.println("        >>>>>> Fetching the implementation of " + file.getName());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class loadLocalClass(File file, boolean bl) throws ClassNotFoundException {
        String string = file.getName();
        System.out.println("        >>>>>> Load class : " + string);
        Class<?> clazz = (Class<?>)this.classes.get(string);
        if (clazz != null) {
            System.out.println("        >>>>>> returning cached result.");
            return clazz;
        }
        try {
            clazz = super.findSystemClass(string);
            System.out.println("        >>>>>> returning system class (in CLASSPATH).");
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("        >>>>>> Not a system class.");
            byte[] byArray = this.loadBinaryLocalClass(file);
            if (byArray == null) {
                throw new ClassNotFoundException();
            }
            clazz = this.defineClass(null, byArray, 0, byArray.length);
            if (clazz == null) {
                throw new ClassFormatError();
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            this.classes.put(file.getName(), clazz);
            System.out.println("        >>>>>> Returning newly loaded class.");
            return clazz;
        }
    }
}

