/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.util.TableOrder;

public class Chart {
    public static final int TYPE_PIE = 1;
    public static final int TYPE_BAR = 2;
    public static final int TYPE_PIE3D = 3;
    public static final int TYPE_BAR3D = 4;
    public static final int TYPE_HISTOGRAM = 5;
    public static final int TYPE_MULTIPLEPIE = 6;
    private int type;
    private DefaultCategoryDataset donnees;
    private String nomFichier;
    private String titre;
    private int longueur;
    private int largeur;

    public Chart(String string, String string2, int n, int n2, DefaultCategoryDataset defaultCategoryDataset, int n3) {
        this.type = n3;
        this.donnees = defaultCategoryDataset;
        this.nomFichier = string;
        this.titre = string2;
        this.longueur = n;
        this.largeur = n2;
    }

    public void makeChart() {
        switch (this.type) {
            case 1: {
                this.makePie();
                break;
            }
            case 3: {
                this.makePie3D();
                break;
            }
            case 2: {
                this.makeBar();
                break;
            }
            case 4: {
                this.makeBar3D();
                break;
            }
            case 5: {
                this.makeHistogram();
                break;
            }
            case 6: {
                this.makeMultiplePie();
            }
        }
    }

    private void makeMultiplePie() {
        try {
            File file = new File("c:/ArtiJava/IHMWeb/stat/all/" + this.nomFichier);
            JFreeChart jFreeChart = ChartFactory.createMultiplePieChart3D((String)this.titre, (CategoryDataset)this.donnees, (TableOrder)TableOrder.BY_COLUMN, (boolean)true, (boolean)true, (boolean)false);
            BufferedImage bufferedImage = jFreeChart.createBufferedImage(this.longueur, this.largeur);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void makeAllTypes() {
        this.makePie();
        this.makePie3D();
        this.makeBar();
        this.makeBar3D();
        this.makeHistogram();
    }

    private void makeBar3D() {
        try {
            File file = new File("c:/ArtiJava/IHMWeb/stat/all/" + this.nomFichier);
            JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)this.titre, (String)"", (String)"", (CategoryDataset)this.donnees, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            BufferedImage bufferedImage = jFreeChart.createBufferedImage(this.longueur, this.largeur);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makePie3D() {
        try {
            Object object;
            File file = new File("c:/ArtiJava/IHMWeb/stat/all/" + this.nomFichier);
            DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
            for (int i = 0; i < this.donnees.getRowCount(); ++i) {
                object = this.donnees.getValue(i, 0);
                String string = (String)((Object)this.donnees.getRowKey(i));
                defaultPieDataset.setValue((Comparable)((Object)string), (Number)object);
            }
            JFreeChart jFreeChart = ChartFactory.createPieChart3D((String)this.titre, (PieDataset)defaultPieDataset, (boolean)true, (boolean)true, (boolean)false);
            object = jFreeChart.createBufferedImage(this.longueur, this.largeur);
            ImageIO.write((RenderedImage)object, "png", file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makeBar() {
        try {
            File file = new File("c:/ArtiJava/IHMWeb/stat/all/" + this.nomFichier);
            JFreeChart jFreeChart = ChartFactory.createBarChart((String)this.titre, (String)"", (String)"", (CategoryDataset)this.donnees, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            BufferedImage bufferedImage = jFreeChart.createBufferedImage(this.longueur, this.largeur);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makePie() {
        try {
            Object object;
            File file = new File("c:/ArtiJava/IHMWeb/stat/all/" + this.nomFichier);
            DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
            for (int i = 0; i < this.donnees.getRowCount(); ++i) {
                object = this.donnees.getValue(i, 0);
                String string = (String)((Object)this.donnees.getRowKey(i));
                defaultPieDataset.setValue((Comparable)((Object)string), (Number)object);
            }
            JFreeChart jFreeChart = ChartFactory.createPieChart((String)this.titre, (PieDataset)defaultPieDataset, (boolean)true, (boolean)true, (boolean)false);
            object = jFreeChart.createBufferedImage(this.longueur, this.largeur);
            ImageIO.write((RenderedImage)object, "png", file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makeHistogram() {
        try {
            Object object;
            File file = new File("c:/ArtiJava/IHMWeb/stat/all/" + this.nomFichier);
            DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
            for (int i = 0; i < this.donnees.getRowCount(); ++i) {
                object = this.donnees.getValue(i, 0);
                String string = (String)((Object)this.donnees.getRowKey(i));
                XYSeries xYSeries = new XYSeries(string, true, false);
                xYSeries.add((double)(i + 1), (Number)object);
                defaultTableXYDataset.addSeries(xYSeries);
            }
            JFreeChart jFreeChart = ChartFactory.createHistogram((String)this.titre, (String)"", (String)"nombres", (IntervalXYDataset)defaultTableXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            object = jFreeChart.createBufferedImage(this.longueur, this.largeur);
            ImageIO.write((RenderedImage)object, "png", file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

