/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.graphicBuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;
import modulecoFramework.simulation.ModulecoLauncher;
import modulecoFramework.utils.graphicalWatcher.GraphicalWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.AbstractChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.AutoCountWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.CountWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.NormalWatcher;
import modulecoGUI.CentralControl;
import modulecoGUI.XMLGuiReader.XMLGuiReader;
import modulecoGUI.graphicBuilder.DynamicBarChart;
import modulecoGUI.graphicBuilder.DynamicLineChart;
import modulecoGUI.graphicBuilder.DynamicPieChart;
import modulecoGUI.graphicBuilder.JPanelOperation1;
import modulecoGUI.graphicBuilder.JPanelOperation2;
import modulecoGUI.graphicBuilder.JPanelOperation3;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.XYPlot;

public class JCreateDynamicChart
extends JPanel
implements ActionListener {
    CentralControl centralControl;
    ModulecoLauncher modulecoLauncher;
    GraphicalWatcher graphicalWatcher;
    JPanel jPanelButton;
    JPanelCreateSeries jPanelCreateSeries;
    JPanelConfigChart jPanelConfigChart;
    JButton jButtonAnnuler;
    JButton jButtonSuivant;
    JButton jButtonPrecedent;
    JButton jButtonAfficher;
    JButton jButtonTerminer;
    DynamicLineChart dynamicLineChart;
    DynamicPieChart dynamicPieChart;
    DynamicBarChart dynamicBarChart;
    JDialog jDialog;
    boolean open = true;
    int defaultTypeChart;
    static String MESSAGE_NO_AGENT = "Attention! Aucun agent n'est pr\ufffdsent dans la liste! Cela peut affecter les r\ufffdsultats.";
    static String MESSAGE_AGENT_WITH_DIFF_CLASS = "Attention! Les agents pr\ufffdsents dans cette communaut\ufffd/groupe/role sont de type diff\ufffdrent! Cela peut affecter les r\ufffdsultats.";

    public JCreateDynamicChart(CentralControl centralControl, int n, Component component) {
        this.defaultTypeChart = n;
        this.centralControl = centralControl;
        this.modulecoLauncher = centralControl.modulecoLauncher;
        this.graphicalWatcher = this.modulecoLauncher.getGraphicalWatcher();
        this.setLayout(new BorderLayout());
        this.jPanelButton = new JPanel(new FlowLayout(1));
        this.jButtonAnnuler = new JButton(XMLGuiReader.getLabel("Default/ButtonCancel"));
        this.jButtonSuivant = new JButton(XMLGuiReader.getLabel("Default/ButtonNext"));
        this.jButtonPrecedent = new JButton(XMLGuiReader.getLabel("Default/ButtonBack"));
        this.jButtonAfficher = new JButton(XMLGuiReader.getLabel("Default/ButtonCancel"));
        this.jButtonTerminer = new JButton(XMLGuiReader.getLabel("Default/ButtonFinish"));
        this.jButtonAnnuler.addActionListener(this);
        this.jButtonSuivant.addActionListener(this);
        this.jButtonAfficher.addActionListener(this);
        this.jButtonPrecedent.addActionListener(this);
        this.jButtonTerminer.addActionListener(this);
        this.jButtonPrecedent.setEnabled(false);
        this.jButtonTerminer.setEnabled(false);
        this.jPanelButton.add(this.jButtonAnnuler);
        this.jPanelButton.add(this.jButtonPrecedent);
        this.jPanelButton.add(this.jButtonSuivant);
        this.jPanelButton.add(this.jButtonTerminer);
        this.jPanelCreateSeries = new JPanelCreateSeries(this.graphicalWatcher);
        this.add((Component)this.jPanelCreateSeries, "Center");
        this.add((Component)this.jPanelButton, "South");
        this.jDialog = this.createDialog(component);
    }

    public int showCreateDynamicChart() {
        this.jDialog.pack();
        this.jDialog.setSize(800, 600);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.jDialog.setLocation((dimension.width - this.jDialog.getWidth()) / 2, (dimension.height - this.jDialog.getHeight()) / 2);
        this.jDialog.setVisible(true);
        return 1;
    }

    protected JDialog createDialog(Component component) throws HeadlessException {
        Container container = SwingUtilities.getAncestorOfClass(JFrame.class, component);
        if (container != null) {
            JDialog jDialog = new JDialog((JFrame)container);
            jDialog.getContentPane().add(this);
            jDialog.setModal(true);
            jDialog.setTitle(XMLGuiReader.getLabel("JCreateDynamicChart/Frame"));
            jDialog.invalidate();
            jDialog.repaint();
            return jDialog;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.jButtonAnnuler)) {
            this.jDialog.setVisible(false);
        } else if (actionEvent.getSource().equals(this.jButtonSuivant)) {
            this.dynamicLineChart = new DynamicLineChart(this.jPanelCreateSeries.getWatcher());
            this.dynamicPieChart = new DynamicPieChart(this.jPanelCreateSeries.getWatcher());
            this.dynamicBarChart = new DynamicBarChart(this.jPanelCreateSeries.getWatcher());
            this.remove(this.jPanelCreateSeries);
            this.jPanelConfigChart = new JPanelConfigChart(this.dynamicLineChart, this.dynamicPieChart, this.dynamicBarChart, this.defaultTypeChart);
            this.jButtonPrecedent.setEnabled(true);
            this.jButtonSuivant.setEnabled(false);
            this.jButtonTerminer.setEnabled(true);
            this.add((Component)this.jPanelConfigChart, "Center");
            this.validate();
            this.repaint();
        } else if (actionEvent.getSource().equals(this.jButtonPrecedent)) {
            this.remove(this.jPanelConfigChart);
            this.add((Component)this.jPanelCreateSeries, "Center");
            this.jButtonPrecedent.setEnabled(false);
            this.jButtonSuivant.setEnabled(true);
            this.jButtonTerminer.setEnabled(false);
            this.validate();
            this.repaint();
        } else if (actionEvent.getSource().equals(this.jButtonTerminer)) {
            int n = -1;
            if (this.jPanelConfigChart != null) {
                n = this.jPanelConfigChart.getShowGraph();
            }
            if (n == -1) {
                n = this.defaultTypeChart;
            }
            if (n == CentralControl.LINE_CHART) {
                this.centralControl.addDynamicAgentRepresentation(this.dynamicLineChart);
            } else if (n == CentralControl.PIE_CHART) {
                this.centralControl.addDynamicAgentRepresentation(this.dynamicPieChart);
            } else if (n == CentralControl.BAR_CHART) {
                this.centralControl.addDynamicAgentRepresentation(this.dynamicBarChart);
            }
            this.setVisible(false);
            this.jDialog.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("Afficher")) {
            this.jPanelCreateSeries.afficher();
        }
    }

    class JPanelConfigChart
    extends JPanel
    implements ActionListener {
        DynamicLineChart dynamicLineChart;
        DynamicPieChart dynamicPieChart;
        DynamicBarChart dynamicBarChart;
        JPanel jPanelTypeGraphique;
        JPanel jPanelOptionGraphique;
        JPanel jPanelApercuGraphique;
        JRadioButton jRadioButtonLineChart;
        JRadioButton jRadioButtonPieChart;
        JRadioButton jRadioButtonBarChart;
        JLabel jLabelLineChart;
        JLabel jLabelPieChart;
        JLabel jLabelBarChart;
        JLabel jLabelTitle;
        JLabel jLabelX;
        JLabel jLabelY;
        JTextField jTextFieldTitle;
        JTextField jTextFieldX;
        JTextField jTextFieldY;
        ButtonGroup buttonGroup;
        int showGraph = -1;

        public JPanelConfigChart(DynamicLineChart dynamicLineChart, DynamicPieChart dynamicPieChart, DynamicBarChart dynamicBarChart, int n) {
            this.dynamicLineChart = dynamicLineChart;
            this.dynamicPieChart = dynamicPieChart;
            this.dynamicBarChart = dynamicBarChart;
            this.setLayout(new GridBagLayout());
            this.showGraph = n;
            this.build();
        }

        public void build() {
            GridLayout gridLayout = new GridLayout(3, 2);
            gridLayout.setVgap(10);
            this.jPanelTypeGraphique = new JPanel(gridLayout);
            this.jPanelOptionGraphique = new JPanel(new GridBagLayout());
            this.jPanelApercuGraphique = new JPanel(new BorderLayout());
            this.jPanelTypeGraphique.setBorder(BorderFactory.createTitledBorder("Choix du type de graphique : "));
            this.jPanelOptionGraphique.setBorder(BorderFactory.createTitledBorder("Option du graphique : "));
            this.jPanelApercuGraphique.setBorder(BorderFactory.createTitledBorder("Aper\ufffdu du graphique : "));
            this.jRadioButtonLineChart = this.makeJRadioButton("Line Chart", "courbe.gif");
            this.jRadioButtonPieChart = this.makeJRadioButton("Pie Chart", "camenbert.gif");
            this.jRadioButtonBarChart = this.makeJRadioButton("Bar Chart", "histo.gif");
            this.jRadioButtonLineChart.setSelected(true);
            this.jRadioButtonLineChart.addActionListener(this);
            this.jRadioButtonPieChart.addActionListener(this);
            this.jRadioButtonBarChart.addActionListener(this);
            this.jLabelLineChart = this.makeJLabelTitle(null, "courbe.gif");
            this.jLabelPieChart = this.makeJLabelTitle(null, "camenbert.gif");
            this.jLabelBarChart = this.makeJLabelTitle(null, "histo.gif");
            this.jLabelTitle = new JLabel("Titre :");
            this.jLabelX = new JLabel("Label axes des X :");
            this.jLabelY = new JLabel("Label axes des Y :");
            final JFreeChart jFreeChart = this.dynamicLineChart.getChart();
            final JFreeChart jFreeChart2 = this.dynamicBarChart.getChart();
            final JFreeChart jFreeChart3 = this.dynamicPieChart.getChart();
            final XYPlot xYPlot = jFreeChart.getXYPlot();
            final CategoryPlot categoryPlot = (CategoryPlot)this.dynamicBarChart.getChart().getPlot();
            this.jTextFieldTitle = new JTextField();
            this.jTextFieldTitle.setText(jFreeChart.getTitle().getText());
            this.jTextFieldX = new JTextField();
            this.jTextFieldX.setText(xYPlot.getDomainAxis().getLabel());
            this.jTextFieldY = new JTextField();
            this.jTextFieldY.setText(xYPlot.getRangeAxis().getLabel());
            this.jTextFieldTitle.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        jFreeChart.setTitle(JPanelConfigChart.this.jTextFieldTitle.getText());
                        jFreeChart3.setTitle(JPanelConfigChart.this.jTextFieldTitle.getText());
                        jFreeChart2.setTitle(JPanelConfigChart.this.jTextFieldTitle.getText());
                        JPanelConfigChart.this.dynamicLineChart.repaint();
                        JPanelConfigChart.this.dynamicBarChart.repaint();
                        JPanelConfigChart.this.dynamicPieChart.repaint();
                    }
                }
            });
            this.jTextFieldTitle.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    jFreeChart.setTitle(JPanelConfigChart.this.jTextFieldTitle.getText());
                    jFreeChart3.setTitle(JPanelConfigChart.this.jTextFieldTitle.getText());
                    jFreeChart2.setTitle(JPanelConfigChart.this.jTextFieldTitle.getText());
                    JPanelConfigChart.this.dynamicLineChart.repaint();
                    JPanelConfigChart.this.dynamicBarChart.repaint();
                    JPanelConfigChart.this.dynamicPieChart.repaint();
                }
            });
            this.jTextFieldX.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        xYPlot.getDomainAxis().setLabel(JPanelConfigChart.this.jTextFieldX.getText());
                        JPanelConfigChart.this.dynamicLineChart.repaint();
                    }
                }
            });
            this.jTextFieldX.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    xYPlot.getDomainAxis().setLabel(JPanelConfigChart.this.jTextFieldX.getText());
                    JPanelConfigChart.this.dynamicLineChart.repaint();
                }
            });
            this.jTextFieldY.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        xYPlot.getRangeAxis().setLabel(JPanelConfigChart.this.jTextFieldY.getText());
                        categoryPlot.getRangeAxis().setLabel(JPanelConfigChart.this.jTextFieldY.getText());
                        JPanelConfigChart.this.dynamicLineChart.repaint();
                        JPanelConfigChart.this.dynamicBarChart.repaint();
                    }
                }
            });
            this.jTextFieldY.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    xYPlot.getRangeAxis().setLabel(JPanelConfigChart.this.jTextFieldY.getText());
                    categoryPlot.getRangeAxis().setLabel(JPanelConfigChart.this.jTextFieldY.getText());
                    JPanelConfigChart.this.dynamicLineChart.repaint();
                    JPanelConfigChart.this.dynamicBarChart.repaint();
                }
            });
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.jRadioButtonLineChart);
            this.buttonGroup.add(this.jRadioButtonPieChart);
            this.buttonGroup.add(this.jRadioButtonBarChart);
            this.jPanelTypeGraphique.add(this.jLabelLineChart);
            this.jPanelTypeGraphique.add(this.jRadioButtonLineChart);
            this.jPanelTypeGraphique.add(this.jLabelPieChart);
            this.jPanelTypeGraphique.add(this.jRadioButtonPieChart);
            this.jPanelTypeGraphique.add(this.jLabelBarChart);
            this.jPanelTypeGraphique.add(this.jRadioButtonBarChart);
            this.jPanelOptionGraphique.add((Component)this.jLabelTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jPanelOptionGraphique.add((Component)this.jTextFieldTitle, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jPanelOptionGraphique.add((Component)this.jLabelX, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jPanelOptionGraphique.add((Component)this.jTextFieldX, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jPanelOptionGraphique.add((Component)this.jLabelY, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jPanelOptionGraphique.add((Component)this.jTextFieldY, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.jPanelApercuGraphique.add((Component)this.dynamicLineChart, "Center");
            this.add((Component)this.jPanelTypeGraphique, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.jPanelApercuGraphique, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.jPanelOptionGraphique, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            if (this.showGraph == CentralControl.BAR_CHART) {
                this.jRadioButtonBarChart.setSelected(true);
                this.displayBarChart();
            } else if (this.showGraph == CentralControl.PIE_CHART) {
                this.jRadioButtonPieChart.setSelected(true);
                this.displayPieChart();
            } else if (this.showGraph == CentralControl.LINE_CHART) {
                this.jRadioButtonLineChart.setSelected(true);
                this.displayLineChart();
            }
        }

        public void displayBarChart() {
            try {
                this.jPanelApercuGraphique.remove(this.dynamicPieChart);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.jPanelApercuGraphique.remove(this.dynamicLineChart);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jPanelApercuGraphique.add((Component)this.dynamicBarChart, "Center");
            this.jLabelX.setEnabled(false);
            this.jLabelY.setEnabled(true);
            this.jTextFieldX.setEnabled(true);
            this.jTextFieldY.setEnabled(true);
            this.jPanelApercuGraphique.validate();
            this.jPanelApercuGraphique.repaint();
        }

        public void displayLineChart() {
            try {
                this.jPanelApercuGraphique.remove(this.dynamicPieChart);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.jPanelApercuGraphique.remove(this.dynamicBarChart);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jPanelApercuGraphique.add((Component)this.dynamicLineChart, "Center");
            this.jLabelX.setEnabled(true);
            this.jLabelY.setEnabled(true);
            this.jTextFieldX.setEnabled(true);
            this.jTextFieldY.setEnabled(true);
            this.jPanelApercuGraphique.validate();
            this.jPanelApercuGraphique.repaint();
        }

        public void displayPieChart() {
            try {
                this.jPanelApercuGraphique.remove(this.dynamicLineChart);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.jPanelApercuGraphique.remove(this.dynamicBarChart);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jPanelApercuGraphique.add((Component)this.dynamicPieChart, "Center");
            this.jLabelX.setEnabled(false);
            this.jLabelY.setEnabled(false);
            this.jTextFieldX.setEnabled(false);
            this.jTextFieldY.setEnabled(false);
            this.jPanelApercuGraphique.validate();
            this.jPanelApercuGraphique.repaint();
        }

        public JLabel makeJLabelTitle(String string, String string2) {
            JLabel jLabel;
            try {
                URL uRL = this.getClass().getResource("/images/JPanelGraphicOutputs/" + string2);
                ImageIcon imageIcon = new ImageIcon(uRL, "img");
                jLabel = new JLabel(string, imageIcon, 4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                jLabel = new JLabel(string);
            }
            return jLabel;
        }

        public JRadioButton makeJRadioButton(String string, String string2) {
            JRadioButton jRadioButton;
            try {
                Image image = Toolkit.getDefaultToolkit().createImage("images/JPanelGraphicOutputs/" + string2);
                ImageIcon imageIcon = new ImageIcon(image, "img");
                jRadioButton = new JRadioButton(string);
            }
            catch (Exception exception) {
                jRadioButton = new JRadioButton(string);
            }
            return jRadioButton;
        }

        public int getShowGraph() {
            return this.showGraph;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.jRadioButtonPieChart)) {
                this.showGraph = 1;
                this.displayPieChart();
            } else if (actionEvent.getSource().equals(this.jRadioButtonLineChart)) {
                this.showGraph = 0;
                this.displayLineChart();
            } else if (actionEvent.getSource().equals(this.jRadioButtonBarChart)) {
                this.showGraph = 2;
                this.displayBarChart();
            }
        }
    }

    class JPanelCreateSeries
    extends JPanel
    implements ActionListener {
        GraphicalWatcher graphicalWatcher;
        JPanel jPanelContent;
        JPanel jPanelChoiceAGR;
        JPanel jPanelOperations;
        JPanel jPanelSupportOperation;
        JPanelOperation1 jPanelOperation1;
        JPanelOperation2 jPanelOperation2;
        JPanelOperation3 jPanelOperation3;
        JLabel jLabelCommunity;
        JLabel jLabelGroup;
        JLabel jLabelRole;
        JLabel jLabelList;
        JLabel jLabelTypeOperation;
        JLabel jLabelAvertissement;
        JComboBox jComboBoxCommunities;
        JComboBox jComboBoxGroups;
        JComboBox jComboBoxRoles;
        JList jListAgent;
        JRadioButton jRadioButtonOperation1;
        JRadioButton jRadioButtonOperation2;
        JRadioButton jRadioButtonOperation3;
        ButtonGroup buttonGroup;
        NormalWatcher normalWatcher;
        AutoCountWatcher autoCountWatcher;
        CountWatcher countWatcher;
        String choosenCommunity = "";
        String choosenGroup = "";
        String choosenRole = "";
        Map hashMapLink;

        public JPanelCreateSeries(GraphicalWatcher graphicalWatcher) {
            this.graphicalWatcher = graphicalWatcher;
            this.setLayout(new BorderLayout());
            this.normalWatcher = graphicalWatcher.createNormalWatcher();
            this.autoCountWatcher = graphicalWatcher.createAutoCountWatcher();
            this.countWatcher = graphicalWatcher.createCountWatcher();
            this.hashMapLink = new HashMap();
            this.build();
        }

        public void afficher() {
            this.normalWatcher.afficher();
        }

        public NormalWatcher getLineWatcher() {
            return this.normalWatcher;
        }

        private void build() {
            this.jPanelContent = new JPanel(new BorderLayout());
            this.jPanelChoiceAGR = new JPanel(new GridBagLayout());
            this.jPanelOperations = new JPanel(new GridBagLayout());
            this.jPanelSupportOperation = new JPanel(new BorderLayout());
            this.jPanelChoiceAGR.setBorder(BorderFactory.createTitledBorder("Choix Communaut\ufffd - Groupe - Role"));
            this.jPanelOperations.setBorder(BorderFactory.createTitledBorder("Operations"));
            this.jPanelOperation1 = new JPanelOperation1(this.normalWatcher);
            this.jPanelOperation2 = new JPanelOperation2(this.autoCountWatcher);
            this.jPanelOperation3 = new JPanelOperation3(this.countWatcher);
            this.jLabelCommunity = new JLabel("Communaut\ufffd : ");
            this.jLabelGroup = new JLabel("Group : ");
            this.jLabelRole = new JLabel("Role : ");
            this.jLabelList = new JLabel("List : ");
            this.jLabelTypeOperation = new JLabel("Types d'op\ufffdrations : ");
            this.jLabelAvertissement = new JLabel(MESSAGE_NO_AGENT);
            this.jLabelAvertissement.setForeground(Color.red);
            this.jComboBoxCommunities = new JComboBox<String>(this.graphicalWatcher.getCommunities());
            this.jComboBoxGroups = new JComboBox();
            this.jComboBoxRoles = new JComboBox();
            this.jListAgent = new JList<String>(new String[0]);
            this.jRadioButtonOperation1 = new JRadioButton("Op\ufffdrations Arithm\ufffdtiques");
            this.jRadioButtonOperation2 = new JRadioButton("Count");
            this.jRadioButtonOperation3 = new JRadioButton("Advanced Count");
            this.jRadioButtonOperation1.addActionListener(this);
            this.jRadioButtonOperation2.addActionListener(this);
            this.jRadioButtonOperation3.addActionListener(this);
            this.jRadioButtonOperation1.setSelected(true);
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.jRadioButtonOperation1);
            this.buttonGroup.add(this.jRadioButtonOperation2);
            this.buttonGroup.add(this.jRadioButtonOperation3);
            this.jComboBoxCommunities.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanelCreateSeries.this.choosenCommunity = (String)JPanelCreateSeries.this.jComboBoxCommunities.getSelectedItem();
                    JPanelCreateSeries.this.jPanelOperation1.setChoosenCommunity(JPanelCreateSeries.this.choosenCommunity);
                    JPanelCreateSeries.this.jPanelOperation2.setChoosenCommunity(JPanelCreateSeries.this.choosenCommunity);
                    JPanelCreateSeries.this.jPanelOperation3.setChoosenCommunity(JPanelCreateSeries.this.choosenCommunity);
                    JPanelCreateSeries.this.jComboBoxGroups.removeAllItems();
                    String[] stringArray = JPanelCreateSeries.this.graphicalWatcher.getGroups(JPanelCreateSeries.this.choosenCommunity);
                    for (int i = 0; i < stringArray.length; ++i) {
                        JPanelCreateSeries.this.jComboBoxGroups.addItem(stringArray[i]);
                    }
                }
            });
            this.jComboBoxGroups.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanelCreateSeries.this.choosenGroup = (String)JPanelCreateSeries.this.jComboBoxGroups.getSelectedItem();
                    JPanelCreateSeries.this.jPanelOperation1.setChoosenGroup(JPanelCreateSeries.this.choosenGroup);
                    JPanelCreateSeries.this.jPanelOperation2.setChoosenGroup(JPanelCreateSeries.this.choosenGroup);
                    JPanelCreateSeries.this.jPanelOperation3.setChoosenGroup(JPanelCreateSeries.this.choosenGroup);
                    JPanelCreateSeries.this.jComboBoxRoles.removeAllItems();
                    String[] stringArray = JPanelCreateSeries.this.graphicalWatcher.getRoles(JPanelCreateSeries.this.choosenCommunity, JPanelCreateSeries.this.choosenGroup);
                    for (int i = 0; i < stringArray.length; ++i) {
                        JPanelCreateSeries.this.jComboBoxRoles.addItem(stringArray[i]);
                    }
                }
            });
            this.jComboBoxRoles.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanelCreateSeries.this.choosenRole = (String)JPanelCreateSeries.this.jComboBoxRoles.getSelectedItem();
                    JPanelCreateSeries.this.jPanelOperation1.setChoosenRole(JPanelCreateSeries.this.choosenRole);
                    JPanelCreateSeries.this.jPanelOperation2.setChoosenRole(JPanelCreateSeries.this.choosenRole);
                    JPanelCreateSeries.this.jPanelOperation3.setChoosenRole(JPanelCreateSeries.this.choosenRole);
                    Probe probe = JPanelCreateSeries.this.graphicalWatcher.createProbe(JPanelCreateSeries.this.choosenCommunity, JPanelCreateSeries.this.choosenGroup, JPanelCreateSeries.this.choosenRole);
                    DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
                    boolean bl = true;
                    Class<?> clazz = null;
                    ListIterator listIterator = probe.getAgentsIterator();
                    while (listIterator.hasNext()) {
                        AbstractAgent abstractAgent = (AbstractAgent)listIterator.next();
                        Class<?> clazz2 = abstractAgent.getClass();
                        if (clazz != null && !clazz.equals(clazz2)) {
                            bl = false;
                        }
                        clazz = clazz2;
                        defaultListModel.addElement(abstractAgent.getName());
                    }
                    JPanelCreateSeries.this.jListAgent.setModel(defaultListModel);
                    if (!bl) {
                        JPanelCreateSeries.this.jLabelAvertissement.setText(MESSAGE_AGENT_WITH_DIFF_CLASS);
                    } else if (probe.getCurrentAgentsList().size() == 0) {
                        JPanelCreateSeries.this.jLabelAvertissement.setText(MESSAGE_NO_AGENT);
                    } else {
                        JPanelCreateSeries.this.jLabelAvertissement.setText("");
                    }
                    JPanelCreateSeries.this.jPanelOperation1.setObject(probe.getAgentNb(0));
                    JPanelCreateSeries.this.jPanelOperation2.setObject(probe.getAgentNb(0));
                    JPanelCreateSeries.this.jPanelOperation3.setObject(probe.getAgentNb(0));
                }
            });
            this.jPanelChoiceAGR.add((Component)this.jLabelCommunity, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.jPanelChoiceAGR.add((Component)this.jComboBoxCommunities, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jPanelChoiceAGR.add((Component)this.jLabelGroup, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jPanelChoiceAGR.add((Component)this.jComboBoxGroups, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jPanelChoiceAGR.add((Component)this.jLabelRole, new GridBagConstraints(0, 4, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jPanelChoiceAGR.add((Component)this.jComboBoxRoles, new GridBagConstraints(0, 5, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jPanelChoiceAGR.add((Component)this.jLabelList, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jPanelChoiceAGR.add((Component)new JScrollPane(this.jListAgent), new GridBagConstraints(1, 1, 1, 5, 0.5, 0.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.jPanelChoiceAGR.add((Component)this.jLabelAvertissement, new GridBagConstraints(0, 6, 2, 1, 0.5, 0.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.jPanelSupportOperation.add((Component)this.jPanelOperation1, "Center");
            this.jPanelOperations.add((Component)this.jLabelTypeOperation, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jPanelOperations.add((Component)this.jRadioButtonOperation1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.jPanelOperations.add((Component)this.jRadioButtonOperation2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.jPanelOperations.add((Component)this.jRadioButtonOperation3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.jPanelOperations.add((Component)this.jPanelSupportOperation, new GridBagConstraints(0, 2, 3, 3, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.jPanelContent.add((Component)this.jPanelChoiceAGR, "North");
            this.jPanelContent.add((Component)this.jPanelOperations, "Center");
            this.add((Component)this.jPanelContent, "Center");
            this.jComboBoxCommunities.setSelectedItem("moduleco");
            this.jComboBoxGroups.setSelectedItem("ecoAgent");
            this.jComboBoxRoles.setSelectedItem("basicAgent");
        }

        public AbstractChartWatcher getWatcher() {
            if (this.jRadioButtonOperation1.isSelected()) {
                return this.normalWatcher;
            }
            if (this.jRadioButtonOperation2.isSelected()) {
                return this.autoCountWatcher;
            }
            if (this.jRadioButtonOperation3.isSelected()) {
                return this.countWatcher;
            }
            return this.normalWatcher;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.jRadioButtonOperation1)) {
                this.jPanelSupportOperation.remove(0);
                this.jPanelSupportOperation.add((Component)this.jPanelOperation1, "Center");
                this.jPanelSupportOperation.validate();
                this.jPanelSupportOperation.repaint();
            } else if (actionEvent.getSource().equals(this.jRadioButtonOperation2)) {
                this.jPanelSupportOperation.remove(0);
                this.jPanelSupportOperation.add((Component)this.jPanelOperation2, "Center");
                this.jPanelSupportOperation.validate();
                this.jPanelSupportOperation.repaint();
            } else if (actionEvent.getSource().equals(this.jRadioButtonOperation3)) {
                this.jPanelSupportOperation.remove(0);
                this.jPanelSupportOperation.add((Component)this.jPanelOperation3, "Center");
                this.jPanelSupportOperation.validate();
                this.jPanelSupportOperation.repaint();
            }
        }
    }
}

