/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.grapheco.graphix;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Icon;
import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.utils.dataRecorder.StatRecorder;
import modulecoGUI.CentralControl;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;
import modulecoGUI.grapheco.CAgentRepresentation;
import modulecoGUI.grapheco.CBufferedCanvas;
import modulecoGUI.grapheco.graphix.Trace;

public class Graphique
extends CBufferedCanvas
implements CAgentRepresentation,
ItemListener {
    private static final long serialVersionUID = -6095985382249188468L;
    public EWorld eWorld;
    public StatRecorder statRecorder;
    protected ArrayList arrayListTraces = new ArrayList();
    protected Hashtable hashCheckBoxItems = new Hashtable();
    protected int refresh = 1;
    protected int numTraces;
    public String name = "Graphique";
    protected int yMin = 0;
    protected int yMax = 100;
    protected int yMaxI = 100;
    protected int yInter;
    protected int xMin = 0;
    protected int xBase = 0;
    protected int xMaxI = 5;
    protected int xMax = 5;
    protected int xInter;
    protected int xInterI;
    protected int northInset;
    protected int southInset;
    protected int westInset;
    protected int eastInset;

    public Graphique() {
    }

    public Graphique(CAgentRepresentation cAgentRepresentation) {
        this();
    }

    public void setStatRecorder(StatRecorder statRecorder) {
        this.statRecorder = statRecorder;
    }

    public void addTrace(Trace trace, boolean bl) {
        this.arrayListTraces.add(trace);
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(trace.getName());
        if (bl) {
            checkboxMenuItem.setState(true);
        }
        checkboxMenuItem.addItemListener(this);
        this.hashCheckBoxItems.put(trace, checkboxMenuItem);
        this.popupMenu.add(checkboxMenuItem);
    }

    public void setCAgent(CAgent cAgent) {
        this.eWorld = (EWorld)cAgent;
        this.DisplayTrace();
        this.setGridSize(this.eWorld.getAgentSetSize());
        this.drawAble = true;
    }

    public void drawTraces(Graphics graphics) {
        for (Trace trace : this.arrayListTraces) {
            int n;
            int n2;
            if (!((CheckboxMenuItem)this.hashCheckBoxItems.get(trace)).getState() || (n2 = 1) > (n = this.statRecorder.getIteration() + 1)) continue;
            graphics.setColor(trace.getColor());
            while (n2 < n) {
                if (trace.getType() == 0) {
                    graphics.drawLine(this.xScreen(n2 - 1), this.yScreen((int)this.statRecorder.getValue(trace.getVarName(), n2 - 1)), this.xScreen(n2), this.yScreen((int)this.statRecorder.getValue(trace.getVarName(), n2)));
                }
                if (trace.getType() == 1) {
                    graphics.fillOval(this.xScreen(n2) - 1, this.yScreen((int)this.statRecorder.getValue(trace.getVarName(), n2)) - 1, 3, 3);
                }
                ++n2;
            }
        }
    }

    public void draw(Graphics graphics) {
        FontMetrics fontMetrics = this.getFontMetrics(graphics.getFont());
        this.southInset = fontMetrics.getHeight() + 2;
        this.eastInset = fontMetrics.stringWidth("" + this.xMax);
        this.northInset = fontMetrics.getHeight() + 2;
        graphics.setColor(Color.lightGray.brighter());
        graphics.fill3DRect(0, 0, this.dimension.width, this.dimension.height, true);
        if (this.drawAble) {
            graphics.setColor(Color.black);
            try {
                int n;
                int n2 = this.statRecorder.getIteration();
                if (n2 > this.xMax) {
                    this.xMax = n2;
                }
                for (Trace trace : this.arrayListTraces) {
                    double d;
                    if (!((CheckboxMenuItem)this.hashCheckBoxItems.get(trace)).getState() || !((d = this.statRecorder.getValue(trace.getVarName())) > (double)this.yMax)) continue;
                    this.yMax = (int)d;
                }
                this.xInter = this.xMax / 5;
                this.yInter = this.yMax / 5;
                for (n = this.yMin; n <= this.yMax; n += this.yInter) {
                    if (fontMetrics.stringWidth("" + n) > this.westInset) {
                        this.westInset = fontMetrics.stringWidth("" + n) + 10;
                    }
                    graphics.drawString("" + n, 5, this.yScreen(n) + 3);
                }
                for (n = this.yMin; n <= this.yMax; n += this.yInter) {
                    graphics.drawLine(this.westInset, this.yScreen(n), this.westInset + 3, this.yScreen(n));
                }
                for (n = this.xMin; n <= this.xMax; n += this.xInter) {
                    graphics.drawString("" + n, this.xScreen(n) - fontMetrics.stringWidth("" + n) / 2, this.dimension.height - 5);
                }
                for (n = this.xMin; n <= this.xMax; n += this.xInter) {
                    graphics.drawLine(this.xScreen(n), this.dimension.height - this.southInset, this.xScreen(n), this.dimension.height - this.southInset - 3);
                }
                graphics.drawLine(this.westInset, this.northInset, this.westInset, this.dimension.height - this.southInset);
                graphics.drawLine(this.westInset, this.dimension.height - this.southInset, this.dimension.width - this.eastInset, this.dimension.height - this.southInset);
                this.drawTraces(graphics);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("grapheco.graphix.Graphique.draw(): statManager > " + exception.toString());
            }
        }
    }

    private int xScreen(int n) {
        return this.westInset + (n - this.xMin) * (this.dimension.width - (this.westInset + this.eastInset)) / (this.xMax - this.xMin);
    }

    private int yScreen(int n) {
        return this.dimension.height - this.southInset - (n - this.yMin) * (this.dimension.height - (this.northInset + this.southInset)) / (this.yMax - this.yMin);
    }

    public void setGridSize(int n) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.resetImage();
    }

    public void DisplayTrace() {
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Icon getIcon() {
        return null;
    }

    public String getDefaultPosition() {
        return AbstractCAgentRepresentation.RIGTH_POSITION;
    }

    public void setDefaultPosition(String string) {
    }

    public CAgent getCAgent() {
        return null;
    }

    public CentralControl getCentralControl() {
        return this.centralControl;
    }

    public void setIcon(Icon icon) {
    }

    public void setCentralControl(CentralControl centralControl) {
        super.setCentralControl(centralControl);
        this.setStatRecorder(centralControl.getStatRecorder());
    }
}

