/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.grapheco.encoders;

import java.io.IOException;
import java.io.OutputStream;
import modulecoGUI.grapheco.encoders.BitUtils;

class ScreenDescriptor {
    public short localScreenWidth_;
    public short localScreenHeight_;
    private byte byte_;
    public byte backgroundColorIndex_;
    public byte pixelAspectRatio_;

    public ScreenDescriptor(short s, short s2, int n) {
        this.localScreenWidth_ = s;
        this.localScreenHeight_ = s2;
        this.SetGlobalColorTableSize((byte)(BitUtils.BitsNeeded(n) - 1));
        this.SetGlobalColorTableFlag((byte)1);
        this.SetSortFlag((byte)0);
        this.SetColorResolution((byte)7);
        this.backgroundColorIndex_ = 0;
        this.pixelAspectRatio_ = 0;
    }

    public void Write(OutputStream outputStream) throws IOException {
        BitUtils.WriteWord(outputStream, this.localScreenWidth_);
        BitUtils.WriteWord(outputStream, this.localScreenHeight_);
        outputStream.write(this.byte_);
        outputStream.write(this.backgroundColorIndex_);
        outputStream.write(this.pixelAspectRatio_);
    }

    public void SetGlobalColorTableSize(byte by) {
        this.byte_ = (byte)(this.byte_ | by & 7);
    }

    public void SetSortFlag(byte by) {
        this.byte_ = (byte)(this.byte_ | (by & 1) << 3);
    }

    public void SetColorResolution(byte by) {
        this.byte_ = (byte)(this.byte_ | (by & 7) << 4);
    }

    public void SetGlobalColorTableFlag(byte by) {
        this.byte_ = (byte)(this.byte_ | (by & 1) << 7);
    }
}

