/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.grapheco;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import javax.swing.Icon;
import modulecoFramework.medium.Medium;
import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.EWorld;
import modulecoGUI.CentralControl;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;
import modulecoGUI.grapheco.CAgentRepresentation;
import modulecoGUI.grapheco.CBufferedCanvas;

public class canvasSmallWorld
extends CBufferedCanvas
implements CAgentRepresentation {
    public String name = "Circle";
    public String defaultPosition = AbstractCAgentRepresentation.LEFT_POSITION;
    protected EWorld eWorld;
    protected char[][] state;
    protected MenuItem menuItemEditAgent;
    protected MenuItem menuItemEditAgentLinks;
    protected MenuItem menuItemEditWorld;
    protected Color[][] c;
    protected Color colorBack;
    protected final Color fondcanvas = Color.lightGray;
    protected int size;
    protected int radius;
    protected int littleradius;
    protected int diameter;
    protected int littlediameter;
    protected int OldAgentID;
    protected int selectedAgentID;
    static double margin = 16.0;
    static double TWO_PI = Math.PI * 2;
    protected Shape agentCircle;
    protected Shape linkArc1;
    protected Shape linkArc;
    protected Shape line;
    protected BasicStroke widePen;
    protected BasicStroke narrowPen;
    protected Cursor canvasCrosshairCursor;
    protected Cursor canvasHandCursor;

    public canvasSmallWorld() {
        this.setColors();
        this.setBackground(this.fondcanvas);
        this.menuItemEditAgent = new MenuItem("Edit Agent");
        this.menuItemEditAgentLinks = new MenuItem("Edit AgentLinks");
        this.menuItemEditWorld = new MenuItem("Edit World");
        this.menuItemEditAgent.addActionListener(this);
        this.menuItemEditAgentLinks.addActionListener(this);
        this.menuItemEditWorld.addActionListener(this);
        this.colorBack = Color.lightGray;
        this.setBackground(this.colorBack);
        this.agentCircle = new Ellipse2D.Double();
        this.linkArc = new Arc2D.Double(0);
        this.linkArc1 = new Arc2D.Double(0);
        this.line = new Line2D.Double();
        this.widePen = new BasicStroke(2.0f, 2, 1);
        this.narrowPen = new BasicStroke(1.0f, 2, 1);
        this.canvasCrosshairCursor = new Cursor(1);
        this.canvasHandCursor = new Cursor(12);
        this.setCursor(this.canvasCrosshairCursor);
    }

    public void setCAgent(CAgent cAgent) {
        this.eWorld = (EWorld)cAgent;
        this.size = new Double(Math.sqrt(this.eWorld.getAgentSetSize())).intValue();
        this.state = new char[this.size * this.size][2];
        for (int i = 0; i < this.size; ++i) {
            this.state[i][0] = (Boolean)((CAgent)this.eWorld.get(i)).getState() != false ? (char)'\u0000' : '\u0001';
            this.state[i][1] = this.state[i][0];
        }
    }

    protected void setColors() {
        this.c = new Color[2][2];
        this.c[0][0] = Color.blue.brighter().brighter().brighter();
        this.c[1][1] = Color.red.darker();
        this.c[1][0] = Color.yellow;
        this.c[0][1] = Color.green;
    }

    protected void drawFirstTime(Graphics graphics) {
        this.draw(graphics);
    }

    public void draw(Graphics graphics) {
        if (graphics != null) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = new Integer(this.getHeight()).doubleValue();
            double d2 = new Integer(this.getWidth()).doubleValue();
            double d3 = 22 - 2 * this.size;
            double d4 = 2.0 * d3;
            double d5 = Math.min(d, d2) - margin * 2.0 - d4;
            double d6 = d5 / 2.0;
            int n2 = this.size * this.size;
            graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.translate(d2 / 2.0, d / 2.0);
            graphics2D.setColor(Color.black.darker().darker());
            graphics2D.setStroke(this.widePen);
            ((Arc2D.Double)this.linkArc1).setFrame(-d6, -d6, d5, d5);
            double d7 = d6;
            double d8 = 0.0;
            double d9 = d6 * Math.cos(TWO_PI / new Integer(n2).doubleValue());
            double d10 = d6 * Math.sin(-TWO_PI / new Integer(n2).doubleValue());
            ((Arc2D.Double)this.linkArc1).setAngles(d7, d8, d9, d10);
            for (n = 0; n < n2; ++n) {
                Medium[] mediumArray = ((CAgent)this.eWorld.get(n)).getMediums();
                ArrayList arrayList = ((NeighbourMedium)mediumArray[0]).getNeighbours();
                for (EAgent eAgent : arrayList) {
                    int n3;
                    int n4 = eAgent.getAgentID();
                    int n5 = (n4 - n + n2) % n2;
                    double d11 = n5 <= (n3 = n2 / 4) ? new Integer(n5).doubleValue() * Math.PI / new Integer(n2).doubleValue() : (n5 >= n2 - n3 ? -new Integer(n2 - n5).doubleValue() * Math.PI / new Integer(n2).doubleValue() : 0.0);
                    double d12 = Math.abs(d6 * Math.cos(d11));
                    double d13 = Math.abs(d6 * Math.sin(d11));
                    ((Arc2D.Double)this.linkArc).setArcByCenter(d12, 0.0, d13, 90.0, 180.0, 0);
                    if (n5 <= n3 || n5 >= n2 - n3) {
                        if (n5 == 1) {
                            graphics2D.rotate(TWO_PI / new Integer(n2).doubleValue());
                            graphics2D.draw(this.linkArc1);
                            graphics2D.rotate(-TWO_PI / new Integer(n2).doubleValue());
                            continue;
                        }
                        if (n5 == n2 - 1) {
                            graphics2D.draw(this.linkArc1);
                            continue;
                        }
                        graphics2D.rotate(d11);
                        graphics2D.draw(this.linkArc);
                        graphics2D.rotate(-d11);
                        continue;
                    }
                    double d14 = d6 * Math.cos((double)n5 * TWO_PI / new Integer(n2).doubleValue());
                    double d15 = d6 * Math.sin((double)n5 * TWO_PI / new Integer(n2).doubleValue());
                    ((Line2D.Double)this.line).setLine(d6, 0.0, d14, d15);
                    graphics2D.draw(this.line);
                }
                graphics2D.rotate(TWO_PI / new Integer(n2).doubleValue());
            }
            ((Ellipse2D.Double)this.agentCircle).setFrameFromCenter(d6, 0.0, d6 + d3, d3);
            for (n = 0; n < n2; ++n) {
                this.DrawAgent(n, graphics2D);
            }
            graphics2D.translate(-d2 / 2.0, -d / 2.0);
        }
    }

    public void DrawAgent(int n, Graphics2D graphics2D) {
        int n2 = n;
        this.state[n2][0] = this.state[n2][1];
        this.state[n2][1] = (Boolean)((CAgent)this.eWorld.get(n2)).getState() != false ? (char)'\u0000' : '\u0001';
        graphics2D.setColor(this.c[this.state[n2][0]][this.state[n2][1]]);
        graphics2D.draw(this.agentCircle);
        graphics2D.fill(this.agentCircle);
        graphics2D.rotate(TWO_PI / new Integer(this.size * this.size).doubleValue());
    }

    /*
     * Unable to fully structure code
     */
    public void mouseClicked(MouseEvent var1_1) {
        block9: {
            block8: {
                var2_2 = 22 - 2 * this.size;
                var4_3 = (double)Math.min(this.dimension.width, this.dimension.height) - canvasSmallWorld.margin * 2.0 - var2_2 * 2.0;
                var6_4 = this.size * this.size;
                var7_5 = 0;
                var1_1.translatePoint(-this.dimension.width / 2, -this.dimension.height / 2);
                var9_6 = var1_1.getX();
                var10_7 = -var1_1.getY();
                var11_8 = Math.sqrt(Math.pow(var9_6, 2.0) + Math.pow(var10_7, 2.0));
                var13_9 = Math.atan2(var10_7, var9_6);
                var15_10 = 2.0 * var2_2 / var4_3;
                while (true) {
                    v0 = new Integer(var6_4);
                    v1 = new Integer(var6_4);
                    if (!(Math.abs(var13_9) / var13_9 * var13_9 - (double)var7_5 * canvasSmallWorld.TWO_PI / v0.doubleValue() >= 3.141592653589793 / v1.doubleValue())) break;
                    ++var7_5;
                }
                var8_11 = var13_9 <= 3.141592653589793 / new Integer(var6_4).doubleValue() ? var7_5 : var6_4 - var7_5;
                if ((var1_1.getModifiers() & 4) != 4) break block8;
                if (!(var11_8 > var4_3 / 2.0 - var2_2) || !(var11_8 < var4_3 / 2.0 + var2_2)) ** GOTO lbl-1000
                v2 = new Integer(var6_4);
                if (!(var13_9 <= Math.abs(var13_9) / var13_9 * (double)var7_5 * canvasSmallWorld.TWO_PI / v2.doubleValue() + var15_10)) ** GOTO lbl-1000
                v3 = new Integer(var6_4);
                if (var13_9 >= Math.abs(var13_9) / var13_9 * (double)var7_5 * canvasSmallWorld.TWO_PI / v3.doubleValue() - var15_10) {
                    this.selectedAgentID = var8_11;
                    this.popupMenu.add(this.menuItemEditAgent);
                    this.popupMenu.add(this.menuItemEditWorld);
                    if (!this.eWorld.getModelParameters().getNeighbourhood().equals("World")) {
                        this.popupMenu.add(this.menuItemEditAgentLinks);
                    }
                } else lbl-1000:
                // 3 sources

                {
                    this.popupMenu.remove(this.menuItemEditAgent);
                    this.popupMenu.remove(this.menuItemEditWorld);
                    if (this.menuItemEditAgentLinks != null) {
                        this.popupMenu.remove(this.menuItemEditAgentLinks);
                    }
                }
                var1_1.translatePoint(this.dimension.width / 2, this.dimension.height / 2);
                super.mouseClicked(var1_1);
                break block9;
            }
            if (var11_8 > var4_3 / 2.0 - var2_2 && var11_8 < var4_3 / 2.0 + var2_2) {
                v4 = new Integer(var6_4);
                if (var13_9 <= Math.abs(var13_9) / var13_9 * (double)var7_5 * canvasSmallWorld.TWO_PI / v4.doubleValue() + var15_10) {
                    v5 = new Integer(var6_4);
                    if (var13_9 >= Math.abs(var13_9) / var13_9 * (double)var7_5 * canvasSmallWorld.TWO_PI / v5.doubleValue() - var15_10) {
                        ((EAgent)this.eWorld.get(var8_11)).inverseState();
                    }
                }
            }
            this.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseMoved(MouseEvent mouseEvent) {
        double d = 22 - 2 * this.size;
        double d2 = (double)Math.min(this.dimension.width, this.dimension.height) - margin * 2.0 - d * 2.0;
        int n = this.size * this.size;
        int n2 = 0;
        mouseEvent.translatePoint(-this.dimension.width / 2, -this.dimension.height / 2);
        int n3 = mouseEvent.getX();
        int n4 = -mouseEvent.getY();
        double d3 = Math.sqrt(Math.pow(n3, 2.0) + Math.pow(n4, 2.0));
        double d4 = Math.atan2(n4, n3);
        double d5 = 2.0 * d / d2;
        while (true) {
            Integer n5 = new Integer(n);
            Integer n6 = new Integer(n);
            if (!(Math.abs(d4) / d4 * d4 - (double)n2 * TWO_PI / n5.doubleValue() >= Math.PI / n6.doubleValue())) break;
            ++n2;
        }
        int n7 = d4 <= Math.PI / new Integer(n).doubleValue() ? n2 : n - n2;
        if (d3 > d2 / 2.0 - d && d3 < d2 / 2.0 + d) {
            Integer n8 = new Integer(n);
            if (d4 <= Math.abs(d4) / d4 * (double)n2 * TWO_PI / n8.doubleValue() + d5) {
                Integer n9 = new Integer(n);
                if (d4 >= Math.abs(d4) / d4 * (double)n2 * TWO_PI / n9.doubleValue() - d5) {
                    if (this.OldAgentID != n7) {
                        System.out.println("Agent  :" + n7);
                        this.OldAgentID = n7;
                    }
                    mouseEvent.translatePoint(this.dimension.width / 2, this.dimension.height / 2);
                    this.setCursor(this.canvasHandCursor);
                    this.setToolTipText(new Integer(n7).toString());
                    return;
                }
            }
        }
        this.setCursor(this.canvasCrosshairCursor);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.menuItemEditAgent)) {
            this.centralControl.editAgent((EAgent)this.eWorld.get(this.selectedAgentID));
        } else if (actionEvent.getSource().equals(this.menuItemEditAgentLinks)) {
            this.centralControl.editAgentLinks((EAgent)this.eWorld.get(this.selectedAgentID));
        } else if (!actionEvent.getSource().equals(this.menuItemEditWorld)) {
            super.actionPerformed(actionEvent);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Icon getIcon() {
        return null;
    }

    public String getDefaultPosition() {
        return this.defaultPosition;
    }

    public void setDefaultPosition(String string) {
    }

    public CAgent getCAgent() {
        return null;
    }

    public void setIcon(Icon icon) {
    }

    public CentralControl getCentralControl() {
        return null;
    }
}

