/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor.editors;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

public class BorderChooser
extends JTabbedPane {
    private Border border = null;
    private static Color color = null;
    private static JPanel previous = null;

    public BorderChooser() {
        Border border = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        Border border2 = BorderFactory.createLineBorder(Color.black);
        Border border3 = BorderFactory.createEtchedBorder();
        Border border4 = BorderFactory.createRaisedBevelBorder();
        Border border5 = BorderFactory.createLoweredBevelBorder();
        Border border6 = BorderFactory.createEmptyBorder();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(border);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.addCompForBorder(border2, "line border", jPanel);
        this.addCompForBorder(border3, "etched border", jPanel);
        this.addCompForBorder(border4, "raised bevel border", jPanel);
        this.addCompForBorder(border5, "lowered bevel border", jPanel);
        this.addCompForBorder(border6, "empty border", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(border);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        ImageIcon imageIcon = new ImageIcon("images/left.gif");
        MatteBorder matteBorder = BorderFactory.createMatteBorder(-1, -1, -1, -1, imageIcon);
        this.addCompForBorder(matteBorder, "matte border (-1,-1,-1,-1,icon)", jPanel2);
        matteBorder = BorderFactory.createMatteBorder(1, 5, 1, 1, Color.red);
        this.addCompForBorder(matteBorder, "matte border (1,5,1,1,Color.red)", jPanel2);
        matteBorder = BorderFactory.createMatteBorder(0, 20, 0, 0, imageIcon);
        this.addCompForBorder(matteBorder, "matte border (0,20,0,0,icon)", jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(border);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("title");
        this.addCompForBorder(titledBorder, "default titled border (default just., default pos.)", jPanel3);
        titledBorder = BorderFactory.createTitledBorder(border2, "title");
        this.addCompForTitledBorder(titledBorder, "titled line border (centered, default pos.)", 2, 0, jPanel3);
        titledBorder = BorderFactory.createTitledBorder(border3, "title");
        this.addCompForTitledBorder(titledBorder, "titled etched border (right just., default pos.)", 3, 0, jPanel3);
        titledBorder = BorderFactory.createTitledBorder(border5, "title");
        this.addCompForTitledBorder(titledBorder, "titled lowered bevel border (default just., above top)", 0, 1, jPanel3);
        titledBorder = BorderFactory.createTitledBorder(border6, "title");
        this.addCompForTitledBorder(titledBorder, "titled empty border (default just., bottom)", 0, 5, jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(border);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        Border border7 = BorderFactory.createLineBorder(Color.red);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border4, border5);
        this.addCompForBorder(compoundBorder, "compound border (two bevels)", jPanel4);
        compoundBorder = BorderFactory.createCompoundBorder(border7, compoundBorder);
        this.addCompForBorder(compoundBorder, "compound border (add a red outline)", jPanel4);
        titledBorder = BorderFactory.createTitledBorder(compoundBorder, "title", 2, 6);
        this.addCompForBorder(titledBorder, "titled compound border (centered, below bottom)", jPanel4);
        this.addTab("Simple", null, jPanel, null);
        this.addTab("Matte", null, jPanel2, null);
        this.addTab("Titled", null, jPanel3, null);
        this.addTab("Compound", null, jPanel4, null);
        this.setSelectedIndex(0);
    }

    void addCompForTitledBorder(TitledBorder titledBorder, String string, int n, int n2, Container container) {
        titledBorder.setTitleJustification(n);
        titledBorder.setTitlePosition(n2);
        this.addCompForBorder(titledBorder, string, container);
    }

    void addCompForBorder(Border border, String string, Container container) {
        JPanel jPanel = new JPanel(false);
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setPreferredSize(new Dimension(180, 20));
        jLabel.setMaximumSize(new Dimension(180, 20));
        jLabel.setMinimumSize(new Dimension(180, 20));
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jLabel);
        jPanel.setBorder(border);
        jPanel.addMouseListener(new ActiveBorderListener(border, jPanel));
        container.add(Box.createRigidArea(new Dimension(0, 10)));
        container.add(jPanel);
    }

    public Border getSelectedBorder() {
        return this.border;
    }

    public void setSelectedBorder(Border border, JPanel jPanel) {
        if (this.border != border) {
            if (previous != null) {
                previous.setBackground(color);
            }
            previous = jPanel;
            color = jPanel.getBackground();
            jPanel.setBackground(UIManager.getColor("Button.select"));
            jPanel.revalidate();
            jPanel.repaint();
        }
        this.border = border;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("BorderChooser");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("Center", new BorderChooser());
        jFrame.pack();
        jFrame.show();
    }

    class ActiveBorderListener
    extends MouseAdapter {
        Border b;
        JPanel p;

        public ActiveBorderListener(Border border, JPanel jPanel) {
            this.b = border;
            this.p = jPanel;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            String string;
            TitledBorder titledBorder;
            BorderChooser.this.setSelectedBorder(this.b, this.p);
            if (mouseEvent.getClickCount() == 2 && this.b instanceof TitledBorder && (titledBorder = (TitledBorder)this.b).getTitle() != null && (string = JOptionPane.showInputDialog(this.p, (Object)"Please Enter Title String: ")) != null) {
                titledBorder.setTitle(string);
            }
        }
    }
}

