/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import modulecoGUI.cAgentEditor.BeanInfoFactory;
import modulecoGUI.cAgentEditor.DescriptorComparator;
import modulecoGUI.cAgentEditor.editors.SwingBooleanEditor;
import modulecoGUI.cAgentEditor.editors.SwingBorderEditor;
import modulecoGUI.cAgentEditor.editors.SwingColorEditor;
import modulecoGUI.cAgentEditor.editors.SwingDimensionEditor;
import modulecoGUI.cAgentEditor.editors.SwingDoubleEditor;
import modulecoGUI.cAgentEditor.editors.SwingFontEditor;
import modulecoGUI.cAgentEditor.editors.SwingInsetsEditor;
import modulecoGUI.cAgentEditor.editors.SwingIntegerEditor;
import modulecoGUI.cAgentEditor.editors.SwingNumberEditor;
import modulecoGUI.cAgentEditor.editors.SwingObjectEditor;
import modulecoGUI.cAgentEditor.editors.SwingPointEditor;
import modulecoGUI.cAgentEditor.editors.SwingRectangleEditor;
import modulecoGUI.cAgentEditor.editors.SwingStringEditor;
import modulecoGUI.cAgentEditor.editors.URLEditor;

public class PropertyTableModel
extends AbstractTableModel {
    private PropertyDescriptor[] descriptors;
    private BeanDescriptor beanDescriptor;
    private BeanInfo info;
    private Object bean;
    private String[] inputParameters;
    private static Hashtable propEditors;
    private static DescriptorComparator comparator;
    private static final int NUM_COLUMNS = 4;
    public static final int COL_NAME = 0;
    public static final int COL_VALUE = 1;
    public static final int COL_PARAMETER = 2;
    public static final int COL_HELP = 3;
    public static final int VIEW_ALL = 0;
    public static final int VIEW_STANDARD = 1;
    public static final int VIEW_EXPERT = 2;
    public static final int VIEW_READ_ONLY = 3;
    public static final int VIEW_BOUND = 4;
    public static final int VIEW_CONSTRAINED = 5;
    public static final int VIEW_HIDDEN = 6;
    public static final int VIEW_PREFERRED = 7;
    private int currentFilter = 1;
    public static final int SORT_DEF = 0;
    public static final int SORT_NAME = 1;
    public static final int SORT_TYPE = 2;
    private int sortOrder = 1;
    HashMap hashMapChoiceValue;
    HashMap hashMapChoiceString;

    public PropertyTableModel() {
        if (propEditors == null) {
            propEditors = new Hashtable();
            PropertyTableModel.registerPropertyEditors();
        }
    }

    public PropertyTableModel(Object object) {
        this();
        this.setObject(object);
    }

    public void setFilter(int n) {
        this.filterTable(n);
    }

    public int getFilter() {
        return this.currentFilter;
    }

    public void setSortOrder(int n) {
        this.sortOrder = n;
        this.sortTable(this.sortOrder);
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setObject(Object object) {
        this.bean = object;
        this.info = BeanInfoFactory.getBeanInfo(object);
        this.currentFilter = 0;
        try {
            Field field = object.getClass().getField("inputParameters");
            this.inputParameters = (String[])field.get(object);
            this.currentFilter = 1;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        if (this.info != null) {
            this.beanDescriptor = this.info.getBeanDescriptor();
            this.filterTable(this.getFilter());
        }
    }

    public Object getObject() {
        return this.bean;
    }

    public int getRowCount() {
        if (this.descriptors == null) {
            return 0;
        }
        return this.descriptors.length;
    }

    public int getColumnCount() {
        return 4;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 1 && this.descriptors != null) {
            return this.descriptors[n].getWriteMethod() != null;
        }
        return n2 == 2;
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n2 == 0) {
            object = this.descriptors[n].getDisplayName();
        } else if (n2 == 1) {
            Method method = this.descriptors[n].getReadMethod();
            if (method != null) {
                Class<?>[] classArray = method.getParameterTypes();
                Object[] objectArray = new Object[classArray.length];
                try {
                    for (int i = 0; i < classArray.length; ++i) {
                        System.out.println("\tShouldn't happen! getValueAt getter = " + method + " parameter = " + classArray[i]);
                        objectArray[i] = classArray[i].newInstance();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    object = method.invoke(this.bean, objectArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    System.out.println("NoSuchMethodError for method invocation");
                    System.out.println("Bean: " + this.bean.toString());
                    System.out.println("Getter: " + method.getName());
                    System.out.println("Getter args: ");
                    for (int i = 0; i < objectArray.length; ++i) {
                        System.out.println("\ttype: " + classArray[i] + " value: " + objectArray[i]);
                    }
                    noSuchMethodError.printStackTrace();
                }
            }
        } else {
            object = new Object();
        }
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 1 || this.descriptors == null || n > this.descriptors.length) {
            return;
        }
        Method method = this.descriptors[n].getWriteMethod();
        if (method != null) {
            try {
                method.invoke(this.bean, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Setter: " + method + "\nArgument: " + object.getClass().toString());
                System.out.println("Row: " + n + " Column: " + n2);
                illegalArgumentException.printStackTrace();
                System.out.println("\n");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Setter: " + method + "\nArgument: " + object.getClass().toString());
                System.out.println("Row: " + n + " Column: " + n2);
                illegalAccessException.printStackTrace();
                System.out.println("\n");
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("Setter: " + method + "\nArgument: " + object.getClass().toString());
                System.out.println("Row: " + n + " Column: " + n2);
                invocationTargetException.printStackTrace();
                System.out.println("\n");
            }
        }
    }

    public Class getPropertyType(int n) {
        return this.descriptors[n].getPropertyType();
    }

    public PropertyDescriptor getPropertyDescriptor(int n) {
        return this.descriptors[n];
    }

    public PropertyEditor getPropertyEditor(int n) {
        Class<?> clazz = this.descriptors[n].getPropertyEditorClass();
        PropertyEditor propertyEditor = null;
        if (clazz != null) {
            try {
                propertyEditor = (PropertyEditor)clazz.newInstance();
            }
            catch (Exception exception) {
                System.out.println("PropertyTableModel: Instantiation exception creating PropertyEditor");
            }
        } else {
            Class clazz2 = this.getPropertyType(n);
            if (clazz2 != null) {
                propertyEditor = (PropertyEditor)propEditors.get(clazz2);
                if (propertyEditor == null && (propertyEditor = PropertyEditorManager.findEditor(clazz2)) != null) {
                    propEditors.put(clazz2, propertyEditor);
                }
                if (propertyEditor == null && (propertyEditor = (PropertyEditor)propEditors.get(Object.class)) == null && (propertyEditor = PropertyEditorManager.findEditor(Object.class)) != null) {
                    propEditors.put(Object.class, propertyEditor);
                }
            }
        }
        return propertyEditor;
    }

    public boolean hasCustomizer() {
        if (this.beanDescriptor != null) {
            Class<?> clazz = this.beanDescriptor.getCustomizerClass();
            return clazz != null;
        }
        return false;
    }

    public Component getCustomizer() {
        Class<?> clazz;
        Component component = null;
        if (this.beanDescriptor != null && (clazz = this.beanDescriptor.getCustomizerClass()) != null) {
            try {
                component = (Component)clazz.newInstance();
            }
            catch (Exception exception) {
                System.out.println("PropertyTableModel: Instantiation exception creating Customizer");
            }
        }
        return component;
    }

    public void sortTable(int n) {
        if (n == 0 || this.descriptors == null) {
            return;
        }
        if (n == 1) {
            Arrays.sort(this.descriptors, comparator);
        } else {
            Arrays.sort(this.descriptors, comparator);
        }
        this.fireTableDataChanged();
    }

    private void filterTable(int n) {
        if (this.info == null) {
            return;
        }
        this.currentFilter = n;
        ArrayList<PropertyDescriptor> arrayList = null;
        this.descriptors = this.info.getPropertyDescriptors();
        switch (n) {
            case 2: {
                arrayList = new ArrayList<PropertyDescriptor>();
                for (int i = 0; i < this.descriptors.length; ++i) {
                    if (!this.descriptors[i].isExpert()) continue;
                    arrayList.add(this.descriptors[i]);
                }
                break;
            }
            case 7: {
                arrayList = new ArrayList();
                for (int i = 0; i < this.descriptors.length; ++i) {
                    if (!this.descriptors[i].isPreferred()) continue;
                    arrayList.add(this.descriptors[i]);
                }
                break;
            }
            case 6: {
                arrayList = new ArrayList();
                for (int i = 0; i < this.descriptors.length; ++i) {
                    if (!this.descriptors[i].isHidden()) continue;
                    arrayList.add(this.descriptors[i]);
                }
                break;
            }
            case 4: {
                arrayList = new ArrayList();
                for (int i = 0; i < this.descriptors.length; ++i) {
                    if (!this.descriptors[i].isBound() || this.descriptors[i].getWriteMethod() == null) continue;
                    arrayList.add(this.descriptors[i]);
                }
                break;
            }
            case 5: {
                arrayList = new ArrayList();
                for (int i = 0; i < this.descriptors.length; ++i) {
                    if (!this.descriptors[i].isConstrained() || this.descriptors[i].getWriteMethod() == null) continue;
                    arrayList.add(this.descriptors[i]);
                }
                break;
            }
            case 3: {
                arrayList = new ArrayList();
                for (int i = 0; i < this.descriptors.length; ++i) {
                    if (this.descriptors[i].getWriteMethod() != null) continue;
                    arrayList.add(this.descriptors[i]);
                }
                break;
            }
            case 1: {
                arrayList = new ArrayList();
                for (int i = 0; i < this.descriptors.length; ++i) {
                    PropertyDescriptor propertyDescriptor = this.descriptors[i];
                    if (propertyDescriptor.getWriteMethod() == null || propertyDescriptor.getReadMethod() == null || propertyDescriptor.isHidden() || propertyDescriptor.isExpert()) continue;
                    for (int j = 0; j < this.inputParameters.length; ++j) {
                        if (!this.descriptors[i].getName().equals(this.inputParameters[j])) continue;
                        arrayList.add(this.descriptors[i]);
                    }
                }
                break;
            }
            default: {
                arrayList = new ArrayList();
                for (int i = 0; i < this.descriptors.length; ++i) {
                    PropertyDescriptor propertyDescriptor = this.descriptors[i];
                    if (propertyDescriptor.getWriteMethod() == null || propertyDescriptor.getReadMethod() == null || propertyDescriptor.isHidden() || propertyDescriptor.isExpert()) continue;
                    arrayList.add(this.descriptors[i]);
                }
            }
        }
        if (arrayList != null) {
            this.descriptors = arrayList.toArray(new PropertyDescriptor[arrayList.size()]);
        }
        this.sortTable(this.getSortOrder());
    }

    private static void registerPropertyEditors() {
        PropertyEditorManager.registerEditor(Color.class, SwingColorEditor.class);
        PropertyEditorManager.registerEditor(Font.class, SwingFontEditor.class);
        PropertyEditorManager.registerEditor(Border.class, SwingBorderEditor.class);
        PropertyEditorManager.registerEditor(Boolean.class, SwingBooleanEditor.class);
        PropertyEditorManager.registerEditor(Boolean.TYPE, SwingBooleanEditor.class);
        PropertyEditorManager.registerEditor(Integer.class, SwingIntegerEditor.class);
        PropertyEditorManager.registerEditor(Integer.TYPE, SwingIntegerEditor.class);
        PropertyEditorManager.registerEditor(Long.class, SwingIntegerEditor.class);
        PropertyEditorManager.registerEditor(Long.TYPE, SwingIntegerEditor.class);
        PropertyEditorManager.registerEditor(Float.class, SwingNumberEditor.class);
        PropertyEditorManager.registerEditor(Float.TYPE, SwingNumberEditor.class);
        PropertyEditorManager.registerEditor(Double.class, SwingDoubleEditor.class);
        PropertyEditorManager.registerEditor(Double.TYPE, SwingDoubleEditor.class);
        PropertyEditorManager.registerEditor(Dimension.class, SwingDimensionEditor.class);
        PropertyEditorManager.registerEditor(Point.class, SwingPointEditor.class);
        PropertyEditorManager.registerEditor(Rectangle.class, SwingRectangleEditor.class);
        PropertyEditorManager.registerEditor(Insets.class, SwingInsetsEditor.class);
        PropertyEditorManager.registerEditor(String.class, SwingStringEditor.class);
        PropertyEditorManager.registerEditor(URL.class, URLEditor.class);
        PropertyEditorManager.registerEditor(Object.class, SwingObjectEditor.class);
    }

    static {
        comparator = new DescriptorComparator();
    }
}

