/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import modulecoFramework.Moduleco;
import modulecoGUI.CentralControl;
import modulecoGUI.XMLGuiReader.XMLGuiReader;
import modulecoGUI.cAgentEditor.PropertyColumnModel;
import modulecoGUI.cAgentEditor.PropertyTableModel;

public class JPanelParameters
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 740630972389642379L;
    CentralControl centralControl;
    JLabel jLabelWorldParameter;
    JLabel jLabelModelParameter;
    JLabel jLabelSimulationParameter;
    JLabel jLabelTitle;
    JScrollPane jScrollPane;
    JPanel jPanelContainer;
    JPanel jPanelButtons;
    JCheckBox jCheckBoxUseParameterFile;
    JTextField jTextFieldParameterFile;
    JButton jButtonBrowseParameterFile;
    Object bean;
    private JRadioButton jRadioButtonSimulationUnique;
    private JRadioButton jRadioButtonSimulationBatch;
    private ButtonGroup buttonGroupSimulation;
    JButton jButtonCancel;
    JButton jButtonSave;
    JButton jButtonOk;
    int j = 0;
    int minRowHeight = 24;
    int intercellSpacing = 1;

    public JPanelParameters(CentralControl centralControl, Object object) {
        this.centralControl = centralControl;
        this.bean = object;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.build();
    }

    private void build() {
        this.jPanelContainer = new JPanel();
        this.jPanelContainer.setLayout(new GridBagLayout());
        this.jScrollPane = new JScrollPane(this.jPanelContainer);
        this.jScrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)this.jScrollPane, "Center");
        this.jLabelTitle = this.makeJLabelTitle(Moduleco.getCurrentModelName().toUpperCase(), "");
        this.jLabelTitle.setBackground(Color.white);
        this.jLabelTitle.setHorizontalAlignment(0);
        this.jPanelContainer.add((Component)this.jLabelTitle, new GridBagConstraints(0, this.j, 7, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 10), 0, 0));
        ++this.j;
        this.jCheckBoxUseParameterFile = new JCheckBox(XMLGuiReader.getLabel("JPanelParameters/CheckBoxUseParameterFile"));
        this.jTextFieldParameterFile = new JTextField();
        this.jButtonBrowseParameterFile = new JButton(XMLGuiReader.getLabel("JPanelParameters/ButtonBrowseParameterFile"));
        this.jButtonBrowseParameterFile.addActionListener(this);
        this.jCheckBoxUseParameterFile.addActionListener(this);
        this.jButtonBrowseParameterFile.setEnabled(false);
        this.jTextFieldParameterFile.setEnabled(false);
        this.jPanelContainer.add((Component)this.jCheckBoxUseParameterFile, new GridBagConstraints(0, this.j, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 10), 0, 0));
        this.jPanelContainer.add((Component)this.jTextFieldParameterFile, new GridBagConstraints(1, this.j, 4, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.jPanelContainer.add((Component)this.jButtonBrowseParameterFile, new GridBagConstraints(5, this.j, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 20), 0, 0));
        ++this.j;
        this.jLabelWorldParameter = this.makeJLabelTitle(XMLGuiReader.getLabel("JPanelParameters/LabelWorldParameter"), "html.png");
        this.jLabelModelParameter = this.makeJLabelTitle(XMLGuiReader.getLabel("JPanelParameters/LabelModelParameter"), "exe.png");
        this.jLabelSimulationParameter = this.makeJLabelTitle(XMLGuiReader.getLabel("JPanelParameters/LabelSimulationParameter"), "file_temporary.png");
        this.jPanelContainer.add((Component)this.jLabelWorldParameter, new GridBagConstraints(0, this.j, 7, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
        ++this.j;
        PropertyTableModel propertyTableModel = new PropertyTableModel(this.centralControl.modulecoLauncher.getModelParameters());
        PropertyColumnModel propertyColumnModel = new PropertyColumnModel();
        JTable jTable = new JTable(propertyTableModel, propertyColumnModel);
        this.setTable(jTable);
        this.jPanelContainer.add((Component)jTable, new GridBagConstraints(0, this.j, 7, 1, 1.0, 1.0, 17, 1, new Insets(5, 25, 5, 25), 0, 0));
        ++this.j;
        this.jPanelContainer.add((Component)this.jLabelModelParameter, new GridBagConstraints(0, this.j, 7, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
        ++this.j;
        PropertyTableModel propertyTableModel2 = new PropertyTableModel(this.bean);
        PropertyColumnModel propertyColumnModel2 = new PropertyColumnModel();
        JTable jTable2 = new JTable(propertyTableModel2, propertyColumnModel2);
        this.setTable(jTable2);
        this.jPanelContainer.add((Component)jTable2, new GridBagConstraints(0, this.j, 7, 1, 1.0, 1.0, 17, 1, new Insets(5, 25, 5, 25), 0, 0));
        ++this.j;
        this.jPanelContainer.add((Component)new JPanel(), new GridBagConstraints(0, this.j, 7, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.makeJButtonButtom();
    }

    private void setTable(JTable jTable) {
        jTable.setGridColor(UIManager.getColor("control"));
        jTable.setBackground(UIManager.getColor("control"));
        jTable.setAutoResizeMode(4);
        jTable.setIntercellSpacing(new Dimension(0, this.intercellSpacing));
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            Component component = jTable.getCellRenderer(i, 1).getTableCellRendererComponent(jTable, jTable.getValueAt(i, 1), false, false, i, 1);
            Component component2 = jTable.getCellRenderer(i, 2).getTableCellRendererComponent(jTable, jTable.getValueAt(i, 2), false, false, i, 2);
            Component component3 = jTable.getCellRenderer(i, 3).getTableCellRendererComponent(jTable, jTable.getValueAt(i, 3), false, false, i, 3);
            double d = component.getPreferredSize().getHeight();
            double d2 = component2.getPreferredSize().getHeight();
            double d3 = component3.getPreferredSize().getHeight();
            if (d > d2 && d > d3 && d > (double)this.minRowHeight) {
                jTable.setRowHeight(i, (int)d);
                continue;
            }
            if (d2 > d && d2 > d3 && d2 > (double)this.minRowHeight) {
                jTable.setRowHeight(i, (int)d2);
                continue;
            }
            jTable.setRowHeight(i, this.minRowHeight);
        }
    }

    private void makeJButtonButtom() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(50);
        flowLayout.setVgap(10);
        this.jPanelButtons = new JPanel(flowLayout);
        this.jButtonCancel = new JButton(XMLGuiReader.getLabel("Default/ButtonCancel"));
        this.jButtonSave = new JButton(XMLGuiReader.getLabel("JPanelParameters/ButtonSave"));
        this.jButtonOk = new JButton(XMLGuiReader.getLabel("Default/ButtonOK"));
        this.jButtonCancel.addActionListener(this);
        this.jButtonSave.addActionListener(this);
        this.jButtonOk.addActionListener(this);
        this.jPanelButtons.add(this.jButtonCancel);
        this.jPanelButtons.add(this.jButtonSave);
        this.jPanelButtons.add(this.jButtonOk);
        this.add((Component)this.jPanelButtons, "South");
    }

    public JLabel makeJLabelTitle(String string, String string2) {
        JLabel jLabel;
        Serializable serializable;
        try {
            serializable = this.getClass().getResource("/images/JPanelParameters/" + string2);
            ImageIcon imageIcon = new ImageIcon((URL)serializable, "img");
            jLabel = new JLabel(string, imageIcon, 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            jLabel = new JLabel(string);
        }
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.gray);
        serializable = jLabel.getFont();
        jLabel.setFont(new Font(((Font)serializable).getName(), 1, ((Font)serializable).getSize() + 4));
        jLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        jLabel.setPreferredSize(new Dimension(800, 40));
        jLabel.setFocusable(false);
        return jLabel;
    }

    public JLabel makeJLabelHelp() {
        JLabel jLabel;
        try {
            URL uRL = this.getClass().getResource("/images/JPanelParameters/help.gif");
            ImageIcon imageIcon = new ImageIcon(uRL, "help");
            jLabel = new JLabel("", imageIcon, 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            jLabel = new JLabel("Aide");
        }
        return jLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.jButtonOk)) {
            this.centralControl.validateParameters();
        } else if (actionEvent.getSource().equals(this.jButtonSave)) {
            this.centralControl.writeModelParameters();
        } else if (actionEvent.getSource().equals(this.jButtonCancel)) {
            this.centralControl.removeJPanelParameters();
        } else if (actionEvent.getSource().equals(this.jButtonBrowseParameterFile)) {
            String string = this.centralControl.readModelParameter();
            this.jTextFieldParameterFile.setText(string);
        } else if (actionEvent.getSource().equals(this.jCheckBoxUseParameterFile)) {
            this.jTextFieldParameterFile.setEnabled(this.jCheckBoxUseParameterFile.isSelected());
            this.jButtonBrowseParameterFile.setEnabled(this.jCheckBoxUseParameterFile.isSelected());
        }
    }
}

