/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import modulecoFramework.Moduleco;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.ENeighbourWorld;
import modulecoFramework.simulation.ModulecoLauncher;
import modulecoFramework.utils.dataRecorder.StatRecorder;
import modulecoGUI.DefaultAgentRepresentationContainer;
import modulecoGUI.JAgentEditorQuick;
import modulecoGUI.JConfigModelParameterQuick;
import modulecoGUI.JMadkitOutputQuick;
import modulecoGUI.JModelChooser;
import modulecoGUI.JPanelMain;
import modulecoGUI.ModulecoBean;
import modulecoGUI.XMLGuiReader.GUIParser;
import modulecoGUI.XMLGuiReader.XMLModelReader;
import modulecoGUI.cAgentEditor.JAgentEditor;
import modulecoGUI.cAgentEditor.JAgentLinksEditor;
import modulecoGUI.dataRecorder.JConfigRecorder;
import modulecoGUI.grapheco.CAgentRepresentation;
import modulecoGUI.grapheco.CAgentRepresentationContainer;
import modulecoGUI.graphicBuilder.JCreateDynamicChart;
import modulecoGUI.utils.SimpleFileFilter;
import test.SimpleClassLoader;

public class CentralControl {
    JPanelMain jPanelMain;
    ModulecoBean modulecoBean;
    public ModulecoLauncher modulecoLauncher;
    Preferences preferences = Preferences.userNodeForPackage(CentralControl.class);
    CAgentRepresentationContainer agentRepresentationContainer;
    public boolean statManagerEnabled = true;
    public static int LINE_CHART = 0;
    public static int BAR_CHART = 1;
    public static int PIE_CHART = 2;
    public GUIParser guiParser;

    public CentralControl(ModulecoLauncher modulecoLauncher) {
        this.modulecoLauncher = modulecoLauncher;
        this.modulecoLauncher.setCentralControl(this);
        this.agentRepresentationContainer = new DefaultAgentRepresentationContainer();
        this.guiParser = new GUIParser("GUI.english.xml");
    }

    public CAgentRepresentationContainer getAgentRepresentationContainer() {
        return this.agentRepresentationContainer;
    }

    public void removeJPanelParameters() {
        this.jPanelMain.removeJPanelParameters();
    }

    public void loadJPanelParameters(Object object) {
        this.jPanelMain.loadJPanelParameters(object);
    }

    public JPanelMain getJPanelMain() {
        return this.jPanelMain;
    }

    public void setJPanelMain(JPanelMain jPanelMain) {
        this.jPanelMain = jPanelMain;
    }

    public void openJFileChooserForModele() {
        JModelChooser jModelChooser = new JModelChooser(this.modulecoBean, this.preferences.get("defaultModel", ""));
        int n = jModelChooser.showModelChooser();
        if (n == JModelChooser.APPROVE_OPTION) {
            this.jPanelMain.setControlButtonEnable(false);
            String string = jModelChooser.getSelectedModel();
            this.preferences.put("defaultModel", string);
            this.loadWorld(string);
            XMLModelReader.buildXMLModelReader();
            this.clearAgentRepresentation();
            this.loadJPanelParameters(this.modulecoLauncher.getEWorld());
            this.modulecoBean.setTitle("Moduleco - " + Moduleco.getCurrentModelName());
        }
    }

    private void loadWorld(String string) {
        this.modulecoLauncher.create(string);
    }

    private Class getClassFromFile(File file) {
        System.out.println("Test Introspection : ");
        System.out.println("File : " + file.getAbsolutePath());
        SimpleClassLoader simpleClassLoader = new SimpleClassLoader();
        Class clazz = null;
        try {
            clazz = simpleClassLoader.loadLocalClass(file, true);
            System.out.println("Class Loaded !!!");
            System.out.println(clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return clazz;
    }

    public void loadJPanelMiddle() {
        this.jPanelMain.loadJPanelMiddle();
    }

    public void loadDefaultAgentRepresentation() {
        Field field = null;
        try {
            field = this.modulecoLauncher.getEWorld().getClass().getField("outputGraphics");
            String[] stringArray = new String[]{};
            try {
                stringArray = (String[])field.get(this.modulecoLauncher.getEWorld());
                for (int i = 0; i < stringArray.length; ++i) {
                    Class clazz = null;
                    String string = this.modulecoLauncher.getEWorld().getPackageName() + "." + stringArray[i];
                    try {
                        clazz = Moduleco.getClass(string);
                        CAgentRepresentation cAgentRepresentation = null;
                        try {
                            cAgentRepresentation = (CAgentRepresentation)clazz.newInstance();
                        }
                        catch (InstantiationException instantiationException) {
                            instantiationException.printStackTrace();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                        }
                        cAgentRepresentation.setCentralControl(this);
                        this.addAgentRepresentation(cAgentRepresentation);
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            clazz = Moduleco.getClass("modulecoGUI.grapheco." + stringArray[i]);
                            CAgentRepresentation cAgentRepresentation = null;
                            try {
                                cAgentRepresentation = (CAgentRepresentation)clazz.newInstance();
                            }
                            catch (InstantiationException instantiationException) {
                                instantiationException.printStackTrace();
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                illegalAccessException.printStackTrace();
                            }
                            cAgentRepresentation.setCentralControl(this);
                            this.addAgentRepresentation(cAgentRepresentation);
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            classNotFoundException2.printStackTrace();
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            this.showMessageDialog("SecurityException in loading the field outputGraphics of the class \"World\". Verify the field is not redeclared with a protected or private access.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            this.showMessageDialog("NoSuchFieldException in loading the field \"outputGraphics\" of the class \"World\". Verify the field exists");
        }
        this.addAgentRepresentation(new JConfigModelParameterQuick());
        this.addAgentRepresentation(new JMadkitOutputQuick(this.modulecoLauncher.getOutputGUI()));
        this.addAgentRepresentation(new JAgentEditorQuick(this.modulecoLauncher.getGraphicalWatcher()));
    }

    public void addAgentRepresentation(CAgentRepresentation cAgentRepresentation) {
        cAgentRepresentation.setCAgent(this.modulecoLauncher.getEWorld());
        this.agentRepresentationContainer.addCAgentRepresentation(cAgentRepresentation);
        this.modulecoBean.updateMenuShowView(cAgentRepresentation.getName(), cAgentRepresentation.getIcon());
    }

    public void addDynamicAgentRepresentation(CAgentRepresentation cAgentRepresentation) {
        this.addAgentRepresentation(cAgentRepresentation);
        this.jPanelMain.addAgentRepresentation(cAgentRepresentation);
        this.showView(cAgentRepresentation.getName());
    }

    public void displayDockingHierarchy() {
        this.jPanelMain.jPanelMiddle.displayDockingHierarchy();
    }

    public void resetPerspective() {
        this.jPanelMain.resetPerspective();
    }

    public void showView(String string) {
        this.jPanelMain.showView(string);
    }

    public void setModulecoBean(ModulecoBean modulecoBean) {
        this.modulecoBean = modulecoBean;
        this.setJPanelMain(modulecoBean.getJPanelMain());
    }

    public void validateParameters() {
        this.modulecoLauncher.launch();
        this.loadDefaultAgentRepresentation();
        this.loadJPanelMiddle();
        this.agentRepresentationContainer.updateImage();
        this.jPanelMain.setControlButtonEnable(true);
    }

    public void launchMadkitAgent(String string) {
        try {
            Class clazz = Moduleco.getClass(string);
            Object t = clazz.newInstance();
            this.modulecoLauncher.launchAgent((AbstractAgent)((Agent)t), string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public void simulationStart() {
        this.modulecoLauncher.getSimulationControl().start();
    }

    public void simulationMstep() {
        this.modulecoLauncher.getSimulationControl().progress();
        this.modulecoLauncher.getSimulationControl().progress();
    }

    public void simulationStop() {
        this.modulecoLauncher.getSimulationControl().stop();
    }

    public void simulationTerminate() {
        this.modulecoLauncher.getSimulationControl().terminate();
    }

    public void updateImage() {
        this.agentRepresentationContainer.updateImage();
    }

    public void updateIter(int n) {
        this.jPanelMain.updateIter(n);
    }

    public void reload() {
        this.jPanelMain.updateIter(0);
        this.jPanelMain.setControlButtonEnable(false);
        this.modulecoLauncher.end();
        this.modulecoLauncher.create(Moduleco.getCurrentModelName());
        this.clearAgentRepresentation();
        this.jPanelMain.loadJPanelParameters(this.modulecoLauncher.getEWorld());
    }

    private void clearAgentRepresentation() {
        this.agentRepresentationContainer.clearAllAgentRepresentation();
    }

    public void displayNeighbourhood() {
        ENeighbourWorld eNeighbourWorld = (ENeighbourWorld)this.modulecoLauncher.getEWorld();
        ArrayList arrayList = eNeighbourWorld.agentSet;
        for (EAgent eAgent : arrayList) {
            System.out.println(eAgent.agentID);
            ArrayList arrayList2 = eAgent.getMediums()[0].getAgentsForRole("neighbour");
            for (EAgent eAgent2 : arrayList2) {
                System.out.println("\t" + eAgent2.agentID);
            }
        }
    }

    public void writeModelParameters() {
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter("Fichiers de Param\ufffdtres", ".parameters");
        JFileChooser jFileChooser = new JFileChooser(this.preferences.get("folderParameters", "."));
        jFileChooser.addChoosableFileFilter(simpleFileFilter);
        jFileChooser.setDialogTitle("Open a parameter File for model " + this.modulecoLauncher.getEWorld().getName());
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            this.preferences.put("folderParameters", jFileChooser.getCurrentDirectory().getAbsolutePath());
            System.out.println("File SAve : " + jFileChooser.getSelectedFile().getAbsoluteFile());
            this.modulecoLauncher.writeModelParameters(jFileChooser.getSelectedFile());
        }
    }

    public String readModelParameter() {
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter("Fichiers de Param\ufffdtres", ".parameters");
        JFileChooser jFileChooser = new JFileChooser(this.preferences.get("folderParameters", "."));
        jFileChooser.addChoosableFileFilter(simpleFileFilter);
        jFileChooser.setDialogTitle("Open a parameter File for model " + this.modulecoLauncher.getEWorld().getName());
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            this.preferences.put("folderParameters", jFileChooser.getCurrentDirectory().getAbsolutePath());
            System.out.println("File Open : " + jFileChooser.getSelectedFile().getAbsoluteFile());
            this.modulecoLauncher.readModelParameters(jFileChooser.getSelectedFile());
            this.jPanelMain.jPanelParameters.repaint();
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return "";
    }

    public void createChart(int n) {
        JCreateDynamicChart jCreateDynamicChart = new JCreateDynamicChart(this, n, this.modulecoBean);
        jCreateDynamicChart.showCreateDynamicChart();
    }

    public void loadDefaultModel(String string) {
        this.loadWorld(string);
        this.loadJPanelParameters(this.modulecoLauncher.getEWorld());
        this.validateParameters();
    }

    public void showJConfigRecorder() {
        JConfigRecorder jConfigRecorder = new JConfigRecorder(this.modulecoLauncher.getRecorder(), this.modulecoLauncher.getEWorld());
        jConfigRecorder.showJConfigRedorder(this.modulecoBean);
    }

    public void editAgent(EAgent eAgent) {
        System.out.println("editAgent : " + eAgent.getAgentID());
        JAgentEditor jAgentEditor = new JAgentEditor(eAgent);
        jAgentEditor.showAgentEditor(this.modulecoBean);
        this.addAgentRepresentation(jAgentEditor);
        this.updateImage();
    }

    public void editAgentLinks(EAgent eAgent) {
        JAgentLinksEditor jAgentLinksEditor = new JAgentLinksEditor(eAgent);
        jAgentLinksEditor.showAgentLinksEditor(this.modulecoBean);
        this.updateImage();
    }

    public void showMessageDialog(String string) {
        JOptionPane.showMessageDialog(this.modulecoBean, string, "Warning", 2);
    }

    public StatRecorder getStatRecorder() {
        return this.modulecoLauncher.getStatRecorder();
    }
}

