/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.modeleco.mobility;

import java.util.ArrayList;
import modulecoFramework.medium.Medium;
import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.exceptions.AlreadyUsedPlaceException;
import modulecoFramework.modeleco.mobility.MobileAgent;

public class EPlace
extends EAgent {
    protected MobileAgent agent;
    protected int mobileAgentID;
    protected int placeID;
    protected ArrayList neighbours;
    protected ArrayList descriptors = new ArrayList();
    public static int nobodyHere = 0;
    public static int somebodyHere = 1;
    public static int toBeComputed = 2;
    protected int actualState;
    protected int futureState;

    public EPlace() {
        this.mediums = new Medium[1];
        this.mediums[0] = new NeighbourMedium();
    }

    public void receive(MobileAgent mobileAgent) throws AlreadyUsedPlaceException {
        if (this.agent != null) {
            throw new AlreadyUsedPlaceException();
        }
        this.agent = mobileAgent;
        this.setActualState(this.getActualState());
        this.agent.setPlace(this);
    }

    public void leave() {
        this.agent = null;
        this.setActualState(nobodyHere);
    }

    public void compute() {
        if (this.agent != null) {
            this.agent.compute();
        }
    }

    public void commit() {
        this.actualState = this.futureState;
        this.futureState = toBeComputed;
        if (this.agent != null) {
            this.agent.commit();
        }
    }

    public Object getState() {
        if (this.agent != null) {
            return this.agent.getState();
        }
        return null;
    }

    public int getActualState() {
        return this.actualState;
    }

    public void setActualState(int n) {
        this.actualState = n;
        this.futureState = toBeComputed;
    }

    public int getFutureState() {
        return this.futureState;
    }

    public void setFutureState(int n) {
        this.futureState = n;
    }

    public String pack() {
        if (this.agent != null) {
            String string = this.agent.getClass().getName();
            return string.substring(0, string.indexOf(46, 0));
        }
        return "";
    }

    public void init() {
        this.neighbours = ((NeighbourMedium)this.getMediums()[0]).getNeighbours();
        this.futureState = toBeComputed;
        if (this.agent != null) {
            this.agent.init();
        }
    }

    public MobileAgent getAgent() {
        return this.agent;
    }

    public ArrayList getDescriptors() {
        return this.descriptors;
    }

    public void setPlaceID(int n) {
        this.placeID = n;
    }

    public int getPlaceID() {
        return this.placeID;
    }
}

