/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.modeleco;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import modulecoFramework.Moduleco;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.EAgentLinks;
import modulecoFramework.modeleco.ENeighbourWorld;
import modulecoFramework.modeleco.StructuredNeighbourWorld;
import modulecoFramework.modeleco.randomeco.CRandomDouble;

public abstract class ENeighbourSmallWorld
extends ENeighbourWorld
implements StructuredNeighbourWorld {
    protected CRandomDouble random;
    public long seed;
    public int nbLinks;
    public int nbNodes;
    public int purcentLinks;
    public int removedLinks;
    public String random_s;
    private static String randomPath = "modulecoFramework.modeleco.randomeco.";

    public ENeighbourSmallWorld() {
        this.inputParameters = new String[]{"seed", "random_s", "nbLinks", "nbNodes", "removedLinks", "purcentLinks"};
        this.hashMapChoiceString.put("random_s", new String[]{"Default", "JavaRandom", "JavaGaussian"});
        this.hashMapChoiceValue.put("random_s", new String[]{"Default", "JavaRandom", "JavaGaussian"});
        this.randomGeneratorSetDefaultValues();
    }

    public void initAll() {
        this.enWorldInitAll();
        this.nbLinks = this.countLinks();
        this.purcentLinks = (int)((double)this.nbNodes / (double)this.nbLinks * 100.0);
        this.setRandom_s(this.random_s);
        this.rebuildLinks();
    }

    public void enWorldInitAll() {
        super.initAll();
    }

    public void rebuildLinks() {
        for (int i = 0; i < this.nbNodes; ++i) {
            this.buildRandomLinks();
        }
    }

    public void buildRandomLinks() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        int n2 = (int)(this.random.getDouble() * (double)(this.agentSetSize - 1));
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EAgentLinks eAgentLinks = (EAgentLinks)iterator.next();
            if (eAgentLinks.getAgentID() != n2) continue;
            for (int i = 0; i < this.removedLinks; ++i) {
                int n3;
                Object object2;
                int n4;
                boolean bl;
                int n5;
                if (arrayList != null) {
                    arrayList.clear();
                }
                arrayList = (ArrayList)eAgentLinks.getNeighbours().clone();
                int n6 = arrayList.size();
                if (i > 0) {
                    n5 = 0;
                    do {
                        bl = false;
                        n4 = (int)(this.random.getDouble() * (double)(n6 - 1));
                        ++n5;
                        if (n4 == n6 - 1) {
                            bl = true;
                        }
                        if (n5 <= 1000) continue;
                        bl = false;
                    } while (bl);
                } else {
                    n4 = (int)(this.random.getDouble() * (double)(n6 - 1));
                }
                EAgentLinks eAgentLinks2 = (EAgentLinks)arrayList.get(n4);
                n5 = 0;
                int[] nArray = new int[n6];
                for (Object object2 : arrayList) {
                    nArray[n5] = ((EAgent)object2).getAgentID();
                    ++n5;
                }
                int n7 = 0;
                do {
                    n5 = 0;
                    do {
                        bl = false;
                        n3 = (int)(this.random.getDouble() * (double)(this.agentSetSize - 1));
                        ++n5;
                        if (n3 == n2) {
                            bl = true;
                        }
                        if (n3 == n) {
                            bl = true;
                        }
                        if (n5 >= 100) continue;
                        bl = true;
                    } while (bl);
                    bl = false;
                    for (int j = 0; j < n6; ++j) {
                        if (nArray[j] != n3) continue;
                        bl = true;
                    }
                    if (++n7 <= 5000) continue;
                    bl = false;
                } while (bl);
                n = eAgentLinks2.getAgentID();
                eAgentLinks.neighbours.remove(eAgentLinks2);
                eAgentLinks2.neighbours.remove(eAgentLinks);
                eAgentLinks2.updateConnectivityIndex();
                object2 = this.iterator();
                while (object2.hasNext()) {
                    EAgentLinks eAgentLinks3 = (EAgentLinks)object2.next();
                    if (eAgentLinks3.getAgentID() != n3) continue;
                    eAgentLinks.neighbours.add(eAgentLinks3);
                    eAgentLinks.updateConnectivityIndex();
                    eAgentLinks3.neighbours.add(eAgentLinks);
                    eAgentLinks3.updateConnectivityIndex();
                }
            }
        }
    }

    public int countLinks() {
        int n = 0;
        int n2 = this.agentSetSize;
        int n3 = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EAgentLinks eAgentLinks = (EAgentLinks)iterator.next();
            if (eAgentLinks.neighbours.size() > n3) {
                n3 = eAgentLinks.neighbours.size();
            }
            if (eAgentLinks.neighbours.size() < n2) {
                n2 = eAgentLinks.neighbours.size();
            }
            n += eAgentLinks.neighbours.size() / 2;
        }
        return n;
    }

    public void setPurcentLinks(int n) {
        this.purcentLinks = n;
    }

    public void setRemovedLinks(int n) {
        this.removedLinks = n;
    }

    public void updateRemovedLinks(int n) {
        this.removedLinks += n;
    }

    public void setSeed(long l) {
        this.seed = l;
    }

    public void setRandom_s(String string) {
        this.random_s = string;
        try {
            Constructor constructor = Moduleco.getClass(randomPath + this.random_s).getConstructor(Long.TYPE);
            this.random = (CRandomDouble)constructor.newInstance(new Long(this.seed));
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public int getNbLinks() {
        return this.nbLinks;
    }

    public void setNbLinks(int n) {
        this.nbLinks = n;
    }

    public int getNbNodes() {
        return this.nbNodes;
    }

    public void setNbNodes(int n) {
        this.nbNodes = n;
    }

    public int getPurcentLinks() {
        return this.purcentLinks;
    }

    public String getRandom_s() {
        return this.random_s;
    }

    public int getRemovedLinks() {
        return this.removedLinks;
    }

    public long getSeed() {
        return this.seed;
    }

    public void randomGeneratorSetDefaultValues() {
        this.seed = 10L;
        this.setRandom_s("JavaRandom");
        this.nbNodes = 1;
        this.removedLinks = 1;
    }
}

