/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import madkit.kernel.Agent;
import madkit.kernel.ReferenceableAgent;
import modulecoFramework.simulation.ModulecoLauncher;
import modulecoGUI.CentralControl;
import modulecoGUI.ModulecoBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModulecoAgent
extends Agent
implements ReferenceableAgent {
    private static final long serialVersionUID = -9084980830827142928L;
    protected boolean gui = false;
    protected ModulecoLauncher modulecoLauncher = new ModulecoLauncher();
    protected ModulecoBean modulecoBean;
    protected String model = null;
    protected int nbOfSimu = 1;
    int simulationDuration = 0;
    CentralControl centralControl;

    public void activate() {
        this.println("activated");
        this.printCopyright();
        this.createGroup(false, "moduleco", "engine", null, null);
        this.requestRole("moduleco", "engine", "modulecoAgent", null);
        if (this.gui) {
            this.modulecoBean.init();
        }
        this.launchAgent(this.modulecoLauncher, "Moduleco Launcher", false);
        this.loadConfigFile();
    }

    public void initGUI() {
        this.centralControl = new CentralControl(this.modulecoLauncher);
        this.modulecoBean = new ModulecoBean(this.centralControl);
        this.centralControl.setModulecoBean(this.modulecoBean);
        this.setGUIObject(this.modulecoBean);
        this.gui = true;
    }

    public void live() {
        if (this.gui) {
            this.waitNextMessage();
        } else {
            for (int i = 0; i < this.nbOfSimu; ++i) {
                this.modulecoLauncher.create(this.model);
                this.modulecoLauncher.launch();
                this.modulecoLauncher.getSimulationControl().setSimulationDuration(this.simulationDuration);
                this.modulecoLauncher.getSimulationControl().start();
                this.waitNextMessage();
                this.modulecoLauncher.reload();
            }
        }
    }

    public void end() {
        System.exit(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadConfigFile() {
        File file = new File("moduleco.cfg");
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("model");
            this.model = ((Element)nodeList.item(0)).getAttribute("name");
            this.nbOfSimu = Integer.parseInt(((Element)nodeList.item(0)).getAttribute("nbOfSimulations"));
            this.simulationDuration = Integer.parseInt(((Element)nodeList.item(0)).getAttribute("duration"));
            if (!this.gui) return;
        }
        catch (IOException iOException) {
            System.err.println("File read error with !\n" + file.getName());
            return;
        }
        catch (SAXException sAXException) {
            System.err.println("Parsing error of the file !\n" + file.getName());
            return;
        }
        catch (Exception exception) {
            System.err.println("XML problem !\n" + file.getName());
        }
    }

    private void printCopyright() {
        System.out.println("Moduleco\nAlpha version 1.5.1a - 08/2005");
        System.out.println("Created by Antoine Beugnard & Denis Phan - ENST-Bretagne");
        System.out.println("Maintained by Gilles Daniel & Denis Phan");
        System.out.println("Adapted to MadKit by Jacques Ferber, Fabien Michel and Thibaud Roussillat");
        System.out.println("Please update this version by download the latest version at:");
        System.out.println("http://www.cs.man.ac.uk/ai/public/moduleco");
        System.out.println("http://www-eco.enst-bretagne.fr/~phan/moduleco");
    }
}

