/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import madkit.kernel.AgentAddress;
import warbot.kernel.Brain;
import warbot.kernel.Food;
import warbot.kernel.Percept;
import warbot.kernel.WarbotMessage;

public class NotreRastaRocket
extends Brain {
    String groupName = "vert-";
    String roleName = "launcher";
    boolean asGoal = false;
    boolean baseHeading = false;
    boolean groups = false;
    boolean isChief = false;
    int waitingForRocket = 0;
    int waitingMax = 3;

    public void activate() {
        this.randomHeading();
        this.println("I'm feeling good");
        this.println("I am heading " + this.getHeading());
        this.createGroup(false, this.groupName, null, null);
        this.requestRole(this.groupName, this.roleName, null);
    }

    void decrWaitingForRocket() {
        --this.waitingForRocket;
        if (this.waitingForRocket < 0) {
            this.waitingForRocket = 0;
        }
    }

    public void doIt() {
        this.decrWaitingForRocket();
        if (!this.isMoving() && !this.baseHeading) {
            this.randomHeading();
        }
        this.messageUse();
        if (!this.groups) {
            this.broadcast(this.groupName, this.roleName, "setgroups");
            this.println("setting groups...");
            this.groups = true;
            this.isChief = true;
        }
        if (this.isChief && this.getAgentsWithRole(this.groupName, "launcher").length > 0) {
            this.setGroups();
        }
        if (!this.usePercepts()) {
            this.move();
        }
    }

    public void messageUse() {
        WarbotMessage lastMessage = null;
        while ((lastMessage = this.readMessage()) != null) {
            String act = lastMessage.getAct();
            if (act.equals("homeposition")) {
                if (this.baseHeading) continue;
                double[] r = this.findDirection(lastMessage);
                this.println("go to the enemy home: " + this.towards(r[0], r[1]));
                this.setHeading(this.towards(r[0], r[1]));
                this.baseHeading = true;
                while ((lastMessage = this.readMessage()) != null) {
                }
                this.move();
                return;
            }
            if (act.equals("helpL")) {
                if (!this.baseHeading) {
                    double[] r = this.findDirection(lastMessage);
                    this.setHeading(this.towards(r[0], r[1]));
                    while ((lastMessage = this.readMessage()) != null) {
                    }
                } else if (this.baseHeading) {
                    this.move();
                }
                return;
            }
            if (act.equals("help")) {
                double xpos = lastMessage.getFromX();
                double ypos = lastMessage.getFromY();
                String ts = lastMessage.getArgN(2);
                this.println("help an explorer " + xpos + ", " + ypos);
                this.println("mesge= " + lastMessage.getArgN(2));
                this.setHeading(this.towards(xpos, ypos));
                this.baseHeading = false;
                while ((lastMessage = this.readMessage()) != null) {
                }
                this.move();
                return;
            }
            if (act.equals("setgroups")) {
                this.groups = true;
                this.isChief = false;
                this.move();
                return;
            }
            if (act.equals("groupe")) {
                this.groups = true;
                this.requestRole(this.groupName, lastMessage.getArg1(), null);
                this.println("JE SUIS DU GROUPE " + lastMessage.getArg1());
                this.move();
                return;
            }
            if (act.equals("goEast")) {
                this.setHeading(0.0);
                continue;
            }
            if (!act.equals("goWest")) continue;
            this.setHeading(180.0);
        }
    }

    public boolean usePercepts() {
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            int i = 0;
            while (i < detectedEntities.length) {
                Percept e = detectedEntities[i];
                if ((e.getPerceptType().equals("RocketLauncher") || e.getPerceptType().equals("Explorer")) && !e.getTeam().equals(this.getTeam())) {
                    double d = this.towards(detectedEntities[i].getX(), detectedEntities[i].getY());
                    if (this.waitingForRocket <= 0) {
                        if (this.friendInFront(d) == 0) {
                            this.launchRocket(this.towards(detectedEntities[i].getX(), detectedEntities[i].getY()));
                            this.waitingForRocket = this.waitingMax;
                            String[] t = new String[]{"" + detectedEntities[i].getX(), "" + detectedEntities[i].getY(), "" + this.towards(detectedEntities[i].getX(), detectedEntities[i].getY())};
                            this.broadcast(this.groupName, "defense", "helpL", t);
                            this.broadcast(this.groupName, "launcher", "helpL", t);
                        } else if (this.friendInFront(d) == 1) {
                            this.contourne(1);
                            this.move();
                            this.baseHeading = false;
                        } else if (this.friendInFront(d) == 2) {
                            this.contourne(2);
                            this.move();
                            this.baseHeading = false;
                        } else if (this.friendInBack(d) == 2) {
                            this.setHeading(this.towards(detectedEntities[i].getX(), detectedEntities[i].getY()) + 90.0);
                            this.move();
                            this.baseHeading = false;
                        } else if (this.friendInBack(d) == 1) {
                            this.setHeading(this.towards(detectedEntities[i].getX(), detectedEntities[i].getY()) - 90.0);
                            this.move();
                            this.baseHeading = false;
                        }
                        return true;
                    }
                    if (this.friendInFront(d) == 1) {
                        this.contourne(1);
                        this.move();
                        this.baseHeading = false;
                    } else if (this.friendInFront(d) == 2) {
                        this.contourne(2);
                        this.move();
                        this.baseHeading = false;
                    }
                    return true;
                }
                if (e.getPerceptType().equals("Home") && !e.getTeam().equals(this.getTeam())) {
                    this.launchRocket(this.towards(e.getX(), e.getY()));
                    if (e.getEnergy() < 50) {
                        this.baseHeading = false;
                    }
                    return true;
                }
                if (e.getPerceptType().equals("Rocket")) {
                    this.launchRocket(this.towards(e.getX(), e.getY()));
                }
                if (e.getPerceptType().equals("Obstacle") && !this.isMoving() && e.getDistance() < 10.0) {
                    double he = this.towards(e.getX(), e.getY());
                    this.println("direction du mur= " + he);
                    this.baseHeading = false;
                    if (this.getHeading() > he) {
                        this.setHeading(this.getHeading() - 60.0);
                    } else if (this.getHeading() < he) {
                        this.setHeading(this.getHeading() + 60.0);
                    } else if (this.getHeading() == he) {
                        this.setHeading(this.getHeading() + 115.0);
                    }
                    this.println("direction prise= " + this.getHeading());
                    return false;
                }
                ++i;
            }
        }
        int min = 0;
        int i = 0;
        while (i < detectedEntities.length) {
            Percept e = detectedEntities[i];
            if (this.distanceTo(e) < this.distanceTo(detectedEntities[min]) && e.getPerceptType().equals("Food")) {
                min = i;
            }
            ++i;
        }
        if (detectedEntities.length > 0 && detectedEntities[min].getPerceptType().equals("Food")) {
            if (this.distanceTo(detectedEntities[min]) < 2.0) {
                this.eat((Food)detectedEntities[min]);
                return false;
            }
            if (!this.baseHeading) {
                this.setHeading(this.towards(detectedEntities[min].getX(), detectedEntities[min].getY()));
            }
            this.move();
            return true;
        }
        return false;
    }

    public void setGroups() {
        AgentAddress[] ag = null;
        ag = this.getAgentsWithRole(this.groupName, "launcher");
        this.println("j'ai " + ag.length + "amis");
        int i = 0;
        while (i < ag.length / 2) {
            this.send(ag[i], "groupe", "attack");
            this.println("msg envoye ..");
            ++i;
        }
        i = ag.length / 2;
        while (i < ag.length) {
            this.send(ag[i], "groupe", "defense");
            this.println("msg envoye ..");
            ++i;
        }
    }

    public int friendInFront(double d) {
        double dg;
        double dd;
        Percept[] p = this.getPercepts();
        int rep = 0;
        if (d < 30.0) {
            dd = d + 30.0;
            dg = d - 30.0 + 360.0;
        } else if (d > 329.0) {
            dd = d + 30.0 - 360.0;
            dg = d - 30.0;
        } else {
            dd = d + 30.0;
            dg = d - 30.0;
        }
        int i = 0;
        while (i < p.length) {
            if (p[i].getTeam().equals(this.getTeam()) && this.towards(p[i].getX(), p[i].getY()) < dd && this.towards(p[i].getX(), p[i].getY()) >= d) {
                rep = 1;
            } else if (p[i].getTeam().equals(this.getTeam()) && this.towards(p[i].getX(), p[i].getY()) > dg && this.towards(p[i].getX(), p[i].getY()) < d) {
                rep = 2;
            }
            ++i;
        }
        return rep;
    }

    public int friendInBack(double d) {
        double dg;
        double dd;
        Percept[] p = this.getPercepts();
        int rep = 0;
        if (d < 30.0) {
            dd = d + 30.0;
            dg = d - 30.0 + 360.0;
        } else if (d > 329.0) {
            dd = d + 30.0 - 360.0;
            dg = d - 30.0;
        } else {
            dd = d + 30.0;
            dg = d - 30.0;
        }
        int i = 0;
        while (i < p.length) {
            if (p[i].getTeam().equals(this.getTeam()) && this.towards(p[i].getX(), p[i].getY()) < dd && this.towards(p[i].getX(), p[i].getY()) >= d) {
                rep = 2;
            } else if (p[i].getTeam().equals(this.getTeam()) && this.towards(p[i].getX(), p[i].getY()) > dg && this.towards(p[i].getX(), p[i].getY()) < d) {
                rep = 1;
            }
            ++i;
        }
        return rep;
    }

    public void contourne(int d) {
        Percept[] p = this.getPercepts();
        this.println("contourne " + d);
        int i = 0;
        while (i < p.length) {
            if (p[i].getTeam().equals(this.getTeam()) && p[i].getDistance() < 10.0) {
                if (d == 1) {
                    if (this.towards(p[i].getX(), p[i].getY()) > (double)d && this.towards(p[i].getX(), p[i].getY()) <= (double)(d + 90)) {
                        this.setHeading(d + 120);
                    } else {
                        this.setHeading(d + 30);
                    }
                } else if (d == 2) {
                    if (this.towards(p[i].getX(), p[i].getY()) < (double)d && this.towards(p[i].getX(), p[i].getY()) >= (double)(d + 90)) {
                        this.setHeading(d - 120);
                    } else {
                        this.setHeading(d - 30);
                    }
                }
            }
            ++i;
        }
    }

    public double[] findDirection(WarbotMessage m) {
        double h1 = this.towards(m.getFromX(), m.getFromY());
        double d1 = Math.sqrt(m.getFromX() * m.getFromX() + m.getFromY() * m.getFromY());
        this.println("x1= " + m.getFromX());
        this.println("y1= " + m.getFromY());
        this.println("d1= " + d1);
        this.println("h1= " + h1);
        String[] S = m.getContent();
        Double x1 = new Double(S[0]);
        Double y1 = new Double(S[1]);
        Double h2 = new Double(S[2]);
        this.println("x2= " + x1);
        this.println("y2= " + y1);
        double d2 = Math.sqrt(x1 * x1 + y1 * y1);
        double X = m.getFromX() + x1;
        double Y = m.getFromY() + y1;
        double dtotal = Math.sqrt(X * X + Y * Y);
        this.println("X= " + X);
        this.println("Y= " + Y);
        this.println("dTotale= " + dtotal);
        double[] res = new double[]{X, Y};
        return res;
    }

    public void choixPercept() {
    }
}

