/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHCastExpression;
import bsh.BSHType;
import bsh.BSHVariableDeclarator;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHTypedVariableDeclaration
extends SimpleNode {
    public boolean isFinal;

    BSHTypedVariableDeclaration(int id) {
        super(id);
    }

    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        try {
            NameSpace namespace = callstack.top();
            BSHType typeNode = (BSHType)this.jjtGetChild(0);
            Class type = typeNode.getType(namespace);
            int n = this.jjtGetNumChildren();
            int i = 1;
            while (i < n) {
                BSHVariableDeclarator dec = (BSHVariableDeclarator)this.jjtGetChild(i);
                Object value = dec.eval(typeNode, callstack, interpreter);
                if (value == Primitive.VOID) {
                    value = null;
                } else if (value != Primitive.NULL && this.canCastToDeclaredType(value, type)) {
                    value = BSHCastExpression.castObject(value, type);
                }
                namespace.setTypedVariable(dec.name, type, value, this.isFinal);
                ++i;
            }
        }
        catch (EvalError e) {
            e.reThrow("Typed variable declaration", this);
        }
        return Primitive.VOID;
    }

    boolean canCastToDeclaredType(Object value, Class toType) {
        if (!(value instanceof Primitive)) {
            return false;
        }
        Class fromType = ((Primitive)value).getType();
        return (toType == Byte.TYPE || toType == Short.TYPE || toType == Character.TYPE) && fromType == Integer.TYPE;
    }
}

