/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHType;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.TargetError;

class BSHBinaryExpression
extends SimpleNode
implements ParserConstants {
    public int kind;

    BSHBinaryExpression(int id) {
        super(id);
    }

    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Object obj;
        Object lhs = ((SimpleNode)this.jjtGetChild(0)).eval(callstack, interpreter);
        if (this.kind == 31) {
            if (lhs == Primitive.NULL) {
                return new Primitive(false);
            }
            if (lhs instanceof Primitive) {
                return new Primitive(false);
            }
            NameSpace namespace = callstack.top();
            Class rhs = ((BSHType)this.jjtGetChild(1)).getType(namespace);
            boolean ret = Reflect.isAssignableFrom(rhs, lhs.getClass());
            return new Primitive(ret);
        }
        if (this.kind == 87 || this.kind == 88) {
            obj = lhs;
            if (this.isPrimitiveValue(lhs)) {
                obj = ((Primitive)lhs).getValue();
            }
            if (obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
                return new Primitive(false);
            }
        }
        if (this.kind == 85 || this.kind == 86) {
            obj = lhs;
            if (this.isPrimitiveValue(lhs)) {
                obj = ((Primitive)lhs).getValue();
            }
            if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                return new Primitive(true);
            }
        }
        boolean isLhsWrapper = this.isWrapper(lhs);
        Object rhs = ((SimpleNode)this.jjtGetChild(1)).eval(callstack, interpreter);
        boolean isRhsWrapper = this.isWrapper(rhs);
        if (!(!isLhsWrapper && !this.isPrimitiveValue(lhs) || !isRhsWrapper && !this.isPrimitiveValue(rhs) || isLhsWrapper && isRhsWrapper && this.kind == 79)) {
            try {
                return Primitive.binaryOperation(lhs, rhs, this.kind);
            }
            catch (TargetError e) {
                e.reThrow(this);
            }
        }
        switch (this.kind) {
            case 79: {
                return new Primitive(lhs == rhs);
            }
            case 84: {
                return new Primitive(lhs != rhs);
            }
            case 91: {
                if (!(lhs instanceof String) && !(rhs instanceof String)) break;
                return String.valueOf(lhs.toString()) + rhs.toString();
            }
        }
        if (lhs instanceof Primitive || rhs instanceof Primitive) {
            if (lhs == Primitive.VOID || rhs == Primitive.VOID) {
                throw new EvalError("illegal use of undefined variable, class, or 'void' literal", this);
            }
            if (lhs == Primitive.NULL || rhs == Primitive.NULL) {
                throw new EvalError("illegal use of null value or 'null' literal", this);
            }
        }
        throw new EvalError("Operator: '" + ParserConstants.tokenImage[this.kind] + "' inappropriate for objects", this);
    }

    private boolean isPrimitiveValue(Object obj) {
        return obj instanceof Primitive && obj != Primitive.VOID && obj != Primitive.NULL;
    }

    private boolean isWrapper(Object obj) {
        return obj instanceof Boolean || obj instanceof Character || obj instanceof Number;
    }
}

