/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.help;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ModulecoHelpBrowser
extends JFrame
implements ActionListener {
    private JMenuBar menuBar;
    private JMenuItem menuItemLoad;
    private JMenuItem menuItemJavaDoc;
    private JMenuItem menuItemGuide;
    private JMenuItem menuItemHomePage;
    private JMenuItem menuItemExit;
    protected static String directory = "help";
    private Container contentPane;
    private JTextField url;
    private JButton loadButton;
    private JButton backButton;
    private JEditorPane editorPane;
    private Stack urlStack = new Stack();
    private String urlString;
    private String currentWorld;
    private String modulecoPath;
    private String[] worldNameList;
    private int maxWorld;
    private JMenu menuAbout;
    private JCheckBoxMenuItem[] worldMenuItem;

    public ModulecoHelpBrowser() {
        this((String)null);
    }

    public ModulecoHelpBrowser(String string, String string2) {
        this("file:" + File.separator + string + "models" + File.separator + string2 + File.separator + string2 + ".html");
        this.currentWorld = string2;
        this.modulecoPath = string;
    }

    public ModulecoHelpBrowser(String string) {
        this.urlString = string;
        this.setTitle("ModulecoHelpBrowser");
        this.setSize(800, 600);
        this.buildLastURL();
        this.buildURLTextFile();
        this.buildURLLoader();
        this.buildBrowser();
        JPanel jPanel = new JPanel();
        jPanel.add(this.backButton);
        jPanel.add(new JLabel("URL :"));
        jPanel.add(this.url);
        jPanel.add(this.loadButton);
        this.contentPane.add((Component)jPanel, "North");
        this.urlPageLoader(string, null);
    }

    public void buildURLTextFile() {
        this.url = new JTextField(40);
        this.url.setText(this.urlString);
    }

    public void buildURLLoader() {
        this.loadButton = new JButton("Load URL");
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModulecoHelpBrowser.this.urlPageLoader(ModulecoHelpBrowser.this.urlString, actionEvent);
            }
        });
    }

    public void buildLastURL() {
        this.backButton = new JButton("Last URL");
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ModulecoHelpBrowser.this.urlStack.size() <= 1) {
                    return;
                }
                try {
                    ModulecoHelpBrowser.this.urlStack.pop();
                    ModulecoHelpBrowser.this.urlString = (String)ModulecoHelpBrowser.this.urlStack.peek();
                    ModulecoHelpBrowser.this.url.setText(ModulecoHelpBrowser.this.urlString);
                    ModulecoHelpBrowser.this.editorPane.setPage(ModulecoHelpBrowser.this.urlString);
                }
                catch (IOException iOException) {
                    ModulecoHelpBrowser.this.editorPane.setText("Erreur: " + iOException);
                }
            }
        });
    }

    public void buildBrowser() {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        ModulecoHelpBrowser.this.urlStack.push(hyperlinkEvent.getURL().toString());
                        ModulecoHelpBrowser.this.url.setText(hyperlinkEvent.getURL().toString());
                        ModulecoHelpBrowser.this.editorPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (IOException iOException) {
                        ModulecoHelpBrowser.this.editorPane.setText("Erreur: " + iOException);
                    }
                }
            }
        });
        this.contentPane = this.getContentPane();
        this.contentPane.add((Component)new JScrollPane(this.editorPane), "Center");
    }

    public void createJMenuBar() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu jMenu = new JMenu("File");
        this.menuBar.add(jMenu);
        this.menuAbout = new JMenu("About Worlds");
        jMenu.add(this.menuAbout);
        this.worldMenuItem = new JCheckBoxMenuItem[this.maxWorld];
        for (int i = 0; i < this.maxWorld; ++i) {
            this.worldMenuItem[i] = new JCheckBoxMenuItem(this.worldNameList[i], this.worldNameList[i].equals(this.currentWorld));
            this.menuAbout.add(this.worldMenuItem[i]);
            this.worldMenuItem[i].addActionListener(this);
        }
        jMenu.addSeparator();
        this.menuItemJavaDoc = new JMenuItem("ModulecoJavaDoc");
        jMenu.add(this.menuItemJavaDoc);
        this.menuItemJavaDoc.addActionListener(this);
        this.menuItemGuide = new JMenuItem("Moduleco Getting started ");
        jMenu.add(this.menuItemGuide);
        this.menuItemGuide.addActionListener(this);
        jMenu.addSeparator();
        this.menuItemHomePage = new JMenuItem("Access Moduleco HomePage");
        jMenu.add(this.menuItemHomePage);
        this.menuItemHomePage.addActionListener(this);
        jMenu.addSeparator();
        this.menuItemExit = new JMenuItem("Exit");
        jMenu.add(this.menuItemExit);
        this.menuItemExit.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
            for (int i = 0; i < this.maxWorld; ++i) {
                if (actionEvent.getSource().equals(this.worldMenuItem[i])) {
                    this.worldMenuItem[i].setState(true);
                    this.urlString = "file:" + File.separator + this.modulecoPath + "models" + File.separator + this.worldNameList[i] + File.separator + this.worldNameList[i] + ".html";
                    System.out.println("urlString =" + this.urlString);
                    this.urlPageLoader(this.urlString, null);
                    continue;
                }
                this.worldMenuItem[i].setState(false);
            }
        }
        if (actionEvent.getSource() == this.menuItemGuide) {
            this.urlString = "file:" + File.separator + this.modulecoPath + File.separator + "ModulecoFramework" + File.separator + "help" + File.separator + "gettingStarted.html";
            this.urlPageLoader(this.urlString, actionEvent);
        }
        if (actionEvent.getSource() == this.menuItemJavaDoc) {
            this.urlString = "file:" + File.separator + this.modulecoPath + "ModulecoJavaDoc" + File.separator + "overview-summary.html";
            this.urlPageLoader(this.urlString, actionEvent);
        }
        if (actionEvent.getSource() == this.menuItemHomePage) {
            this.urlString = "http://www-eco.enst-bretagne.fr/~phan/moduleco";
            this.urlPageLoader(this.urlString, actionEvent);
        }
        if (actionEvent.getSource() == this.menuItemExit) {
            this.dispose();
        }
    }

    public void urlPageLoader(String string, ActionEvent actionEvent) {
        this.url.setText(string);
        try {
            this.urlStack.push(this.url.getText());
            this.editorPane.setPage(this.url.getText());
        }
        catch (IOException iOException) {
            this.editorPane.setText("Erreur : " + iOException);
        }
    }

    public void setWorldList(int n, String[] stringArray, String string) {
        this.maxWorld = n;
        this.currentWorld = string;
        this.worldNameList = new String[n];
        this.worldNameList = stringArray;
        this.createJMenuBar();
    }
}

