/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.grapheco.statManager;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.EWorld;
import modulecoGUI.grapheco.statManager.CalculatedVar;

public class VarCalculator {
    private Hashtable hashVar;
    private Hashtable hashValues;
    private EWorld eWorld;

    public VarCalculator(EWorld eWorld) {
        this.eWorld = eWorld;
        this.hashVar = new Hashtable();
        this.hashValues = new Hashtable();
    }

    public void add(CalculatedVar calculatedVar) {
        this.hashVar.put(calculatedVar.getName(), calculatedVar);
    }

    public double get(String string) {
        Double d = (Double)this.hashValues.get(string);
        if (d == null) {
            d = new Double(0.0);
        }
        return d;
    }

    public void calculate() {
        Enumeration enumeration = this.hashVar.elements();
        while (enumeration.hasMoreElements()) {
            CalculatedVar calculatedVar = (CalculatedVar)enumeration.nextElement();
            try {
                Iterator iterator;
                if (calculatedVar.getType() == CalculatedVar.SUM) {
                    double d = 0.0;
                    iterator = this.eWorld.iterator();
                    while (iterator.hasNext()) {
                        d += ((Double)calculatedVar.getMethod().invoke((Object)((EAgent)iterator.next()), null)).doubleValue();
                    }
                    this.hashValues.put(calculatedVar.getName(), new Double(d));
                    continue;
                }
                if (calculatedVar.getType() == CalculatedVar.AVERAGE) {
                    double d = 0.0;
                    int n = 0;
                    Iterator iterator2 = this.eWorld.iterator();
                    while (iterator2.hasNext()) {
                        d += ((Double)calculatedVar.getMethod().invoke((Object)((EAgent)iterator2.next()), null)).doubleValue();
                        ++n;
                    }
                    this.hashValues.put(calculatedVar.getName(), new Double(d / (double)n));
                    continue;
                }
                if (calculatedVar.getType() == CalculatedVar.NUMBER) {
                    double d = 0.0;
                    double d2 = 0.0;
                    Iterator iterator3 = this.eWorld.iterator();
                    while (iterator3.hasNext()) {
                        if (calculatedVar.getMethod().invoke((Object)((EAgent)iterator3.next()), null).equals(calculatedVar.getAttributes())) {
                            d += 1.0;
                        }
                        d2 += 1.0;
                    }
                    this.hashValues.put(calculatedVar.getName(), new Double(d / d2 * 100.0));
                    continue;
                }
                if (calculatedVar.getType() == CalculatedVar.VALUE) {
                    double d = 0.0;
                    iterator = this.eWorld.iterator();
                    while (iterator.hasNext()) {
                        if (!((EAgent)iterator.next()).equals(calculatedVar.getAttributes())) continue;
                        d = (Double)calculatedVar.getMethod().invoke((Object)((EAgent)iterator.next()), null);
                    }
                    this.hashValues.put(calculatedVar.getName(), new Double(d));
                    continue;
                }
                if (calculatedVar.getType() == CalculatedVar.MINIMUM) {
                    double d = Double.MAX_VALUE;
                    iterator = this.eWorld.iterator();
                    while (iterator.hasNext()) {
                        d = Math.min((Double)calculatedVar.getMethod().invoke((Object)((EAgent)iterator.next()), null), d);
                    }
                    this.hashValues.put(calculatedVar.getName(), new Double(d));
                    continue;
                }
                if (calculatedVar.getType() != CalculatedVar.MAXIMUM) continue;
                double d = Double.MIN_VALUE;
                iterator = this.eWorld.iterator();
                while (iterator.hasNext()) {
                    d = Math.max((Double)calculatedVar.getMethod().invoke((Object)((EAgent)iterator.next()), null), d);
                }
                this.hashValues.put(calculatedVar.getName(), new Double(d));
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println(this.getClass().getPackage().getName() + " " + invocationTargetException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println(illegalAccessException.toString());
            }
        }
    }
}

