/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.grapheco.graphix;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.Icon;
import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.EWorld;
import modulecoGUI.CentralControl;
import modulecoGUI.grapheco.CAgentRepresentation;
import modulecoGUI.grapheco.CBufferedCanvas;
import modulecoGUI.grapheco.graphix.Graphique;

public class BarChart
extends CBufferedCanvas
implements CAgentRepresentation {
    public EWorld eWorld;
    protected int refresh = 1;
    protected int size;
    public String name;
    protected int[] Bar;
    protected int numBar = 20;
    protected Vector value;
    protected Graphique oldRepresentation;
    protected int max = 0;
    protected int start;
    protected int end;
    protected int bande;
    protected int iter = 0;
    protected int yMin = 0;
    protected int yMax = 100;
    protected int yMaxI = 100;
    protected int yInter = 25;
    protected int xMin = 0;
    protected int xBase = 0;
    protected int yBase = 0;
    protected int xMaxI = 100;
    protected int xMax = 100;
    protected int xInter = 10;
    protected int xInterI = 10;
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    protected boolean cleanGraph = false;
    protected Color colorBar;

    public BarChart() {
        this(11, 10);
    }

    public BarChart(int n, int n2) {
        int n3 = 0;
        this.value = new Vector();
        this.init(this.numBar, n3, n2);
        this.colorBar = Color.blue;
    }

    public void init(int n, int n2, int n3) {
        this.numBar = n;
        this.Bar = new int[this.numBar];
        this.start = n2;
        this.end = n3;
        this.xMaxI = n3;
        this.xMax = n3;
        this.bande = Math.round((this.end - this.start) / this.numBar);
        this.xInterI = (int)Math.ceil((this.end - this.start) / this.numBar);
        this.xInter = (int)Math.ceil((this.end - this.start) / this.numBar);
        if (this.bande == 0) {
            this.bande = 1;
        }
        if (this.xInter == 0) {
            this.xInter = 1;
        }
        if (this.xInterI == 0) {
            this.xInterI = 1;
        }
        this.resetBarChart();
    }

    public void setCAgent(CAgent cAgent) {
        this.eWorld = (EWorld)cAgent;
        this.setGridSize(this.eWorld.getAgentSetSize());
        this.updateImage();
    }

    public void setGridSize(int n) {
        this.size = (int)Math.sqrt(n);
    }

    public void resetBarChart() {
        for (int i = 0; i < this.numBar; ++i) {
            this.Bar[i] = 0;
        }
        this.yMax = this.yMaxI;
        this.xMax = this.xMaxI;
        this.xInter = this.xInterI;
        this.setBackground(Color.lightGray);
        this.cleanGraph = true;
        this.repaint();
        this.setVisible(true);
    }

    public void buildBarChart() {
        int n;
        int n2 = 100;
        int n3 = this.value.size();
        for (int i = 0; i < n3; ++i) {
            if ((Integer)this.value.elementAt(i) <= n2) continue;
            n2 = (Integer)this.value.elementAt(i);
            System.out.println("max = " + n2);
        }
        Vector vector = (Vector)this.value.clone();
        this.value.clear();
        for (n = 0; n < n3; ++n) {
            this.value.addElement(new Integer(100 * (Integer)vector.elementAt(n) / n2));
        }
        for (n = 0; n < this.numBar; ++n) {
            this.Bar[n] = 0;
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < this.numBar; ++i) {
                if ((Integer)this.value.elementAt(n) < i * this.bande || (Integer)this.value.elementAt(n) >= (i + 1) * this.bande) continue;
                int n4 = i;
                this.Bar[n4] = this.Bar[n4] + 1;
            }
        }
    }

    public void setColorBar(Color color) {
        this.colorBar = color;
    }

    public void drawBarChart(Graphics graphics) {
        for (int i = 0; i < this.numBar; ++i) {
            graphics.setColor(this.colorBar);
            graphics.fillRect(this.xScreen(this.bande * i) + 1, this.yScreen(0) - (this.dimension.height - this.y2) * this.Bar[i] / this.yMax, (this.dimension.width - this.x1 - this.x2) * this.bande / this.xMax, (this.dimension.height - this.y2) * this.Bar[i] / this.yMax);
            graphics.setColor(Color.black);
            graphics.drawRect(this.xScreen(this.bande * i) + 1, this.yScreen(0) - (this.dimension.height - this.y2) * this.Bar[i] / this.yMax, (this.dimension.width - this.x1 - this.x2) * this.bande / this.xMax, (this.dimension.height - this.y2) * this.Bar[i] / this.yMax);
        }
    }

    public void draw(Graphics graphics) {
        for (int i = 0; i < this.numBar; ++i) {
            if (this.Bar[i] <= this.max) continue;
            this.max = this.Bar[i];
        }
        this.yMaxI = this.max + 1;
        this.yMax = this.max + 1;
        this.yInter = (int)Math.ceil(this.yMax / 10);
        if (this.yInter == 0) {
            this.yInter = 1;
        }
        FontMetrics fontMetrics = this.getFontMetrics(graphics.getFont());
        this.x1 = 0;
        this.y2 = fontMetrics.getHeight();
        this.x2 = 50;
        this.y1 = 10;
        int n = this.yMin;
        graphics.setColor(Color.lightGray.brighter());
        graphics.fill3DRect(0, 0, this.dimension.width, this.dimension.height, true);
        graphics.setColor(Color.black);
        for (n = (this.yMin - this.yBase) % this.yInter == 0 ? this.yMin : ((this.yMin - this.yBase) / this.yInter + 1) * this.yInter + this.yBase; n <= this.yMax; n += this.yInter) {
            if (fontMetrics.stringWidth("" + n) > this.x1) {
                this.x1 = fontMetrics.stringWidth("" + n);
            }
            graphics.drawString("" + n, 5, this.yScreen(n) + 3);
        }
        this.x1 += 10;
        for (n = (this.yMin - this.yBase) % this.yInter == 0 ? this.yMin : ((this.yMin - this.yBase) / this.yInter + 1) * this.yInter + this.yBase; n <= this.yMax; n += this.yInter) {
            graphics.drawLine(this.x1, this.yScreen(n), this.x1 + 3, this.yScreen(n));
        }
        for (n = (this.xMin - this.xBase) % this.xInter == 0 ? this.xMin : ((this.xMin - this.xBase) / this.xInter + 1) * this.xInter + this.xBase; n <= this.xMax; n += this.xInter) {
            graphics.drawString("" + n, this.xScreen(n) + fontMetrics.stringWidth("" + n) / 2, this.dimension.height - 5);
        }
        for (n = (this.xMin - this.xBase) % this.xInter == 0 ? this.xMin : ((this.xMin - this.xBase) / this.xInter + 1) * this.xInter + this.xBase; n <= this.xMax; n += this.xInter) {
            graphics.drawLine(this.xScreen(n), this.dimension.height - this.y2, this.xScreen(n), this.dimension.height - this.y2 - 3);
        }
        graphics.drawLine(this.x1, this.y1, this.x1, this.dimension.height - this.y2);
        graphics.drawLine(this.x1, this.dimension.height - this.y2, this.dimension.width - this.x2, this.dimension.height - this.y2);
        this.drawBarChart(graphics);
    }

    public void setHauteur(int n) {
        this.max = n;
    }

    public void setNumBar(int n) {
        this.numBar = n;
    }

    private int xScreen(int n) {
        return this.x1 + (n - this.xMin) * (this.dimension.width - (this.x1 + this.x2)) / (this.xMax - this.xMin);
    }

    private int yScreen(int n) {
        return this.dimension.height - this.y2 - (n - this.yMin) * (this.dimension.height - (this.y1 + this.y2)) / (this.yMax - this.yMin);
    }

    public CAgentRepresentation setVectorBarChart(Vector vector) {
        this.value = vector;
        return this;
    }

    public CAgentRepresentation addElement(int n) {
        int n2 = n;
        if (n > this.max) {
            this.max = n;
            this.value.addElement(new Integer(100));
            this.resetBarChart();
            this.buildBarChart();
        } else {
            n2 = 100 * n / this.max;
            this.value.addElement(new Integer(n2));
        }
        return this;
    }

    public void updateImage() {
        this.value = this.getValue();
        this.buildBarChart();
        super.updateImage();
    }

    public Vector getValue() {
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Icon getIcon() {
        return null;
    }

    public String getDefaultPosition() {
        return null;
    }

    public void setDefaultPosition(String string) {
    }

    public CAgent getCAgent() {
        return null;
    }

    public CentralControl getCentralControl() {
        return null;
    }

    public void setIcon(Icon icon) {
    }
}

