/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.grapheco;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.EWorld;
import modulecoGUI.CentralControl;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;
import modulecoGUI.grapheco.CAgentRepresentation;
import modulecoGUI.grapheco.CBufferedCanvas;

public class Canevas
extends CBufferedCanvas
implements CAgentRepresentation {
    private static final long serialVersionUID = 414832244465993555L;
    public String name = "Canevas";
    protected EWorld eWorld;
    protected char[][][] state;
    protected MenuItem menuItemEditAgent;
    protected MenuItem menuItemEditWorld;
    protected Color[][] c;
    protected int size;
    protected final Color fondcanvas = Color.lightGray;
    protected int xc;
    protected int yd;

    public Canevas() {
        this.setColors();
        this.setBackground(this.fondcanvas);
        this.menuItemEditAgent = new MenuItem("Edit Agent");
        this.menuItemEditWorld = new MenuItem("Edit World");
        this.menuItemEditAgent.addActionListener(this);
        this.menuItemEditWorld.addActionListener(this);
    }

    public void setCAgent(CAgent cAgent) {
        this.eWorld = (EWorld)cAgent;
        this.setGridSize();
    }

    public void setGridSize() {
        this.size = new Double(Math.sqrt(this.eWorld.getAgentSetSize())).intValue();
        this.state = new char[this.size][this.size][2];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.state[j][i][0] = (Boolean)((CAgent)this.eWorld.get(j * this.size + i)).getState() != false ? (char)'\u0000' : '\u0001';
                this.state[j][i][1] = this.state[j][i][0];
            }
        }
        this.drawAble = true;
    }

    protected void setColors() {
        this.c = new Color[2][2];
        this.c[0][0] = Color.blue;
        this.c[1][1] = Color.red;
        this.c[1][0] = Color.yellow;
        this.c[0][1] = Color.green;
    }

    protected void drawPoint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.eWorld != null) {
            this.state[n2][n][0] = this.state[n2][n][1];
            this.state[n2][n][1] = (Boolean)((CAgent)this.eWorld.get(n2 * this.size + n)).getState() != false ? (char)'\u0000' : '\u0001';
            graphics.setColor(this.c[this.state[n2][n][0]][this.state[n2][n][1]]);
            int n7 = n * n3;
            int n8 = n2 * n4;
            if (this.size < 40) {
                graphics.fillArc(n7 + 1 + n5 / 2, n8 + 1 + n6 / 2, n3 - 2, n4 - 2, 0, 360);
            } else {
                graphics.fillRect(n7 + 1 + n5 / 2, n8 + 1 + n6 / 2, n3, n4);
            }
        }
    }

    protected void drawFirstTime(Graphics graphics) {
        this.draw(graphics);
    }

    protected void draw(Graphics graphics) {
        if (graphics != null) {
            graphics.setColor(Color.lightGray);
            graphics.fill3DRect(0, 0, this.dimension.width - 1, this.dimension.height - 1, true);
            if (this.drawAble) {
                int n;
                int n2 = this.dimension.width / this.size;
                int n3 = this.dimension.width - n2 * this.size;
                int n4 = this.dimension.height / this.size;
                int n5 = this.dimension.height - n4 * this.size;
                if (this.size < 40) {
                    graphics.setColor(Color.red.darker().darker());
                    for (n = 0; n < this.size; ++n) {
                        graphics.drawLine(n3 / 2, n * n4 + n5 / 2, this.dimension.width - n3 / 2, n * n4 + n5 / 2);
                    }
                    for (n = 0; n < this.size; ++n) {
                        graphics.drawLine(n * n2 + n3 / 2, n5 / 2, n * n2 + n3 / 2, this.dimension.height - n5 / 2);
                    }
                }
                for (n = 0; n < this.size; ++n) {
                    for (int i = 0; i < this.size; ++i) {
                        this.drawPoint(graphics, n, i, n2, n4, n3, n5);
                    }
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.dimension.width / this.size;
        int n2 = this.dimension.width - n * this.size;
        int n3 = this.dimension.height / this.size;
        int n4 = this.dimension.height - n3 * this.size;
        this.xc = (mouseEvent.getX() - n2 / 2) / n + 1;
        this.yd = (mouseEvent.getY() - n4 / 2) / n3 + 1;
        if ((mouseEvent.getModifiers() & 4) == 4) {
            if (mouseEvent.getX() > n2 / 2 && mouseEvent.getX() < this.dimension.width - n2 / 2 && this.yd > 0 && this.yd < this.size + 1) {
                this.popupMenu.add(this.menuItemEditAgent);
                this.popupMenu.add(this.menuItemEditWorld);
            } else {
                this.popupMenu.remove(this.menuItemEditAgent);
                this.popupMenu.remove(this.menuItemEditWorld);
            }
            super.mouseClicked(mouseEvent);
        } else if (mouseEvent.getX() > n2 / 2 && mouseEvent.getX() < this.dimension.width - n2 / 2 && this.yd > 0 && this.yd < this.size + 1) {
            ((EAgent)this.eWorld.get((this.yd - 1) * this.size + (this.xc - 1))).inverseState();
            this.repaint();
        }
    }

    public EAgent getAgentAt(int n, int n2) {
        int n3 = n2 * this.size + n;
        return (EAgent)this.eWorld.get(n3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.menuItemEditAgent)) {
            this.centralControl.editAgent(this.getAgentAt(this.xc - 1, this.yd - 1));
        } else if (!actionEvent.getSource().equals(this.menuItemEditWorld)) {
            super.actionPerformed(actionEvent);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Icon getIcon() {
        return null;
    }

    public String getDefaultPosition() {
        return AbstractCAgentRepresentation.LEFT_POSITION;
    }

    public void setDefaultPosition(String string) {
    }

    public CAgent getCAgent() {
        return null;
    }

    public void setIcon(Icon icon) {
    }

    public void setCentralControl(CentralControl centralControl) {
        this.centralControl = centralControl;
    }

    public CentralControl getCentralControl() {
        return null;
    }
}

