/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import modulecoGUI.cAgentEditor.editors.NumberDocument;
import modulecoGUI.cAgentEditor.editors.SwingEditorSupport;
import modulecoGUI.cAgentEditor.editors.SwingEnumEditor;

public class SwingObjectEditor
extends SwingEditorSupport {
    private SwingEnumEditor enumEditor = new SwingEnumEditor();
    private JTextField textfield = new JTextField();
    private boolean isEnumeration = false;

    public SwingObjectEditor() {
        this.textfield.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingObjectEditor.this.handleAction();
            }
        });
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.textfield);
    }

    public void setValue(Object object) {
        if (this.isEnumeration) {
            this.enumEditor.setValue(object);
        } else {
            super.setValue(object);
            if (object != null) {
                int n;
                String string = object.toString();
                if (string == null) {
                    string = "";
                }
                if ((n = string.indexOf(64)) != -1) {
                    string = string.substring(0, n);
                }
                this.textfield.setText(string);
            } else {
                this.textfield.setText("");
            }
        }
    }

    public Object getValue() {
        if (this.isEnumeration) {
            return this.enumEditor.getValue();
        }
        return super.getValue();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.enumEditor.addPropertyChangeListener(propertyChangeListener);
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.enumEditor.removePropertyChangeListener(propertyChangeListener);
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public void init(PropertyDescriptor propertyDescriptor) {
        Object[] objectArray = (Object[])propertyDescriptor.getValue("enumerationValues");
        if (objectArray != null) {
            this.isEnumeration = true;
            this.enumEditor.init(propertyDescriptor);
        } else {
            this.isEnumeration = false;
            if (this.textfield == null) {
                this.textfield = new JTextField();
                this.textfield.setDocument(new NumberDocument());
                this.textfield.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            SwingObjectEditor.this.setValue(new Integer(SwingObjectEditor.this.textfield.getText()));
                        }
                    }
                });
                this.panel = new JPanel();
                this.panel.setLayout(new BoxLayout(this.panel, 0));
                this.panel.add(this.textfield);
            }
        }
    }

    private void handleAction() {
        String string = this.textfield.getText();
        try {
            Object object = Beans.instantiate(this.getClass().getClassLoader(), string);
            this.setValue(object);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.panel, "Can't find or load\n" + string);
        }
    }

    public Component getCustomEditor() {
        if (this.isEnumeration) {
            return this.enumEditor.getCustomEditor();
        }
        return super.getCustomEditor();
    }
}

