/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor.editors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalComboBoxIcon;
import modulecoGUI.cAgentEditor.editors.ChooserComboPopup;
import modulecoGUI.cAgentEditor.editors.SwingEditorSupport;

public class SwingColorEditor
extends SwingEditorSupport {
    private JTextField rgbValue;
    private JButton colorChooserButton;
    private Color color = Color.black;
    private ChooserComboButton colorChooserCombo;

    public SwingColorEditor() {
        this.createComponents();
        this.addComponentListeners();
    }

    private void addComponentListeners() {
        this.rgbValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SwingColorEditor.this.setAsText(SwingColorEditor.this.getAsText());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JOptionPane.showMessageDialog(SwingColorEditor.this.panel.getParent(), illegalArgumentException.toString());
                }
            }
        });
        this.colorChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingColorEditor.this.color = JColorChooser.showDialog(SwingColorEditor.this.panel.getParent(), "Color Chooser", SwingColorEditor.this.color);
                SwingColorEditor.this.setValue(SwingColorEditor.this.color);
            }
        });
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 3, rectangle.height - 3);
        graphics.setColor(this.color);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 4, rectangle.height - 4);
        graphics.setColor(color);
    }

    private void createComponents() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.put("beaninfo.ColorIcon", LookAndFeel.makeIcon(this.getClass(), "resources/ColorIcon.gif"));
        uIDefaults.put("beaninfo.ColorPressedIcon", LookAndFeel.makeIcon(this.getClass(), "resources/ColorPressedIcon.gif"));
        Icon icon = UIManager.getIcon("beaninfo.ColorIcon");
        Icon icon2 = UIManager.getIcon("beaninfo.ColorPressedIcon");
        this.rgbValue = new JTextField();
        this.colorChooserCombo = new ChooserComboButton();
        this.colorChooserButton = new JButton(icon);
        Dimension dimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        this.rgbValue.setPreferredSize(SwingEditorSupport.MEDIUM_DIMENSION);
        this.rgbValue.setMaximumSize(SwingEditorSupport.MEDIUM_DIMENSION);
        this.rgbValue.setMinimumSize(SwingEditorSupport.MEDIUM_DIMENSION);
        this.colorChooserCombo.setPreferredSize(SwingEditorSupport.SMALL_DIMENSION);
        this.colorChooserCombo.setMaximumSize(SwingEditorSupport.SMALL_DIMENSION);
        this.colorChooserCombo.setMinimumSize(SwingEditorSupport.SMALL_DIMENSION);
        this.colorChooserButton.setPressedIcon(icon2);
        this.colorChooserButton.setToolTipText("press to bring up color chooser");
        this.colorChooserButton.setMargin(SwingEditorSupport.BUTTON_MARGIN);
        this.colorChooserButton.setBorderPainted(false);
        this.colorChooserButton.setContentAreaFilled(false);
        this.setAlignment(this.rgbValue);
        this.setAlignment(this.colorChooserCombo);
        this.setAlignment(this.colorChooserButton);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.rgbValue);
        this.panel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.panel.add(this.colorChooserCombo);
        this.panel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.panel.add(this.colorChooserButton);
        this.panel.setAlignmentX(0.0f);
    }

    public String getJavaInitializationString() {
        return "new java.awt.Color(" + this.getAsText() + ")";
    }

    public String getAsText() {
        return this.rgbValue.getText();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n = string.indexOf(44);
        int n2 = string.indexOf(44, n + 1);
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException(string);
        }
        try {
            int n3 = Integer.parseInt(string.substring(0, n));
            int n4 = Integer.parseInt(string.substring(n + 1, n2));
            int n5 = Integer.parseInt(string.substring(n2 + 1));
            this.setValue(new Color(n3, n4, n5));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string);
        }
    }

    public void setValue(Object object) {
        super.setValue(object);
        this.editorChangeValue(object);
    }

    public void editorChangeValue(Object object) {
        Color color = (Color)object;
        if (color == null) {
            this.rgbValue.setText("                  ");
            this.colorChooserCombo.setBackground(this.panel.getBackground());
            return;
        }
        this.color = color;
        this.rgbValue.setText("" + color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        this.colorChooserCombo.setBackground(color);
    }

    public SwingColorEditor getSwingColorEditor() {
        return this;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                jFrame.dispose();
                System.exit(0);
            }
        });
        SwingColorEditor swingColorEditor = new SwingColorEditor();
        jFrame.getContentPane().add(swingColorEditor.getCustomEditor());
        jFrame.pack();
        jFrame.show();
    }

    class ChooserComboButton
    extends JButton {
        ChooserComboPopup popup;
        Icon comboIcon;

        public ChooserComboButton() {
            super("");
            this.comboIcon = new MetalComboBoxIcon();
            this.popup = new ChooserComboPopup(SwingColorEditor.this.getSwingColorEditor());
            this.addMouseListener(new PopupListener());
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Insets insets = this.getInsets();
            int n = this.getWidth() - (insets.left + insets.right);
            int n2 = this.getHeight() - (insets.top + insets.bottom);
            if (n2 <= 0 || n <= 0) {
                return;
            }
            int n3 = insets.left;
            int n4 = insets.top;
            int n5 = n3 + (n - 1);
            int n6 = n4 + (n2 - 1);
            int n7 = 0;
            int n8 = n5;
            if (this.comboIcon != null) {
                n7 = this.comboIcon.getIconWidth();
                int n9 = this.comboIcon.getIconHeight();
                int n10 = 0;
                n10 = n4 + (n6 - n4) / 2 - n9 / 2;
                this.comboIcon.paintIcon(this, graphics, n8, n10);
            }
        }

        class PopupListener
        extends MouseAdapter {
            PopupListener() {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JComponent jComponent = (JComponent)mouseEvent.getComponent();
                ChooserComboButton.this.popup.show(jComponent, 0, 0);
            }
        }
    }
}

