/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import modulecoGUI.cAgentEditor.editors.BorderChooser;
import modulecoGUI.cAgentEditor.editors.SwingEditorSupport;

public class SwingBorderEditor
extends SwingEditorSupport {
    private JComboBox borderCombo;
    private JButton borderButton;
    private BorderDialog borderDialog;
    private Border etched = BorderFactory.createEtchedBorder();
    private Border bevelLowered = BorderFactory.createLoweredBevelBorder();
    private Border bevelRaised = BorderFactory.createRaisedBevelBorder();
    private Border line = BorderFactory.createLineBorder(Color.black);
    private Border[] borders = new Border[]{this.etched, this.bevelLowered, this.bevelRaised, this.line};
    private Border border;

    public SwingBorderEditor() {
        this.createComponents();
        this.addComponentListeners();
    }

    private void createComponents() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.setAlignmentX(0.0f);
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.put("beaninfo.BorderIcon", LookAndFeel.makeIcon(this.getClass(), "resources/BorderIcon.gif"));
        uIDefaults.put("beaninfo.BorderBevelLowered", LookAndFeel.makeIcon(this.getClass(), "resources/BorderBevelLowered.gif"));
        uIDefaults.put("beaninfo.BorderBevelRaised", LookAndFeel.makeIcon(this.getClass(), "resources/BorderBevelRaised.gif"));
        uIDefaults.put("beaninfo.BorderEtched", LookAndFeel.makeIcon(this.getClass(), "resources/BorderEtched.gif"));
        uIDefaults.put("beaninfo.BorderLine", LookAndFeel.makeIcon(this.getClass(), "resources/BorderLine.gif"));
        Icon icon = UIManager.getIcon("beaninfo.BorderIcon");
        this.borderCombo = this.createComboBox();
        this.borderButton = new JButton(icon);
        Dimension dimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        this.borderButton.setMargin(SwingEditorSupport.BUTTON_MARGIN);
        this.setAlignment(this.borderCombo);
        this.setAlignment(this.borderButton);
        this.panel.add(this.borderCombo);
        this.panel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.panel.add(this.borderButton);
        this.panel.add(Box.createHorizontalGlue());
    }

    private void addComponentListeners() {
        this.borderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingBorderEditor.this.borderDialog == null) {
                    SwingBorderEditor.this.borderDialog = new BorderDialog(SwingBorderEditor.this.panel.getParent(), "Border Chooser");
                }
                SwingBorderEditor.this.border = SwingBorderEditor.this.borderDialog.showDialog();
                if (!SwingBorderEditor.this.borderDialog.isCancelled()) {
                    SwingBorderEditor.this.setValue(SwingBorderEditor.this.border);
                }
            }
        });
    }

    public void setValue(Object object) {
        super.setValue(object);
    }

    private JComboBox createComboBox() {
        DefaultComboBoxModel<Integer> defaultComboBoxModel = new DefaultComboBoxModel<Integer>();
        for (int i = 0; i < 4; ++i) {
            defaultComboBoxModel.addElement(new Integer(i));
        }
        JComboBox jComboBox = new JComboBox(defaultComboBoxModel);
        jComboBox.setRenderer(new TestCellRenderer(jComboBox));
        jComboBox.setPreferredSize(SwingEditorSupport.MEDIUM_DIMENSION);
        jComboBox.setMinimumSize(SwingEditorSupport.MEDIUM_DIMENSION);
        jComboBox.setMaximumSize(SwingEditorSupport.MEDIUM_DIMENSION);
        jComboBox.setSelectedIndex(-1);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                SwingBorderEditor.this.border = SwingBorderEditor.this.borders[jComboBox.getSelectedIndex()];
                SwingBorderEditor.this.setValue(SwingBorderEditor.this.border);
            }
        });
        return jComboBox;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        SwingBorderEditor swingBorderEditor = new SwingBorderEditor();
        jFrame.getContentPane().add(swingBorderEditor.getCustomEditor());
        jFrame.pack();
        jFrame.show();
    }

    class BorderDialog
    extends JDialog {
        JPanel pane;
        JButton okButton;
        BorderChooser borderChooser;
        Border border;
        boolean cancel;

        public BorderDialog(Component component, String string) {
            super(JOptionPane.getFrameForComponent(component), string, true);
            this.border = null;
            this.cancel = false;
            Container container = this.getContentPane();
            this.pane = new JPanel();
            container.setLayout(new BorderLayout());
            this.okButton = new JButton("OK");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BorderDialog.this.border = BorderDialog.this.getBorder();
                }
            };
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.setActionCommand("OK");
            if (actionListener != null) {
                this.okButton.addActionListener(actionListener);
            }
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BorderDialog.this.hide();
                }
            });
            JButton jButton = new JButton("Cancel");
            jButton.setActionCommand("cancel");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BorderDialog.this.cancel = true;
                    BorderDialog.this.hide();
                }
            });
            this.addBorderChooser(this.pane);
            this.pane.add(this.okButton);
            this.pane.add(jButton);
            container.add((Component)this.pane, "Center");
            this.pack();
            this.addWindowListener(new Closer());
            this.addComponentListener(new DisposeOnClose());
        }

        public void addBorderChooser(JPanel jPanel) {
            this.borderChooser = new BorderChooser();
            jPanel.add(this.borderChooser);
        }

        public void setBorder() {
        }

        public Border getBorder() {
            return this.borderChooser.getSelectedBorder();
        }

        public Border showDialog() {
            this.cancel = false;
            this.show();
            return this.getBorder();
        }

        public boolean isCancelled() {
            return this.cancel;
        }

        class DisposeOnClose
        extends ComponentAdapter {
            DisposeOnClose() {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                Window window = (Window)componentEvent.getComponent();
                window.dispose();
            }
        }

        class Closer
        extends WindowAdapter {
            Closer() {
            }

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.hide();
            }
        }
    }

    class TestCellRenderer
    extends JLabel
    implements ListCellRenderer {
        JComboBox combobox;
        Icon[] images = new Icon[]{UIManager.getIcon("beaninfo.BorderEtched"), UIManager.getIcon("beaninfo.BorderBevelLowered"), UIManager.getIcon("beaninfo.BorderBevelRaised"), UIManager.getIcon("beaninfo.BorderLine")};
        String[] desc = new String[]{"Etched", "BevelLowered", "BevelRaised", "Line"};

        public TestCellRenderer(JComboBox jComboBox) {
            this.combobox = jComboBox;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                this.setIcon(null);
            } else {
                int n2 = (Integer)object;
                if (n2 < 0) {
                    this.setText("");
                    this.setIcon(null);
                } else {
                    String string = " " + this.desc[n2];
                    this.setIcon(this.images[n2]);
                    this.setText(string);
                    if (bl) {
                        this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                        this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                    } else {
                        this.setBackground(UIManager.getColor("ComboBox.background"));
                        this.setForeground(UIManager.getColor("ComboBox.foreground"));
                    }
                }
            }
            return this;
        }
    }
}

