/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Hashtable;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import modulecoGUI.cAgentEditor.PropertyTableModel;
import modulecoGUI.cAgentEditor.editors.SwingEditorSupport;

public class PropertyValueEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer,
PropertyChangeListener {
    private PropertyEditor editor;
    private DefaultCellEditor cellEditor;
    private Class type;
    private Border selectedBorder;
    private Border emptyBorder;
    private Hashtable editors = new Hashtable();

    public PropertyValueEditor() {
        this.cellEditor = new DefaultCellEditor(new JTextField());
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return this.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Object object2;
        PropertyTableModel propertyTableModel = (PropertyTableModel)jTable.getModel();
        this.type = propertyTableModel.getPropertyType(n);
        if (this.type != null) {
            this.editor = (PropertyEditor)this.editors.get(this.type);
            if (this.editor == null && (object2 = propertyTableModel.getPropertyEditor(n)) != null) {
                Class<?> clazz = object2.getClass();
                try {
                    this.editor = (PropertyEditor)clazz.newInstance();
                    this.editor.addPropertyChangeListener(this);
                    this.editors.put(this.type, this.editor);
                }
                catch (Exception exception) {
                    System.out.println("Couldn't instantiate type editor \"" + clazz.getName() + "\" : " + exception);
                }
            }
        } else {
            this.editor = null;
        }
        if (this.editor != null) {
            if (this.editor instanceof SwingEditorSupport) {
                ((SwingEditorSupport)this.editor).init(propertyTableModel.getPropertyDescriptor(n));
            }
            this.editor.setValue(object);
            object2 = this.editor.getCustomEditor();
            if (object2 != null) {
                ((Component)object2).setEnabled(bl);
                if (object2 instanceof JComponent) {
                    if (bl) {
                        if (this.selectedBorder == null) {
                            this.selectedBorder = BorderFactory.createLineBorder(jTable.getSelectionBackground(), 1);
                        }
                    } else if (this.emptyBorder == null) {
                        this.emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
                    }
                }
                return object2;
            }
        }
        return this.cellEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public Object getCellEditorValue() {
        Object object = null;
        object = this.editor != null ? this.editor.getValue() : this.cellEditor.getCellEditorValue();
        if (this.type != null && object != null && !this.type.isPrimitive() && !this.type.isAssignableFrom(object.getClass())) {
            System.out.println("Type mismatch in getCellEditorValue() = " + object.getClass() + " type = " + this.type);
            try {
                object = this.type.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.stopCellEditing();
    }

    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }
}

