/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.EAgentLinks;
import modulecoGUI.XMLGuiReader.XMLGuiReader;

public class JAgentLinksEditor
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7215486076310021497L;
    protected EAgent agent;
    protected int minRowHeight = 24;
    protected int intercellSpacing = 1;
    protected int action;
    public static int APPROVE_OPTION = 1;
    protected JDialog jDialog;
    protected JPanel jPanelNewNeighbour;
    protected JLabel jLabelNewNeighbour;
    protected JTextField jTextFieldNewNeighbour;
    protected JPanel jPanelButton;
    protected JButton jButtonOk;
    protected JButton jButtonAnnuler;
    JTableModelNeighbours jtmn;

    public JAgentLinksEditor(EAgent eAgent) {
        super(new BorderLayout());
        this.agent = eAgent;
        this.build();
    }

    public void build() {
        this.jPanelNewNeighbour = new JPanel(new FlowLayout());
        this.jLabelNewNeighbour = new JLabel(XMLGuiReader.getLabel("JAgentLinksEditor/LabelNewNeighbour") + "[0-" + (this.agent.getWorld().getAgentSetSize() - 1) + "] : ");
        this.jTextFieldNewNeighbour = new JTextField("");
        this.jTextFieldNewNeighbour.setToolTipText(XMLGuiReader.getToolTipText("JAgentLinksEditor/TextFieldNewNeighbour"));
        this.jTextFieldNewNeighbour.setMinimumSize(new Dimension(50, 20));
        this.jTextFieldNewNeighbour.setPreferredSize(new Dimension(50, 20));
        this.jPanelNewNeighbour.add(this.jLabelNewNeighbour);
        this.jPanelNewNeighbour.add(this.jTextFieldNewNeighbour);
        final JTableModelNeighbours jTableModelNeighbours = this.jtmn = new JTableModelNeighbours(this.agent);
        this.jTextFieldNewNeighbour.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    try {
                        int n = Integer.valueOf(JAgentLinksEditor.this.jTextFieldNewNeighbour.getText());
                        jTableModelNeighbours.addNeighbour((EAgent)JAgentLinksEditor.this.agent.getWorld().get(n));
                        JAgentLinksEditor.this.jTextFieldNewNeighbour.setText("");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        JTable jTable = new JTable(this.jtmn);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        JComboBox<Boolean> jComboBox = new JComboBox<Boolean>();
        jComboBox.addItem(new Boolean(true));
        jComboBox.addItem(new Boolean(false));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        this.jButtonOk = new JButton("Ok");
        this.jButtonAnnuler = new JButton("Cancel");
        this.jButtonOk.addActionListener(this);
        this.jButtonAnnuler.addActionListener(this);
        this.jPanelButton = new JPanel(new FlowLayout());
        this.jPanelButton.add(this.jButtonAnnuler);
        this.jPanelButton.add(this.jButtonOk);
        this.add((Component)this.jPanelNewNeighbour, "North");
        this.add((Component)new JScrollPane(jTable), "Center");
        this.add((Component)this.jPanelButton, "South");
    }

    public void changeNeighbourhood(List list) {
        ArrayList arrayList = (ArrayList)this.agent.getNeighbours().clone();
        for (EAgent eAgent : arrayList) {
            if (list.contains(eAgent)) continue;
            this.agent.neighbours.remove(eAgent);
            eAgent.neighbours.remove(this.agent);
            try {
                ((EAgentLinks)this.agent).updateConnectivityIndex();
                ((EAgentLinks)eAgent).updateConnectivityIndex();
            }
            catch (Exception exception) {}
        }
        for (EAgent eAgent : list) {
            if (arrayList.contains(eAgent)) continue;
            this.agent.neighbours.add(eAgent);
            eAgent.neighbours.add(this.agent);
            try {
                ((EAgentLinks)this.agent).updateConnectivityIndex();
                ((EAgentLinks)eAgent).updateConnectivityIndex();
            }
            catch (Exception exception) {}
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.jButtonOk)) {
            this.jDialog.setVisible(false);
            this.changeNeighbourhood(this.jtmn.getNewNeighbours());
        } else if (actionEvent.getSource().equals(this.jButtonAnnuler)) {
            this.jDialog.setVisible(false);
        }
    }

    public int showAgentLinksEditor(Component component) {
        this.jDialog = this.createDialog(component);
        this.jDialog.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.jDialog.setLocation((dimension.width - this.jDialog.getWidth()) / 2, (dimension.height - this.jDialog.getHeight()) / 2);
        this.jDialog.setVisible(true);
        return APPROVE_OPTION;
    }

    protected JDialog createDialog(Component component) throws HeadlessException {
        Container container = SwingUtilities.getAncestorOfClass(JFrame.class, component);
        if (container != null) {
            JDialog jDialog = new JDialog((JFrame)container);
            jDialog.getContentPane().add(this);
            jDialog.setModal(true);
            jDialog.setTitle(XMLGuiReader.getLabel("JAgentLinksEditor/Frame") + this.agent.getName());
            jDialog.invalidate();
            jDialog.repaint();
            return jDialog;
        }
        return null;
    }

    class JTableModelNeighbours
    extends AbstractTableModel {
        private static final long serialVersionUID = 5481686026832493263L;
        EAgent eAgent;
        List allNeighbours;
        List neighbours;
        String[] columnName = new String[]{"Agents", "Neighbour"};

        public JTableModelNeighbours(EAgent eAgent) {
            this.eAgent = eAgent;
            this.allNeighbours = (List)this.eAgent.getNeighbours().clone();
            this.neighbours = (List)this.eAgent.getNeighbours().clone();
        }

        public String getColumnName(int n) {
            return this.columnName[n];
        }

        public List getNewNeighbours() {
            return this.neighbours;
        }

        public void addNeighbour(EAgent eAgent) {
            if (this.allNeighbours.contains(eAgent)) {
                if (!this.neighbours.contains(eAgent)) {
                    this.neighbours.add(eAgent);
                }
            } else {
                this.allNeighbours.add(eAgent);
                this.neighbours.add(eAgent);
            }
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.allNeighbours.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == this.getColumnCount() - 1) {
                if (((Boolean)object).equals(new Boolean(false))) {
                    this.neighbours.remove(this.allNeighbours.get(n));
                } else {
                    this.neighbours.add(this.allNeighbours.get(n));
                }
            }
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return "Agent " + ((EAgent)this.allNeighbours.get(n)).getAgentID();
            }
            if (n2 == 1) {
                Object e = this.allNeighbours.get(n);
                if (this.neighbours.contains(e)) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            return "null";
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }
    }
}

