/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import modulecoFramework.modeleco.EAgent;
import modulecoGUI.cAgentEditor.OutputTableModel;
import modulecoGUI.cAgentEditor.PropertyColumnModel;
import modulecoGUI.cAgentEditor.PropertyTableModel;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;

public class JAgentEditor
extends AbstractCAgentRepresentation
implements ActionListener {
    private static final long serialVersionUID = 8571046791350217667L;
    protected EAgent agent;
    protected int minRowHeight = 24;
    protected int intercellSpacing = 1;
    protected int action;
    public static int APPROVE_OPTION = 1;
    protected JPanel jPanelButton;
    protected JButton jButtonOK;
    protected JDialog jDialog;
    protected JFrame jFrame;
    protected JTabbedPane jTabbedPane;

    public JAgentEditor(EAgent eAgent) {
        this.setLayout(new BorderLayout());
        this.agent = eAgent;
        this.build();
    }

    private void build() {
        this.setLayout(new BorderLayout());
        this.jTabbedPane = new JTabbedPane();
        PropertyTableModel propertyTableModel = new PropertyTableModel(this.agent);
        PropertyColumnModel propertyColumnModel = new PropertyColumnModel();
        JTable jTable = new JTable(propertyTableModel, propertyColumnModel);
        this.setTable(jTable);
        this.jTabbedPane.addTab("Parameters", new JScrollPane(jTable));
        OutputTableModel outputTableModel = new OutputTableModel(this.agent);
        JTable jTable2 = new JTable(outputTableModel);
        this.jTabbedPane.addTab("Values", new JScrollPane(jTable2));
        this.add((Component)this.jTabbedPane, "Center");
        this.jPanelButton = new JPanel(new FlowLayout());
        this.jButtonOK = new JButton("OK");
        this.jButtonOK.addActionListener(this);
        this.jPanelButton.add(this.jButtonOK);
        this.add((Component)this.jPanelButton, "South");
    }

    private void setTable(JTable jTable) {
        jTable.setGridColor(UIManager.getColor("control"));
        jTable.setBackground(UIManager.getColor("control"));
        jTable.setAutoResizeMode(4);
        jTable.setIntercellSpacing(new Dimension(0, this.intercellSpacing));
        jTable.getTableHeader().setVisible(false);
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            Component component = jTable.getCellRenderer(i, 1).getTableCellRendererComponent(jTable, jTable.getValueAt(i, 1), false, false, i, 1);
            Component component2 = jTable.getCellRenderer(i, 2).getTableCellRendererComponent(jTable, jTable.getValueAt(i, 2), false, false, i, 2);
            Component component3 = jTable.getCellRenderer(i, 3).getTableCellRendererComponent(jTable, jTable.getValueAt(i, 3), false, false, i, 3);
            double d = component.getPreferredSize().getHeight();
            double d2 = component2.getPreferredSize().getHeight();
            double d3 = component3.getPreferredSize().getHeight();
            if (d > d2 && d > d3 && d > (double)this.minRowHeight) {
                jTable.setRowHeight(i, (int)d);
                continue;
            }
            if (d2 > d && d2 > d3 && d2 > (double)this.minRowHeight) {
                jTable.setRowHeight(i, (int)d2);
                continue;
            }
            jTable.setRowHeight(i, this.minRowHeight);
        }
    }

    public int showAgentEditor(Component component) {
        this.jFrame = new JFrame();
        this.jFrame.getContentPane().add(this);
        this.jFrame.setTitle("Edit Agent : " + this.agent.getName());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.jFrame.setSize(new Dimension(400, 400));
        this.jFrame.setLocation((dimension.width - this.jFrame.getWidth()) / 2, (dimension.height - this.jFrame.getHeight()) / 2);
        this.jFrame.setVisible(true);
        return 0;
    }

    protected JDialog createDialog(Component component) throws HeadlessException {
        Container container = SwingUtilities.getAncestorOfClass(JFrame.class, component);
        if (container != null) {
            JDialog jDialog = new JDialog((JFrame)container);
            jDialog.getContentPane().add(this);
            jDialog.setModal(false);
            jDialog.setTitle("Edit Agent : " + this.agent.getName());
            jDialog.invalidate();
            jDialog.repaint();
            return jDialog;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.jButtonOK)) {
            this.jFrame.setVisible(false);
            this.jFrame.dispose();
        }
    }

    public void updateImage() {
        this.repaint();
    }

    public void resetImage() {
    }
}

