/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import modulecoFramework.Moduleco;
import modulecoGUI.CentralControl;
import modulecoGUI.JPanelMain;
import modulecoGUI.XMLGuiReader.XMLGuiReader;
import modulecoGUI.debug.JFrameDebug;

public class ModulecoBean
extends JRootPane
implements ActionListener {
    private static final long serialVersionUID = 809409513531068575L;
    private JPanelMain jPanelMain;
    private JPanel contentPane;
    private CentralControl centralControl;
    private JMenuBar jMenuBar;
    private JMenu jMenuFile;
    private JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemOpenRecentFiles;
    private JMenuItem jMenuItemClose;
    private JMenu jMenuEdit;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemPaste;
    private JMenu jMenuDisplay;
    private JMenuItem jMenuItemDockingHierarchy;
    private JMenuItem jMenuItemModelProperties;
    private JMenuItem jMenuItemNeighbourhood;
    private JMenu jMenuTools;
    private JMenuItem jMenuItemLanguage;
    private JMenu jMenuWindow;
    private JMenuItem jMenuItemResetPerspective;
    private JMenuItem jMenuShowView;
    private JMenu jMenuMadkitTools;
    private JMenuItem jMenuItemExplorer;
    private JMenuItem jMenuItemGroupObserver;
    private JMenuItem jMenuItemOutput;
    private JMenu jMenuData;
    private JMenuItem jMenuItemRecordData;
    private JMenu jMenuLookAndFeel;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAboutModuleco;

    public ModulecoBean(CentralControl centralControl) {
        this.centralControl = centralControl;
        this.setPreferredSize(new Dimension(800, 600));
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.buildMenu();
        this.buildInterface();
    }

    public void init() {
        Container container = SwingUtilities.getAncestorOfClass(JFrame.class, this);
        JFrame jFrame = (JFrame)container;
        jFrame.setExtendedState(6);
        URL uRL = this.getClass().getResource("/images/logo-small.png");
        ImageIcon imageIcon = new ImageIcon(uRL, "logo");
        jFrame.setIconImage(imageIcon.getImage());
    }

    private void buildInterface() {
        this.jPanelMain = new JPanelMain(this.centralControl, this);
        this.contentPane.add((Component)this.jPanelMain, "Center");
    }

    private void buildMenu() {
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuFile"));
        this.jMenuItemOpen = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemOpen"));
        this.jMenuItemOpenRecentFiles = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemOpenRecentFiles"));
        this.jMenuItemClose = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemClose"));
        this.jMenuItemOpen.addActionListener(this);
        this.jMenuItemOpenRecentFiles.addActionListener(this);
        this.jMenuItemClose.addActionListener(this);
        this.jMenuFile.add(this.jMenuItemOpen);
        this.jMenuFile.add(this.jMenuItemOpenRecentFiles);
        this.jMenuFile.add(new JSeparator());
        this.jMenuFile.add(this.jMenuItemClose);
        this.jMenuEdit = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuEdit"));
        this.jMenuItemCut = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemCut"));
        this.jMenuItemCopy = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemCopy"));
        this.jMenuItemPaste = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemPaste"));
        this.jMenuItemCut.addActionListener(this);
        this.jMenuItemCopy.addActionListener(this);
        this.jMenuItemPaste.addActionListener(this);
        this.jMenuEdit.add(this.jMenuItemCut);
        this.jMenuEdit.add(this.jMenuItemCopy);
        this.jMenuEdit.add(this.jMenuItemPaste);
        this.jMenuDisplay = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuDisplay"));
        this.jMenuItemDockingHierarchy = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemDockingHierarchy"));
        this.jMenuItemModelProperties = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemModelProperties"));
        this.jMenuItemNeighbourhood = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemNeighbourhood"));
        this.jMenuItemDockingHierarchy.addActionListener(this);
        this.jMenuItemModelProperties.addActionListener(this);
        this.jMenuItemNeighbourhood.addActionListener(this);
        this.jMenuDisplay.add(this.jMenuItemDockingHierarchy);
        this.jMenuDisplay.add(this.jMenuItemModelProperties);
        this.jMenuDisplay.add(this.jMenuItemNeighbourhood);
        this.jMenuTools = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuTools"));
        this.jMenuItemLanguage = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemLanguage"));
        this.buildMenuLanguage(this.jMenuItemLanguage);
        this.jMenuItemLanguage.addActionListener(this);
        this.jMenuTools.add(this.jMenuItemLanguage);
        this.jMenuWindow = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuWindow"));
        this.jMenuItemResetPerspective = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemResetPerspective"));
        this.jMenuShowView = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuShowView"));
        this.jMenuItemResetPerspective.addActionListener(this);
        this.jMenuShowView.addActionListener(this);
        this.jMenuWindow.add(this.jMenuItemResetPerspective);
        this.jMenuWindow.add(this.jMenuShowView);
        this.jMenuMadkitTools = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuMadkitTools"));
        this.jMenuItemExplorer = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemExplorer"));
        this.jMenuItemGroupObserver = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemGroupObserver"));
        this.jMenuItemOutput = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemOutput"));
        this.jMenuItemExplorer.addActionListener(this);
        this.jMenuItemGroupObserver.addActionListener(this);
        this.jMenuItemOutput.addActionListener(this);
        this.jMenuMadkitTools.add(this.jMenuItemExplorer);
        this.jMenuMadkitTools.add(this.jMenuItemGroupObserver);
        this.jMenuMadkitTools.add(this.jMenuItemOutput);
        this.jMenuData = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuData"));
        this.jMenuItemRecordData = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemRecordData"));
        this.jMenuItemRecordData.addActionListener(this);
        this.jMenuData.add(this.jMenuItemRecordData);
        this.jMenuLookAndFeel = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuLookAndFeel"));
        this.buildMenuLookAndFeel();
        this.jMenuHelp = new JMenu(XMLGuiReader.getLabel("ModulecoBean/MenuHelp"));
        this.jMenuItemAboutModuleco = new JMenuItem(XMLGuiReader.getLabel("ModulecoBean/MenuItemAboutModuleco"));
        this.jMenuHelp.add(this.jMenuItemAboutModuleco);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuBar.add(this.jMenuEdit);
        this.jMenuBar.add(this.jMenuDisplay);
        this.jMenuBar.add(this.jMenuTools);
        this.jMenuBar.add(this.jMenuWindow);
        this.jMenuBar.add(this.jMenuMadkitTools);
        this.jMenuBar.add(this.jMenuData);
        this.jMenuBar.add(this.jMenuLookAndFeel);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
    }

    private void buildMenuLanguage(JMenuItem jMenuItem) {
    }

    private void buildMenuLookAndFeel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        Map map = this.getLookAndFeelsMap();
        for (String string : map.keySet()) {
            final String string2 = (String)map.get(string);
            boolean bl = string2.equals(UIManager.getSystemLookAndFeelClassName());
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        UIManager.setLookAndFeel(string2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    SwingUtilities.updateComponentTreeUI(ModulecoBean.this);
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            this.jMenuLookAndFeel.add(jRadioButtonMenuItem);
        }
    }

    private Map getLookAndFeelsMap() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            String string = lookAndFeelInfoArray[i].getName();
            String string2 = lookAndFeelInfoArray[i].getClassName();
            treeMap.put(string, string2);
        }
        return treeMap;
    }

    public JPanelMain getJPanelMain() {
        return this.jPanelMain;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object.equals(this.jMenuItemDockingHierarchy)) {
            this.centralControl.displayDockingHierarchy();
        } else if (object.equals(this.jMenuItemResetPerspective)) {
            this.centralControl.resetPerspective();
        } else if (object.equals(this.jMenuItemModelProperties)) {
            JFrameDebug jFrameDebug = new JFrameDebug();
            jFrameDebug.showModelProperties(this.centralControl.modulecoLauncher);
        } else if (object.equals(this.jMenuItemOpen)) {
            this.centralControl.openJFileChooserForModele();
        } else if (object.equals(this.jMenuItemNeighbourhood)) {
            this.centralControl.displayNeighbourhood();
        } else if (object.equals(this.jMenuItemRecordData)) {
            this.centralControl.showJConfigRecorder();
        } else if (object.equals(this.jMenuItemExplorer)) {
            this.centralControl.launchMadkitAgent("madkit.explorer.ExplorerLauncher");
        } else if (object.equals(this.jMenuItemOutput)) {
            this.centralControl.launchMadkitAgent("madkit.output.MadkitOutput");
        } else if (object.equals(this.jMenuItemGroupObserver)) {
            this.centralControl.launchMadkitAgent("madkit.system.GroupObserver");
        } else if ("showView".equals(string.substring(0, string.indexOf(".")))) {
            String string2 = string.substring(string.indexOf(".") + 1, string.length());
            this.centralControl.showView(string2);
        }
    }

    public void updateMenuShowView(String string, Icon icon) {
        JMenuItem jMenuItem = new JMenuItem(string, icon);
        jMenuItem.setActionCommand("showView." + string);
        jMenuItem.addActionListener(this);
        this.jMenuShowView.add(jMenuItem);
    }

    public void clearMenuShowView() {
        this.jMenuShowView.removeAll();
    }

    public void setTitle(String string) {
        Container container = SwingUtilities.getAncestorOfClass(JFrame.class, this);
        JFrame jFrame = (JFrame)container;
        jFrame.setTitle("Moduleco - " + Moduleco.getCurrentModelName());
    }
}

