/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import modulecoGUI.CentralControl;
import modulecoGUI.XMLGuiReader.XMLGuiReader;

public class JToolBarCommandes
extends JToolBar
implements ActionListener {
    private static final long serialVersionUID = -2973030260914772908L;
    CentralControl centralControl;
    List controlButtonList;

    public JToolBarCommandes(CentralControl centralControl) {
        this.centralControl = centralControl;
        this.controlButtonList = new ArrayList();
        this.build();
        this.setControlButtonEnable(false);
    }

    public void setControlButtonEnable(boolean bl) {
        Iterator iterator = this.controlButtonList.iterator();
        while (iterator.hasNext()) {
            ((AbstractButton)iterator.next()).setEnabled(bl);
        }
    }

    private void build() {
        JButton jButton = this.makeButton("Open", "open", XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonOpen"), XMLGuiReader.getAltText("JToolBarCommandes/ButtonOpen"));
        this.add(jButton);
        this.addSeparator();
        JButton jButton2 = this.makeButton("Reload", "reload", XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonReload"), XMLGuiReader.getAltText("JToolBarCommandes/ButtonReload"));
        this.controlButtonList.add(jButton2);
        this.add(jButton2);
        this.addSeparator();
        JButton jButton3 = this.makeButton("Play", "play", XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonPlay"), XMLGuiReader.getAltText("JToolBarCommandes/ButtonPlay"));
        this.controlButtonList.add(jButton3);
        this.add(jButton3);
        JButton jButton4 = this.makeButton("StepByStep", "spetbystep", XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonStepByStep"), XMLGuiReader.getAltText("JToolBarCommandes/ButtonStepByStep"));
        this.controlButtonList.add(jButton4);
        this.add(jButton4);
        JButton jButton5 = this.makeButton("Pause", "pause", XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonPause"), XMLGuiReader.getAltText("JToolBarCommandes/ButtonStepByStep"));
        this.controlButtonList.add(jButton5);
        this.add(jButton5);
        JButton jButton6 = this.makeButton("Stop", "stop", XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonStop"), XMLGuiReader.getAltText("JToolBarCommandes/ButtonStepByStep"));
        this.controlButtonList.add(jButton6);
        this.add(jButton6);
        this.addSeparator();
        JButton jButton7 = this.makeButton("Histo", "newBarChart", XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonNewBarChart"), XMLGuiReader.getAltText("JToolBarCommandes/ButtonNewBarChart"));
        this.controlButtonList.add(jButton7);
        this.add(jButton7);
        JButton jButton8 = this.makeButton("Curve", "newLineChart", XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonNewLineChart"), XMLGuiReader.getAltText("JToolBarCommandes/ButtonNewLineChart"));
        this.controlButtonList.add(jButton8);
        this.add(jButton8);
        JButton jButton9 = this.makeButton("PieChart", "newPieChart", XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonNewPieChart"), XMLGuiReader.getAltText("JToolBarCommandes/ButtonNewPieChart"));
        this.controlButtonList.add(jButton9);
        this.add(jButton9);
        this.addSeparator();
        this.add(this.makeJLabel("Timer", "GVT is 0", "The timer", "Icon Timer"));
    }

    protected JButton makeButton(String string, String string2, String string3, String string4) {
        JButton jButton = new JButton();
        jButton.setActionCommand(string2);
        jButton.setToolTipText(string3);
        jButton.addActionListener(this);
        URL uRL = this.getClass().getResource("/images/JToolBarCommandes/" + string + ".gif");
        if (uRL != null) {
            jButton.setIcon(new ImageIcon(uRL, string4));
        } else {
            jButton.setText(string4);
            System.err.println("Resource not found: /images/JToolBarCommandes/" + string + ".gif");
        }
        return jButton;
    }

    protected JLabel makeJLabel(String string, String string2, String string3, String string4) {
        URL uRL = this.getClass().getResource(string + ".gif");
        JLabel jLabel = uRL != null ? new JLabel(string2, new ImageIcon(uRL, string4), 2) : new JLabel(string2, new ImageIcon(string4), 2);
        UIManager.put("jLabelIteration", jLabel);
        return jLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("open".equals(string)) {
            this.centralControl.openJFileChooserForModele();
        } else if ("reload".equals(string)) {
            this.centralControl.reload();
        } else if ("play".equals(string)) {
            this.centralControl.simulationStart();
        } else if ("spetbystep".equals(string)) {
            this.centralControl.simulationMstep();
        } else if ("pause".equals(string)) {
            this.centralControl.simulationStop();
        } else if ("stop".equals(string)) {
            this.centralControl.simulationStop();
        } else if ("newBarChart".equals(string)) {
            this.centralControl.createChart(CentralControl.BAR_CHART);
        } else if ("newLineChart".equals(string)) {
            this.centralControl.createChart(CentralControl.LINE_CHART);
        } else if ("newPieChart".equals(string)) {
            this.centralControl.createChart(CentralControl.PIE_CHART);
        }
    }

    public void updateIter(int n) {
        JLabel jLabel = (JLabel)UIManager.get("jLabelIteration");
        jLabel.setText("GVT is " + Integer.toString(n));
        jLabel.repaint();
    }
}

