/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.utils.dataRecorder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;
import madkit.simulation.probes.ReflexiveProbe;
import modulecoFramework.Moduleco;
import modulecoFramework.simulation.scheduling.ModulecoScheduler;

public class Recorder
extends Watcher
implements ReferenceableAgent {
    private static final long serialVersionUID = -4741661027688183040L;
    public Map mapWorldProbe;
    public Map mapAgentProbe = new HashMap();
    public Map mapWorldValues;
    public Map mapAgentValues;
    public boolean writeDataInFile = true;
    public File file;
    public FileWriter fileWriter;
    public double iteration = 0.0;
    protected static String valuesSeparator = ",";
    public List recordableWorldProperties;
    public List recordedWorldProperties;
    public List notRecordedWorldProperties;
    public List recordableAgentProperties;
    public List recordedAgentProperties;
    public List notRecordedAgentProperties;
    public String filePath;
    public String directoryPath;
    public boolean headerRecorded = false;

    public Recorder() {
        this.mapWorldProbe = new HashMap();
        this.mapAgentValues = new HashMap();
        this.mapWorldValues = new HashMap();
        this.recordableWorldProperties = new ArrayList();
        this.recordedWorldProperties = new ArrayList();
        this.notRecordedWorldProperties = new ArrayList();
        this.recordableAgentProperties = new ArrayList();
        this.recordedAgentProperties = new ArrayList();
        this.notRecordedAgentProperties = new ArrayList();
        new File(System.getProperty("user.dir") + File.separator + "outputs" + File.separator).mkdir();
        this.directoryPath = System.getProperty("user.dir") + File.separator + "outputs";
        this.filePath = this.directoryPath + File.separator + Moduleco.getCurrentModelName() + ".csv";
        this.file = new File(this.filePath);
        if (this.file.exists()) {
            int n = 0;
            do {
                this.filePath = this.directoryPath + File.separator + Moduleco.getCurrentModelName() + "_" + n + ".csv";
                this.file = new File(this.filePath);
                ++n;
            } while (this.file.exists());
        }
    }

    public void activate() {
        this.requestRole("moduleco", "WatcherGroup", "WatcherRole", null);
        this.recordableWorldProperties = this.findRecordableWorldProperties();
        Iterator iterator = this.recordableWorldProperties.iterator();
        while (iterator.hasNext()) {
            this.notRecordedWorldProperties.add((String)iterator.next());
        }
        this.recordableAgentProperties = this.findRecordableAgentProperties();
        iterator = this.recordableAgentProperties.iterator();
        while (iterator.hasNext()) {
            this.notRecordedAgentProperties.add((String)iterator.next());
        }
    }

    public List findRecordableProperties(String string, String string2, String string3) {
        Probe probe = new Probe(string, string2, string3);
        this.addProbe(probe);
        ListIterator listIterator = probe.getAgentsIterator();
        ArrayList<String> arrayList = null;
        if (listIterator.hasNext()) {
            Object e = listIterator.next();
            String[] stringArray = new String[]{};
            try {
                stringArray = (String[])e.getClass().getField("outputParameters").get(e);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            arrayList = new ArrayList<String>();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
            }
        }
        this.removeProbe(probe);
        return arrayList;
    }

    public List findRecordableAgentProperties() {
        String string = "moduleco";
        String string2 = "ecoAgent";
        String string3 = "basicAgent";
        return this.findRecordableProperties(string, string2, string3);
    }

    public List findRecordableWorldProperties() {
        String string = "moduleco";
        String string2 = "ecoAgent";
        String string3 = "environment";
        return this.findRecordableProperties(string, string2, string3);
    }

    public String[] getRecordedAgentProperies() {
        String[] stringArray = new String[this.recordedAgentProperties.size()];
        int n = 0;
        Iterator iterator = this.recordedAgentProperties.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public String[] getNotRecordedAgentProperies() {
        String[] stringArray = new String[this.notRecordedAgentProperties.size()];
        int n = 0;
        Iterator iterator = this.notRecordedAgentProperties.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public String[] getRecordedWorldProperies() {
        String[] stringArray = new String[this.recordedWorldProperties.size()];
        int n = 0;
        Iterator iterator = this.recordedWorldProperties.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public String[] getNotRecordedWorldProperies() {
        String[] stringArray = new String[this.notRecordedWorldProperties.size()];
        int n = 0;
        Iterator iterator = this.notRecordedWorldProperties.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public void recordAgentProperty(String string) {
        ReflexiveProbe reflexiveProbe = new ReflexiveProbe("moduleco", "ecoAgent", "basicAgent", string);
        this.addProbe((Probe)reflexiveProbe);
        this.mapAgentProbe.put(string, reflexiveProbe);
        this.notRecordedAgentProperties.remove(string);
        this.recordedAgentProperties.add(string);
    }

    public void eraseAgentProperty(String string) {
        ReflexiveProbe reflexiveProbe = (ReflexiveProbe)this.mapAgentProbe.get(string);
        this.removeProbe((Probe)reflexiveProbe);
        this.mapAgentProbe.remove(string);
        this.mapAgentValues.remove(string);
        this.recordedAgentProperties.remove(string);
        this.notRecordedAgentProperties.add(string);
    }

    public void recordWorldProperty(String string) {
        ReflexiveProbe reflexiveProbe = new ReflexiveProbe("moduleco", "ecoAgent", "environment", string);
        this.addProbe((Probe)reflexiveProbe);
        this.mapWorldProbe.put(string, reflexiveProbe);
        this.notRecordedWorldProperties.remove(string);
        this.recordedWorldProperties.add(string);
    }

    public void eraseWorldProperty(String string) {
        ReflexiveProbe reflexiveProbe = (ReflexiveProbe)this.mapWorldProbe.get(string);
        this.removeProbe((Probe)reflexiveProbe);
        this.mapWorldProbe.remove(string);
        this.mapWorldValues.remove(string);
        this.recordedWorldProperties.remove(string);
        this.notRecordedWorldProperties.add(string);
    }

    public File getFile() {
        return this.file;
    }

    public void setFilePath(String string) {
        if (!string.equals(this.filePath)) {
            this.filePath = string;
            this.file = new File(this.filePath);
            this.headerRecorded = false;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void observeAgents() {
        this.iteration = ModulecoScheduler.getGVT();
        this.observeNewWorldValue();
        this.observeNewAgentValue();
        this.record();
    }

    private void observeNewWorldValue() {
        for (String string : this.mapWorldProbe.keySet()) {
            ReflexiveProbe reflexiveProbe = (ReflexiveProbe)this.mapWorldProbe.get(string);
            Vector vector = (Vector)this.mapWorldValues.get(string);
            if (vector == null) {
                vector = new Vector();
                this.mapWorldValues.put(string, vector);
            }
            Vector<Object> vector2 = new Vector<Object>();
            ListIterator listIterator = reflexiveProbe.getAgentsIterator();
            while (listIterator.hasNext()) {
                vector2.add(reflexiveProbe.getObject(listIterator.next()));
            }
            vector.add(vector2);
        }
    }

    private void observeNewAgentValue() {
        for (String string : this.mapAgentProbe.keySet()) {
            ReflexiveProbe reflexiveProbe = (ReflexiveProbe)this.mapAgentProbe.get(string);
            Vector vector = (Vector)this.mapAgentValues.get(string);
            if (vector == null) {
                vector = new Vector();
                this.mapAgentValues.put(string, vector);
            }
            Vector<Object> vector2 = new Vector<Object>();
            ListIterator listIterator = reflexiveProbe.getAgentsIterator();
            while (listIterator.hasNext()) {
                vector2.add(reflexiveProbe.getObject(listIterator.next()));
            }
            vector.add(vector2);
        }
    }

    public void recordAllWorldProperty() {
        String string = "moduleco";
        String string2 = "ecoAgent";
        String string3 = "environment";
        Probe probe = new Probe(string, string2, string3);
        this.addProbe(probe);
        ListIterator listIterator = probe.getAgentsIterator();
        if (listIterator.hasNext()) {
            Object e = listIterator.next();
            String[] stringArray = new String[]{};
            try {
                stringArray = (String[])e.getClass().getField("outputParameters").get(e);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    ReflexiveProbe reflexiveProbe = new ReflexiveProbe(string, string2, string3, stringArray[i]);
                    this.addProbe((Probe)reflexiveProbe);
                    this.mapWorldProbe.put(stringArray[i], reflexiveProbe);
                    this.notRecordedWorldProperties.remove(stringArray[i]);
                    this.recordedWorldProperties.add(stringArray[i]);
                }
            }
        }
        this.removeProbe(probe);
    }

    public void recordAllAgentProperty() {
        String string = "moduleco";
        String string2 = "ecoAgent";
        String string3 = "basicAgent";
        Probe probe = new Probe(string, string2, string3);
        this.addProbe(probe);
        ListIterator listIterator = probe.getAgentsIterator();
        if (listIterator.hasNext()) {
            Object e = listIterator.next();
            String[] stringArray = new String[]{};
            try {
                stringArray = (String[])e.getClass().getField("outputParameters").get(e);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    ReflexiveProbe reflexiveProbe = new ReflexiveProbe(string, string2, string3, stringArray[i]);
                    this.addProbe((Probe)reflexiveProbe);
                    this.mapAgentProbe.put(stringArray[i], reflexiveProbe);
                    this.notRecordedAgentProperties.remove(stringArray[i]);
                    this.recordedAgentProperties.add(stringArray[i]);
                }
            }
        }
        this.removeProbe(probe);
    }

    public void record() {
        if (this.writeDataInFile) {
            String string;
            Object e;
            Vector vector;
            if (!this.headerRecorded) {
                this.file = new File(this.filePath);
                try {
                    this.fileWriter = new FileWriter(this.file);
                    this.recordHeader(this.fileWriter);
                    this.fileWriter.close();
                    this.headerRecorded = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            try {
                this.fileWriter = new FileWriter(this.file, true);
                this.fileWriter.write("\n");
                this.fileWriter.write("" + this.iteration);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            for (Object k : this.mapWorldValues.keySet()) {
                vector = (Vector)((Vector)this.mapWorldValues.get(k)).lastElement();
                try {
                    for (int i = 0; i < vector.size(); ++i) {
                        try {
                            e = vector.get(i);
                            string = e.toString();
                            if (!Number.class.isAssignableFrom(e.getClass()) && string.contains(";")) {
                                string = "\"".concat(string.concat("\""));
                            }
                            this.fileWriter.write(valuesSeparator + string);
                            continue;
                        }
                        catch (Exception exception) {
                            this.fileWriter.write(valuesSeparator);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            for (Object k : this.mapAgentValues.keySet()) {
                vector = (Vector)((Vector)this.mapAgentValues.get(k)).lastElement();
                try {
                    for (int i = 0; i < vector.size(); ++i) {
                        try {
                            e = vector.get(i);
                            string = e.toString();
                            if (!Number.class.isAssignableFrom(e.getClass()) && string.contains(";")) {
                                string = "\"".concat(string.concat("\""));
                            }
                            this.fileWriter.write(valuesSeparator + string);
                            continue;
                        }
                        catch (Exception exception) {
                            this.fileWriter.write(valuesSeparator);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void recordHeader(FileWriter fileWriter) {
        try {
            AbstractAgent abstractAgent;
            ListIterator listIterator;
            Probe probe;
            fileWriter.write("T");
            for (Object k : this.mapWorldProbe.keySet()) {
                probe = (Probe)this.mapWorldProbe.get(k);
                listIterator = probe.getAgentsIterator();
                while (listIterator.hasNext()) {
                    abstractAgent = (AbstractAgent)listIterator.next();
                    fileWriter.write(valuesSeparator + abstractAgent.getName());
                }
            }
            for (Object k : this.mapAgentProbe.keySet()) {
                probe = (Probe)this.mapAgentProbe.get(k);
                listIterator = probe.getAgentsIterator();
                while (listIterator.hasNext()) {
                    abstractAgent = (AbstractAgent)listIterator.next();
                    fileWriter.write(valuesSeparator + abstractAgent.getName());
                }
            }
            fileWriter.write("\n");
            fileWriter.write("T");
            for (Object k : this.mapWorldProbe.keySet()) {
                fileWriter.write(valuesSeparator + k);
                probe = (Probe)this.mapWorldProbe.get(k);
                listIterator = probe.getAgentsIterator();
                listIterator.next();
                while (listIterator.hasNext()) {
                    fileWriter.write(valuesSeparator);
                    listIterator.next();
                }
            }
            for (Object k : this.mapAgentProbe.keySet()) {
                fileWriter.write(valuesSeparator + k);
                probe = (Probe)this.mapAgentProbe.get(k);
                listIterator = probe.getAgentsIterator();
                listIterator.next();
                while (listIterator.hasNext()) {
                    fileWriter.write(valuesSeparator);
                    listIterator.next();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

