/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.utils;

import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import modulecoFramework.modeleco.EWorld;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModelWriter {
    EWorld world;

    public ModelWriter(EWorld eWorld) {
        this.world = eWorld;
    }

    public void record(File file) {
        System.out.println("ModelWriter.java : Recording parameters in File : " + file.getAbsolutePath());
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement("model");
            element.setAttribute("name", this.world.getModelParameters().getName());
            element.setAttribute("length", String.valueOf(this.world.getModelParameters().getLength()));
            element.setAttribute("neighbourhood", this.world.getModelParameters().getNeighbourhood());
            element.setAttribute("zone", this.world.getModelParameters().getZone());
            Element element2 = document.createElement("scheduling");
            Element element3 = document.createElement("role");
            element3.setAttribute("name", "basicAgent");
            element3.setAttribute("activationType", this.world.getModelParameters().getTimeScheduler());
            element3.setAttribute("activationOrder", "1");
            element2.appendChild(element3);
            element.appendChild(element2);
            Element element4 = document.createElement("world");
            this.recordAdditionalObject(document, element4, this.world);
            element.appendChild(element4);
            document.appendChild(element);
            this.transformerXmlToFile(document, file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public void recordAdditionalObject(Document document, Element element, Object object) {
        try {
            Field field = object.getClass().getField("inputParameters");
            String[] stringArray = (String[])field.get(object);
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = document.createElement(stringArray[i]);
                Object object2 = object.getClass().getField(stringArray[i]).get(object);
                try {
                    HashMap hashMap = (HashMap)object.getClass().getField("hashMapChoiceString").get(object);
                    HashMap hashMap2 = (HashMap)object.getClass().getField("hashMapChoiceValue").get(object);
                    Object[] objectArray = (Object[])hashMap.get(stringArray[i]);
                    Object[] objectArray2 = (Object[])hashMap2.get(stringArray[i]);
                    if (objectArray != null && objectArray2 != null) {
                        for (int j = 0; j < objectArray2.length; ++j) {
                            if (!objectArray2[j].equals(object2)) continue;
                            element2.setAttribute("value", objectArray[j].toString());
                            try {
                                Field field2 = objectArray2[j].getClass().getField("inputParameters");
                                if (field2 == null) continue;
                                this.recordAdditionalObject(document, element2, object2);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    } else {
                        element2.setAttribute("value", object2.toString());
                    }
                }
                catch (Exception exception) {
                    element2.setAttribute("value", object2.toString());
                }
                element.appendChild(element2);
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public void transformerXmlToFile(Document document, File file) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file.getAbsoluteFile());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void transformerXml(Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(string);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

