/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.utils;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.modeleco.ModelParameters;
import modulecoGUI.cAgentEditor.BeanInfoFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModelReader {
    EWorld world;

    public ModelReader(EWorld eWorld) {
        this.world = eWorld;
    }

    public void read(File file) {
        System.out.println("ModelReader.java : Loading parameters from File : " + file.getAbsolutePath());
        Document document = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ModelReader : FileNotFoundException");
        }
        catch (SAXException sAXException) {
            System.out.println("ModelReader : SAXException");
        }
        catch (IOException iOException) {
            System.out.println("ModelReader : IOException");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("ModelReader : ParserConfigurationException");
        }
        Element element = document.getDocumentElement();
        ModelParameters modelParameters = this.world.getModelParameters();
        if (modelParameters == null) {
            modelParameters = new ModelParameters("");
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            if (namedNodeMap.item(i).getNodeName().equals("name")) {
                modelParameters.setName(namedNodeMap.item(i).getNodeValue());
                continue;
            }
            if (namedNodeMap.item(i).getNodeName().equals("length")) {
                modelParameters.setLength(Integer.parseInt(namedNodeMap.item(i).getNodeValue()));
                continue;
            }
            if (namedNodeMap.item(i).getNodeName().equals("neighbourhood")) {
                modelParameters.setNeighbourhood(namedNodeMap.item(i).getNodeValue());
                continue;
            }
            if (!namedNodeMap.item(i).getNodeName().equals("zone")) continue;
            modelParameters.setZone(namedNodeMap.item(i).getNodeValue());
        }
        NodeList nodeList = element.getElementsByTagName("scheduling");
        Element element2 = (Element)nodeList.item(0);
        NamedNodeMap namedNodeMap2 = element2.getElementsByTagName("role").item(0).getAttributes();
        modelParameters.setTimeScheduler(namedNodeMap2.getNamedItem("activationType").getNodeValue());
        this.world.setModelParameters(modelParameters);
        NodeList nodeList2 = element.getElementsByTagName("world");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            this.readObject((Element)nodeList2.item(i), this.world);
        }
    }

    private void readObject(Element element, Object object) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        String[] stringArray = new String[]{};
        try {
            stringArray = (String[])object.getClass().getField("inputParameters").get(object);
            hashMap = (HashMap)object.getClass().getField("hashMapChoiceString").get(object);
            hashMap2 = (HashMap)object.getClass().getField("hashMapChoiceValue").get(object);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        BeanInfo beanInfo = BeanInfoFactory.getBeanInfo(object);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        HashMap<String, PropertyDescriptor> hashMap3 = new HashMap<String, PropertyDescriptor>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            hashMap3.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
        }
        NodeList nodeList = element.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getParentNode().equals(element)) continue;
            try {
                Object object2;
                PropertyDescriptor propertyDescriptor;
                Object object3;
                Field field = object.getClass().getField(element2.getTagName());
                String[] stringArray2 = (String[])hashMap.get(element2.getTagName());
                if (stringArray2 != null) {
                    for (int j = 0; j < stringArray2.length; ++j) {
                        if (!stringArray2[j].equals(element2.getAttribute("value"))) continue;
                        object3 = (Object[])hashMap2.get(element2.getTagName());
                        propertyDescriptor = (PropertyDescriptor)hashMap3.get(element2.getTagName());
                        if (propertyDescriptor != null) {
                            object2 = propertyDescriptor.getWriteMethod();
                            if (object2 != null) {
                                ((Method)object2).invoke(object, object3[j]);
                            } else {
                                field.set(object, object3[j]);
                            }
                        } else {
                            field.set(object, object3[j]);
                        }
                        try {
                            object2 = object3[j].getClass().getField("inputParameters");
                            if (object2 == null) continue;
                            this.readObject(element2, field.get(object));
                            continue;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                Class<?> clazz = field.getType();
                if (clazz.isPrimitive()) {
                    object3 = null;
                    if (clazz.equals(Double.TYPE)) {
                        object3 = new Double(element2.getAttribute("value"));
                    } else if (clazz.equals(Integer.TYPE)) {
                        object3 = new Integer(element2.getAttribute("value"));
                    } else if (clazz.equals(Boolean.TYPE)) {
                        object3 = new Boolean(element2.getAttribute("value"));
                    } else if (clazz.equals(Float.TYPE)) {
                        object3 = new Float(element2.getAttribute("value"));
                    } else if (clazz.equals(Long.TYPE)) {
                        object3 = new Long(element2.getAttribute("value"));
                    }
                    propertyDescriptor = (PropertyDescriptor)hashMap3.get(element2.getTagName());
                    if (propertyDescriptor != null) {
                        object2 = propertyDescriptor.getWriteMethod();
                        if (object2 != null) {
                            ((Method)object2).invoke(object, object3);
                            continue;
                        }
                        field.set(object, object3);
                        continue;
                    }
                    field.set(object, object3);
                    continue;
                }
                object3 = field.getType().getConstructor(String.class);
                if (object3 == null) continue;
                propertyDescriptor = object3.newInstance(element2.getAttribute("value"));
                object2 = (PropertyDescriptor)hashMap3.get(element2.getTagName());
                if (object2 != null) {
                    Method method = ((PropertyDescriptor)object2).getWriteMethod();
                    if (method != null) {
                        method.invoke(object, field.getType().cast(propertyDescriptor));
                        continue;
                    }
                    field.set(object, field.getType().cast(propertyDescriptor));
                    continue;
                }
                field.set(object, field.getType().cast(propertyDescriptor));
                continue;
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                continue;
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }
}

