/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.abstractModels;

import modulecoFramework.abstractModels.EWorldGame;
import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.EAgent;

public abstract class EAgentGame
extends EAgent {
    public boolean newStrategy;
    public boolean oldStrategy;
    public boolean nextStrategy;
    protected String revisionRuleIndex;
    protected boolean hasChanged;
    protected int[][] payoffMatrix;
    protected int payoff = 0;

    public EAgentGame() {
        this.inputParameters = new String[]{"newStrategy", "oldStrategy"};
    }

    public void init() {
        EWorldGame eWorldGame = (EWorldGame)this.world;
        this.revisionRuleIndex = eWorldGame.getRevisionRuleIndex();
        this.payoffMatrix = new int[2][2];
        this.payoffMatrix[0][0] = eWorldGame.getS1AgainstS1();
        this.payoffMatrix[1][0] = eWorldGame.getS2AgainstS1();
        this.payoffMatrix[0][1] = eWorldGame.getS1AgainstS2();
        this.payoffMatrix[1][1] = eWorldGame.getS2AgainstS2();
        this.nextStrategy = this.newStrategy = this.oldStrategy;
        this.neighbours = ((NeighbourMedium)this.mediums[0]).getNeighbours();
    }

    public void computeBestReply() {
        this.neighbours = ((NeighbourMedium)this.mediums[0]).getNeighbours();
        int n = 0;
        int n2 = 0;
        for (EAgentGame eAgentGame : this.neighbours) {
            if (eAgentGame.newStrategy) {
                n += this.payoffMatrix[0][0];
                n2 += this.payoffMatrix[1][0];
                continue;
            }
            n += this.payoffMatrix[0][1];
            n2 += this.payoffMatrix[1][1];
        }
        this.nextStrategy = false;
        if (n > n2) {
            this.nextStrategy = true;
        }
        if (n == n2) {
            this.nextStrategy = this.newStrategy;
        }
    }

    public void ComputeBestPayoff(int n) {
        int n2 = n;
        for (EAgentGame eAgentGame : this.neighbours) {
            if (n2 >= eAgentGame.payoff) continue;
            this.nextStrategy = eAgentGame.oldStrategy;
            n2 = eAgentGame.payoff;
        }
        this.newStrategy = this.nextStrategy;
    }

    public void ComputeBestAveragePayoff(int n) {
        double d;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (EAgentGame eAgentGame : this.neighbours) {
            if (eAgentGame.oldStrategy) {
                ++n2;
                n4 += eAgentGame.payoff;
                continue;
            }
            ++n3;
            n5 += eAgentGame.payoff;
        }
        double d2 = n2 == 0 ? 0.0 : (double)(n4 / n2);
        if (d2 > (d = n3 == 0 ? 0.0 : (double)(n5 / n3))) {
            this.nextStrategy = true;
        }
        if (d > d2) {
            this.nextStrategy = false;
        }
        if (d2 == d) {
            this.nextStrategy = this.oldStrategy;
        }
        this.newStrategy = this.nextStrategy;
    }

    public Boolean hasChanged() {
        boolean bl = this.hasChanged;
        this.hasChanged = false;
        return new Boolean(bl);
    }

    public Object getState() {
        return new Boolean(this.newStrategy);
    }

    public void setNewStrategy(boolean bl) {
        this.newStrategy = bl;
        System.out.println("gant : " + this.agentID + " inverseState()");
    }

    public void setOldStrategy(boolean bl) {
        this.oldStrategy = bl;
    }

    public boolean getNewStrategy() {
        return this.newStrategy;
    }

    public boolean getOldStrategy() {
        return this.oldStrategy;
    }
}

