/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import madkit.boot.Madkit;

public class Moduleco {
    public static final String COMMUNITY = "moduleco";
    public static final String MODEL_GROUP = "model";
    public static final String AGENTS_GROUP = "ecoAgent";
    public static final String ENVIRONMENT_ROLE = "environment";
    public static final String ENGINE_GROUP = "engine";
    private static String currentModelName = "No Model Selected";

    public static String getCurrentModelName() {
        return currentModelName;
    }

    public static void setCurrentModelName(String string) {
        currentModelName = string;
    }

    public static List getModelsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = new File(Madkit.libDirectory).listFiles();
        block3: for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".jar")) continue;
            try {
                Enumeration<JarEntry> enumeration = new JarFile(fileArray[i]).entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (!zipEntry.getName().endsWith(".modulecoModel")) continue;
                    arrayList.add(fileArray[i].getName().replaceFirst(".jar", ""));
                    continue block3;
                }
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Error: bad jar file " + fileArray[i]);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Error: not a jar file " + fileArray[i]);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static Class getClass(String string) throws ClassNotFoundException {
        return Madkit.getClassLoader().loadClass(string);
    }

    public static File getParametersFile() {
        String string = System.getProperty("user.dir");
        if (new File(string + File.separator + "models" + File.separator + currentModelName).exists()) {
            return new File(string + File.separator + "models" + File.separator + currentModelName + File.separator + currentModelName + ".parameters");
        }
        return new File(string + File.separator + "plugins" + File.separator + COMMUNITY + File.separator + "models" + File.separator + currentModelName + File.separator + currentModelName + ".parameters");
    }

    public static InputStream getModelHelperInputStream() {
        File file = new File(Madkit.libDirectory + File.separator + currentModelName + ".jar");
        InputStream inputStream = null;
        try {
            JarFile jarFile = new JarFile(file);
            ZipEntry zipEntry = jarFile.getEntry(currentModelName + ".xml");
            if (zipEntry != null) {
                inputStream = jarFile.getInputStream(zipEntry);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return inputStream;
    }
}

