/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Polygon;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.shaped.border.RoundedCornerBorder;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class TwoColoredLineBorder
extends RoundedCornerBorder {
    private static final long serialVersionUID = 1L;
    private ColorProvider topLeftColor;
    private ColorProvider bottomRightColor;
    private boolean roundCorners;
    private boolean open;

    public TwoColoredLineBorder(ColorProvider colorProvider, ColorProvider colorProvider2, boolean bl, boolean bl2) {
        super(colorProvider, null, bl ? 2 : 0, bl ? 2 : 0, bl && !bl2 ? 2 : 0, bl && !bl2 ? 2 : 0, true, true, !bl2, true);
        this.topLeftColor = colorProvider;
        this.bottomRightColor = colorProvider2;
        this.roundCorners = bl;
        this.open = bl2;
    }

    protected void paintPolygon(Component component, Graphics2D graphics2D, Polygon polygon, int n, int n2) {
        TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanel(component);
        if (tabbedPanel != null) {
            int n3;
            Direction direction = tabbedPanel.getProperties().getTabAreaOrientation();
            Color color = this.topLeftColor.getColor();
            Color color2 = this.bottomRightColor.getColor();
            if (direction == Direction.UP) {
                graphics2D.setColor(color);
                for (n3 = 0; n3 < (this.roundCorners ? 3 : 1); ++n3) {
                    graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[n3 + 1], polygon.ypoints[n3 + 1]);
                }
                graphics2D.setColor(color2);
                while (n3 < polygon.npoints - 1) {
                    graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[n3 + 1], polygon.ypoints[n3 + 1]);
                    ++n3;
                }
                graphics2D.setColor(color);
                graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[0], polygon.ypoints[0]);
            } else if (direction == Direction.RIGHT) {
                graphics2D.setColor(color2);
                while (n3 < polygon.npoints - (this.open ? 2 : (this.roundCorners ? 3 : 2))) {
                    graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[n3 + 1], polygon.ypoints[n3 + 1]);
                    ++n3;
                }
                graphics2D.setColor(color);
                for (int i = n3 - 1; i < polygon.npoints - 2; ++i) {
                    graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[n3 + 1], polygon.ypoints[n3 + 1]);
                    ++n3;
                }
                graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[0], polygon.ypoints[0]);
            } else if (direction == Direction.DOWN) {
                graphics2D.setColor(color2);
                while (n3 < (this.roundCorners ? 5 : 1)) {
                    graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[n3 + 1], polygon.ypoints[n3 + 1]);
                    ++n3;
                }
                graphics2D.setColor(color);
                while (n3 < polygon.npoints - 1) {
                    graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[n3 + 1], polygon.ypoints[n3 + 1]);
                    ++n3;
                }
                graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[0], polygon.ypoints[0]);
            } else {
                graphics2D.setColor(color);
                while (n3 < (this.roundCorners ? 3 : 1)) {
                    graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[n3 + 1], polygon.ypoints[n3 + 1]);
                    ++n3;
                }
                graphics2D.setColor(color2);
                while (n3 < polygon.npoints - 1) {
                    graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[n3 + 1], polygon.ypoints[n3 + 1]);
                    ++n3;
                }
                graphics2D.setColor(color);
                graphics2D.drawLine(polygon.xpoints[n3], polygon.ypoints[n3], polygon.xpoints[0], polygon.ypoints[0]);
            }
        }
    }
}

