/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class TabHighlightBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider color;
    private boolean openBorder;

    public TabHighlightBorder() {
        this((Color)null, false);
    }

    public TabHighlightBorder(Color color, boolean bl) {
        this(ColorProviderUtil.getColorProvider(color, UIManagerColorProvider.TABBED_PANE_HIGHLIGHT), bl);
    }

    public TabHighlightBorder(ColorProvider colorProvider, boolean bl) {
        this.color = colorProvider;
        this.openBorder = bl;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanel(component);
        if (tabbedPanel != null) {
            Direction direction = tabbedPanel.getProperties().getTabAreaOrientation();
            graphics.setColor(this.color.getColor(component));
            if (direction == Direction.UP) {
                graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
                graphics.drawLine(n, n2, n, n2 + n4 - (this.openBorder ? 1 : 2));
            } else if (direction == Direction.LEFT) {
                graphics.drawLine(n + 1, n2, n + n3 - (this.openBorder ? 1 : 2), n2);
                graphics.drawLine(n, n2, n, n2 + n4 - 2);
            } else if (direction == Direction.DOWN) {
                if (!this.openBorder) {
                    graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
                }
                graphics.drawLine(n, n2, n, n2 + n4 - 2);
            } else if (this.openBorder) {
                graphics.drawLine(n, n2, n + n3 - 2, n2);
            } else {
                graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
                graphics.drawLine(n, n2, n, n2 + n4 - 2);
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(1, 1, 0, 0);
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

