/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.DimensionUtil;
import net.infonode.gui.EventUtil;
import net.infonode.gui.ScrollButtonBox;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.SolidColorComponentPainter;
import net.infonode.gui.draggable.DraggableComponent;
import net.infonode.gui.draggable.DraggableComponentBox;
import net.infonode.gui.draggable.DraggableComponentBoxEvent;
import net.infonode.gui.draggable.DraggableComponentBoxListener;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.panel.HoverableShapedPanel;
import net.infonode.gui.layout.DirectionLayout;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.gui.util.ButtonProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAreaComponentsProperties;
import net.infonode.tabbedpanel.TabAreaProperties;
import net.infonode.tabbedpanel.TabContentPanel;
import net.infonode.tabbedpanel.TabDepthOrderPolicy;
import net.infonode.tabbedpanel.TabDragEvent;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicy;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabLayoutPolicy;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabSelectTrigger;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanelButtonProperties;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUIDefaults;
import net.infonode.tabbedpanel.internal.ShadowPainter;
import net.infonode.tabbedpanel.internal.TabDropDownList;
import net.infonode.tabbedpanel.internal.TabbedHoverUtil;
import net.infonode.util.Direction;
import net.infonode.util.ValueChange;

public class TabbedPanel
extends JPanel {
    private static boolean hoverActivated = false;
    private int shadowSize = 4;
    private TabDropDownList dropDownList;
    private JComponent contentPanel;
    private JComponent[] tabAreaComponents;
    private Direction tabAreaOrientation;
    private TabDropDownListVisiblePolicy listVisiblePolicy = TabDropDownListVisiblePolicy.NEVER;
    private TabLayoutPolicy listTabLayoutPolicy = TabLayoutPolicy.SCROLLING;
    private DraggableComponentBox draggableComponentBox = new DraggableComponentBox(TabbedUIDefaults.getButtonIconSize(), false);
    private ArrayList listeners;
    private ArrayList tabs = new ArrayList(4);
    private TabbedPanelProperties properties = new TabbedPanelProperties(TabbedPanelProperties.getDefaultProperties());
    private Tab highlightedTab;
    private boolean settingHighlighted;
    private boolean mouseEntered = false;
    private boolean removingSelected = false;
    private ShadowPanel componentsPanel = new ShadowPanel();
    private ScrollButtonBox scrollButtonBox;
    private GridBagConstraints constraints = new GridBagConstraints();
    private GridBagLayout tabAreaLayoutManager = new GridBagLayout(){
        private int size;
        private int outerSize;

        public void layoutContainer(Container container) {
            TabbedPanel.this.setScrollButtonsVisible();
            super.layoutContainer(container);
            if (TabbedPanel.this.contentPanel != null) {
                int n;
                int n2 = TabbedPanel.this.tabAreaOrientation == Direction.UP || TabbedPanel.this.tabAreaOrientation == Direction.DOWN ? TabbedPanel.this.draggableComponentBox.getWidth() : TabbedPanel.this.draggableComponentBox.getHeight();
                int n3 = n = TabbedPanel.this.tabAreaOrientation == Direction.UP || TabbedPanel.this.tabAreaOrientation == Direction.DOWN ? TabbedPanel.this.tabAreaContainer.getWidth() : TabbedPanel.this.tabAreaContainer.getHeight();
                if (n == this.outerSize && n2 != this.size) {
                    this.size = n2;
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            TabbedPanel.access$200(1.access$600(this.this$1)).repaint();
                        }
                    });
                }
                this.outerSize = n;
            }
            TabbedPanel.this.updateShadow();
        }

        static /* synthetic */ TabbedPanel access$600(1 var0) {
            return var0.TabbedPanel.this;
        }
    };
    private HoverableShapedPanel tabAreaContainer = new HoverablePanel(this.tabAreaLayoutManager, this.properties.getTabAreaProperties().getHoverListener()){

        public Dimension getPreferredSize() {
            if (TabbedPanel.this.getTabCount() == 0) {
                return super.getPreferredSize();
            }
            boolean bl = TabbedPanel.this.tabAreaOrientation == Direction.RIGHT || TabbedPanel.this.tabAreaOrientation == Direction.LEFT;
            Dimension dimension = DimensionUtil.add(TabbedPanel.this.draggableComponentBox.getPreferredSize(), TabbedPanel.this.tabAreaContainer.getInsets());
            if (TabbedPanel.this.tabAreaComponentsPanel.isVisible() && !ComponentUtil.isOnlyVisibleComponent(TabbedPanel.this.scrollButtonBox)) {
                Dimension dimension2 = new Dimension(0, 0);
                Component[] componentArray = TabbedPanel.this.tabAreaComponentsPanel.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (componentArray[i] == TabbedPanel.this.scrollButtonBox) continue;
                    dimension = DimensionUtil.add(dimension, componentArray[i].getPreferredSize(), !bl);
                }
                Dimension dimension3 = TabbedPanel.this.tabAreaComponentsPanel.getPreferredSize();
                dimension = new Dimension(bl ? Math.max(dimension.width, dimension2.width) : dimension.width, bl ? dimension.height : Math.max(dimension.height, dimension3.height));
            }
            return dimension;
        }
    };
    private HoverableShapedPanel tabAreaComponentsPanel = new HoverablePanel(new DirectionLayout(), this.properties.getTabAreaComponentsProperties().getHoverListener()){

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (TabbedPanel.this.getTabCount() == 0) {
                return super.getPreferredSize();
            }
            Dimension dimension = super.getPreferredSize();
            boolean bl = TabbedPanel.this.tabAreaOrientation == Direction.RIGHT || TabbedPanel.this.tabAreaOrientation == Direction.LEFT;
            Insets insets = this.getInsets();
            int n = bl ? ComponentUtil.getPreferredMaxWidth(this.getComponents()) + insets.left + insets.right : ComponentUtil.getPreferredMaxHeight(this.getComponents()) + insets.top + insets.bottom;
            return new Dimension(bl ? n : (int)dimension.getWidth(), bl ? (int)dimension.getHeight() : n);
        }

        public boolean isVisible() {
            return ComponentUtil.hasVisibleChildren(this);
        }
    };
    private DraggableComponentBoxListener draggableComponentBoxListener = new DraggableComponentBoxListener(){
        private boolean selectedMoved;

        public void componentSelected(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            if (draggableComponentBoxEvent.getDraggableComponent() == draggableComponentBoxEvent.getOldDraggableComponent()) {
                if (!this.selectedMoved && TabbedPanel.this.properties.getTabDeselectable()) {
                    TabbedPanel.this.draggableComponentBox.selectDraggableComponent(null);
                }
            } else {
                Tab tab = TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent());
                TabbedPanel.this.setHighlightedTab(tab);
                Tab tab2 = TabbedPanel.this.findTab(draggableComponentBoxEvent.getOldDraggableComponent());
                TabbedPanel.this.fireSelectedEvent(tab, tab2);
                if (TabbedPanel.this.removingSelected) {
                    TabbedPanel.this.removingSelected = false;
                    if (tab2 != null) {
                        tab2.setTabbedPanel(null);
                    }
                }
            }
        }

        public void componentRemoved(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            Tab tab = TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent());
            TabbedPanel.this.tabs.remove(tab);
            if (TabbedPanel.this.highlightedTab == tab) {
                TabbedPanel.this.highlightedTab = null;
            }
            TabbedPanel.this.setScrollButtonsVisible();
            TabbedPanel.this.revalidate();
            TabbedPanel.this.repaint();
            TabbedPanel.this.fireRemovedEvent(tab);
        }

        public void componentAdded(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            TabbedPanel.this.revalidate();
            TabbedPanel.this.repaint();
            TabbedPanel.this.fireAddedEvent(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
        }

        public void componentDragged(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            TabbedPanel.this.fireDraggedEvent(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()), draggableComponentBoxEvent.getDraggableComponentEvent().getMouseEvent());
        }

        public void componentDropped(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            if (!TabbedPanel.this.draggableComponentBox.contains(draggableComponentBoxEvent.getDraggableComponentBoxPoint())) {
                TabbedPanel.this.setHighlightedTab(TabbedPanel.this.findTab(TabbedPanel.this.draggableComponentBox.getSelectedDraggableComponent()));
            }
            TabbedPanel.this.fireDroppedEvent(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()), draggableComponentBoxEvent.getDraggableComponentEvent().getMouseEvent());
        }

        public void componentDragAborted(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            TabbedPanel.this.fireNotDroppedEvent(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
        }

        public void changed(DraggableComponentBoxEvent draggableComponentBoxEvent) {
            if (draggableComponentBoxEvent.getDraggableComponentEvent() != null) {
                int n = draggableComponentBoxEvent.getDraggableComponentEvent().getType();
                if (n == 1 && TabbedPanel.this.properties.getHighlightPressedTab()) {
                    if (TabbedPanel.this.highlightedTab != null) {
                        TabbedPanel.this.setHighlightedTab(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
                    }
                } else if (n == 2) {
                    this.selectedMoved = false;
                    TabbedPanel.this.setHighlightedTab(TabbedPanel.this.getSelectedTab());
                } else if (n == 4 && TabbedPanel.this.highlightedTab != null && TabbedPanel.this.highlightedTab.getDraggableComponent() == draggableComponentBoxEvent.getDraggableComponent()) {
                    TabbedPanel.this.setHighlightedTab(null);
                } else if (n == 3 && TabbedPanel.this.draggableComponentBox.getSelectedDraggableComponent() == draggableComponentBoxEvent.getDraggableComponent()) {
                    TabbedPanel.this.setHighlightedTab(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
                } else if (n == 0) {
                    this.selectedMoved = draggableComponentBoxEvent.getDraggableComponent() == TabbedPanel.this.draggableComponentBox.getSelectedDraggableComponent();
                    TabbedPanel.this.fireTabMoved(TabbedPanel.this.findTab(draggableComponentBoxEvent.getDraggableComponent()));
                }
            }
            TabbedPanel.this.updateShadow();
        }
    };
    private PropertyMapTreeListener propertyChangedListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            Object object;
            TabbedPanel.this.updateProperties();
            TabbedPanelButtonProperties tabbedPanelButtonProperties = TabbedPanel.this.properties.getButtonProperties();
            Map map2 = (Map)map.get(tabbedPanelButtonProperties.getTabDropDownListButtonProperties().getMap());
            if (map2 != null && TabbedPanel.this.dropDownList != null) {
                object = TabbedPanel.this.dropDownList.getButton();
                if (map2.keySet().contains(ButtonProperties.FACTORY)) {
                    object = TabbedPanel.this.properties.getButtonProperties().getTabDropDownListButtonProperties().getFactory().createButton(TabbedPanel.this);
                    TabbedPanel.this.dropDownList.setButton((AbstractButton)object);
                }
                TabbedPanel.this.properties.getButtonProperties().getTabDropDownListButtonProperties().applyTo((AbstractButton)object);
            }
            if (TabbedPanel.this.scrollButtonBox != null) {
                object = new AbstractButton[]{TabbedPanel.this.scrollButtonBox.getUpButton(), TabbedPanel.this.scrollButtonBox.getDownButton(), TabbedPanel.this.scrollButtonBox.getLeftButton(), TabbedPanel.this.scrollButtonBox.getRightButton()};
                ButtonProperties[] buttonPropertiesArray = new ButtonProperties[]{tabbedPanelButtonProperties.getScrollUpButtonProperties(), tabbedPanelButtonProperties.getScrollDownButtonProperties(), tabbedPanelButtonProperties.getScrollLeftButtonProperties(), tabbedPanelButtonProperties.getScrollRightButtonProperties()};
                for (int i = 0; i < ((AbstractButton[])object).length; ++i) {
                    map2 = (Map)map.get(buttonPropertiesArray[i].getMap());
                    if (map2 == null) continue;
                    if (map2.keySet().contains(ButtonProperties.FACTORY)) {
                        object[i] = buttonPropertiesArray[i].getFactory().createButton(TabbedPanel.this);
                    }
                    buttonPropertiesArray[i].applyTo(object[i]);
                }
                TabbedPanel.this.scrollButtonBox.setButtons(object[0], object[1], object[2], object[3]);
            }
            if ((map2 = (Map)map.get(TabbedPanel.this.properties.getTabAreaProperties().getMap())) != null && map2.keySet().contains(TabAreaProperties.HOVER_LISTENER)) {
                object = TabbedPanel.this.tabAreaContainer.getHoverListener();
                TabbedPanel.this.tabAreaContainer.setHoverListener((HoverListener)((ValueChange)map2.get(TabAreaProperties.HOVER_LISTENER)).getNewValue());
            }
            if ((map2 = (Map)map.get(TabbedPanel.this.properties.getTabAreaComponentsProperties().getMap())) != null && map2.keySet().contains(TabAreaComponentsProperties.HOVER_LISTENER)) {
                object = TabbedPanel.this.tabAreaComponentsPanel.getHoverListener();
                TabbedPanel.this.tabAreaComponentsPanel.setHoverListener((HoverListener)((ValueChange)map2.get(TabAreaComponentsProperties.HOVER_LISTENER)).getNewValue());
            }
            if ((map2 = (Map)map.get(TabbedPanel.this.properties.getMap())) != null && map2.keySet().contains(TabbedPanelProperties.HOVER_LISTENER)) {
                object = TabbedPanel.this.componentsPanel.getHoverListener();
                TabbedPanel.this.componentsPanel.setHoverListener((HoverListener)((ValueChange)map2.get(TabbedPanelProperties.HOVER_LISTENER)).getNewValue());
            }
        }
    };

    public TabbedPanel() {
        this.initialize(new TabbedPanelContentPanel(this, new TabContentPanel(this)));
    }

    public TabbedPanel(JComponent jComponent) {
        this.initialize(jComponent);
    }

    public boolean tabAreaContainsPoint(Point point) {
        return this.tabAreaContainer.contains(SwingUtilities.convertPoint(this, point, this.tabAreaContainer));
    }

    public boolean contentAreaContainsPoint(Point point) {
        return this.contentPanel != null ? this.contentPanel.contains(SwingUtilities.convertPoint(this, point, this.contentPanel)) : false;
    }

    public void addTab(Tab tab) {
        this.doInsertTab(tab, null, -1);
    }

    public void insertTab(Tab tab, int n) {
        this.doInsertTab(tab, null, n);
    }

    public void insertTab(Tab tab, Point point) {
        this.doInsertTab(tab, point, -1);
    }

    public void removeTab(Tab tab) {
        if (tab != null && tab.getTabbedPanel() == this) {
            if (this.getSelectedTab() != tab) {
                tab.setTabbedPanel(null);
            } else {
                this.removingSelected = true;
            }
            this.draggableComponentBox.removeDraggableComponent(tab.getDraggableComponent());
        }
        this.checkOnlyOneTab(false);
    }

    public void moveTab(Tab tab, Point point) {
        if (this.tabs.contains(tab)) {
            this.draggableComponentBox.dragDraggableComponent(tab.getDraggableComponent(), SwingUtilities.convertPoint(this, point, this.draggableComponentBox));
        }
    }

    public void setSelectedTab(Tab tab) {
        if (this.getSelectedTab() == tab) {
            return;
        }
        if (tab != null) {
            if (tab.isEnabled() && this.getTabIndex(tab) > -1) {
                if (tab.getDraggableComponent() == this.draggableComponentBox.getSelectedDraggableComponent()) {
                    this.setHighlightedTab(tab);
                } else {
                    tab.setSelected(true);
                }
            }
        } else {
            this.draggableComponentBox.selectDraggableComponent(null);
        }
    }

    public Tab getSelectedTab() {
        return this.findTab(this.draggableComponentBox.getSelectedDraggableComponent());
    }

    public void setHighlightedTab(Tab tab) {
        if (!this.settingHighlighted) {
            this.settingHighlighted = true;
            Tab tab2 = this.highlightedTab;
            Tab tab3 = null;
            if (tab2 != tab) {
                this.draggableComponentBox.setTopComponent(tab != null ? tab.getDraggableComponent() : null);
            }
            if (tab != null) {
                if (this.getTabIndex(tab) > -1) {
                    this.highlightedTab = tab;
                    if (tab2 != null && tab2 != tab) {
                        tab2.setHighlighted(false);
                    }
                    if (tab2 != tab) {
                        if (tab.isEnabled()) {
                            tab.setHighlighted(true);
                        } else {
                            tab.setHighlighted(false);
                            this.highlightedTab = null;
                        }
                    }
                    if (tab.isEnabled() && tab != tab2) {
                        tab3 = tab;
                    }
                    if (tab2 != tab) {
                        this.fireHighlightedEvent(tab3, tab2);
                    }
                }
            } else if (tab2 != null) {
                this.highlightedTab = null;
                tab2.setHighlighted(false);
                this.fireHighlightedEvent(null, tab2);
            }
            this.updateShadow();
            this.settingHighlighted = false;
        }
    }

    public Tab getHighlightedTab() {
        return this.highlightedTab;
    }

    public int getTabCount() {
        return this.draggableComponentBox.getDraggableComponentCount();
    }

    public Tab getTabAt(int n) {
        return this.findTab(this.draggableComponentBox.getDraggableComponentAt(n));
    }

    public int getTabIndex(Tab tab) {
        return tab == null ? -1 : this.draggableComponentBox.getDraggableComponentIndex(tab.getDraggableComponent());
    }

    public void setTabAreaComponents(JComponent[] jComponentArray) {
        int n;
        if (this.tabAreaComponents != null) {
            for (n = 0; n < this.tabAreaComponents.length; ++n) {
                this.tabAreaComponentsPanel.remove(this.tabAreaComponents[n]);
            }
        }
        JComponent[] jComponentArray2 = this.tabAreaComponents = jComponentArray == null ? null : (JComponent[])jComponentArray.clone();
        if (jComponentArray != null) {
            for (n = 0; n < jComponentArray.length; ++n) {
                this.tabAreaComponentsPanel.add(jComponentArray[n]);
            }
        }
        this.revalidate();
    }

    public boolean isTabAreaComponentsVisible() {
        return this.tabAreaComponentsPanel.isVisible();
    }

    public JComponent[] getTabAreaComponents() {
        return this.tabAreaComponents == null ? null : (JComponent[])this.tabAreaComponents.clone();
    }

    public void addTabListener(TabListener tabListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(tabListener);
    }

    public void removeTabListener(TabListener tabListener) {
        if (this.listeners != null) {
            this.listeners.remove(tabListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public TabbedPanelProperties getProperties() {
        return this.properties;
    }

    public boolean hasContentArea() {
        return this.contentPanel != null;
    }

    DraggableComponentBox getDraggableComponentBox() {
        return this.draggableComponentBox;
    }

    private void initialize(JComponent jComponent) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.tabAreaContainer.setOpaque(false);
        this.tabAreaComponentsPanel.setOpaque(false);
        this.draggableComponentBox.setOuterParentArea(this.tabAreaContainer);
        this.tabAreaContainer.add(this.draggableComponentBox);
        this.tabAreaContainer.add(this.tabAreaComponentsPanel);
        this.contentPanel = jComponent;
        this.draggableComponentBox.addListener(this.draggableComponentBoxListener);
        if (jComponent != null) {
            this.componentsPanel.add((Component)jComponent, "Center");
        }
        this.add((Component)this.componentsPanel, "Center");
        PropertyMapWeakListenerManager.addWeakTreeListener(this.properties.getMap(), this.propertyChangedListener);
        this.updateProperties();
    }

    private void updateProperties() {
        this.componentsPanel.remove(this.draggableComponentBox);
        this.tabAreaOrientation = this.properties.getTabAreaOrientation();
        this.updateTabArea();
        this.updateAllTabsProperties();
        this.componentsPanel.add((Component)this.tabAreaContainer, ComponentUtil.getBorderLayoutOrientation(this.tabAreaOrientation));
        this.shadowSize = this.properties.getShadowSize();
        this.componentsPanel.setBorder(this.contentPanel != null && this.properties.getShadowEnabled() ? new EmptyBorder(0, 0, this.shadowSize, this.shadowSize) : null);
        this.checkOnlyOneTab(true);
        this.updateScrollButtons();
        this.updateTabDropDownList();
        this.repaint();
        this.revalidate();
    }

    private void updateTabDropDownList() {
        TabDropDownListVisiblePolicy tabDropDownListVisiblePolicy = this.properties.getTabDropDownListVisiblePolicy();
        TabLayoutPolicy tabLayoutPolicy = this.properties.getTabLayoutPolicy();
        if (tabDropDownListVisiblePolicy != this.listVisiblePolicy || tabLayoutPolicy != this.listTabLayoutPolicy) {
            if (this.dropDownList != null) {
                this.tabAreaComponentsPanel.remove(this.dropDownList);
                this.dropDownList.dispose();
                this.dropDownList = null;
            }
            if (tabDropDownListVisiblePolicy == TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB || tabDropDownListVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE && tabLayoutPolicy == TabLayoutPolicy.SCROLLING) {
                this.dropDownList = new TabDropDownList(this, this.properties.getButtonProperties().getTabDropDownListButtonProperties().applyTo(this.properties.getButtonProperties().getTabDropDownListButtonProperties().getFactory().createButton(this)));
                this.tabAreaComponentsPanel.add((Component)this.dropDownList, this.scrollButtonBox == null ? 0 : 1);
                if (tabDropDownListVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
                    this.dropDownList.setVisible(false);
                }
            }
        }
        this.listVisiblePolicy = tabDropDownListVisiblePolicy;
        this.listTabLayoutPolicy = tabLayoutPolicy;
        if (this.dropDownList != null && !this.draggableComponentBox.isScrollEnabled() && this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
            this.dropDownList.setVisible(false);
        }
    }

    private void updateAllTabsProperties() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.updateTabProperties((Tab)this.tabs.get(i));
        }
    }

    private void updateTabProperties(Tab tab) {
        tab.getDraggableComponent().setAbortDragKeyCode(this.properties.getAbortDragKey());
        tab.getDraggableComponent().setReorderEnabled(this.properties.getTabReorderEnabled());
        tab.getDraggableComponent().setSelectOnMousePress(this.properties.getTabSelectTrigger() == TabSelectTrigger.MOUSE_PRESS);
    }

    private void updateTabArea() {
        boolean bl = this.properties.getTabAreaComponentsProperties().getStretchEnabled();
        if (this.tabAreaOrientation == Direction.UP) {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 2, 1.0, 1.0, 15);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 1, 0, bl ? 3 : 0, 0.0, 1.0, 15);
            this.updateTabAreaComponentsPanel(Direction.RIGHT, 0, 1);
        } else if (this.tabAreaOrientation == Direction.DOWN) {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 2, 1.0, 1.0, 11);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 1, 0, bl ? 3 : 0, 0.0, 0.0, 11);
            this.updateTabAreaComponentsPanel(Direction.RIGHT, 0, 0);
        } else if (this.tabAreaOrientation == Direction.LEFT) {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 3, 1.0, 1.0, 13);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 0, 1, bl ? 2 : 0, 0.0, 0.0, 13);
            this.updateTabAreaComponentsPanel(Direction.DOWN, 0, 0);
        } else {
            this.setTabAreaLayoutConstraints(this.draggableComponentBox, 0, 0, 3, 1.0, 1.0, 17);
            this.setTabAreaLayoutConstraints(this.tabAreaComponentsPanel, 0, 1, bl ? 2 : 0, 0.0, 0.0, 17);
            this.updateTabAreaComponentsPanel(Direction.DOWN, 0, 1);
        }
        if (this.getTabCount() > 1) {
            this.draggableComponentBox.setScrollEnabled(this.properties.getTabLayoutPolicy() == TabLayoutPolicy.SCROLLING);
        }
        this.draggableComponentBox.setScrollOffset(this.properties.getTabScrollingOffset());
        this.draggableComponentBox.setComponentDirection(this.tabAreaOrientation);
        this.draggableComponentBox.setEnsureSelectedVisible(this.properties.getEnsureSelectedTabVisible());
        this.draggableComponentBox.setAutoSelect(this.properties.getAutoSelectTab());
        this.draggableComponentBox.setComponentSpacing(this.properties.getTabSpacing());
        this.draggableComponentBox.setDepthSortOrder(this.properties.getTabDepthOrderPolicy() == TabDepthOrderPolicy.DESCENDING);
        this.properties.getTabAreaProperties().getComponentProperties().applyTo(this.tabAreaContainer);
        this.updateShapedPanelProperties(this.tabAreaContainer, this.properties.getTabAreaProperties().getComponentProperties().getBackgroundColor(), this.properties.getTabAreaProperties().getShapedPanelProperties());
        this.properties.getTabAreaComponentsProperties().getComponentProperties().applyTo(this.tabAreaComponentsPanel, this.tabAreaOrientation.getNextCW());
        this.updateShapedPanelProperties(this.tabAreaComponentsPanel, this.properties.getTabAreaComponentsProperties().getComponentProperties().getBackgroundColor(), this.properties.getTabAreaComponentsProperties().getShapedPanelProperties());
    }

    private void updateTabAreaComponentsPanel(Direction direction, int n, int n2) {
        ((DirectionLayout)this.tabAreaComponentsPanel.getLayout()).setDirection(direction);
    }

    private void updateShapedPanelProperties(ShapedPanel shapedPanel, Color color, ShapedPanelProperties shapedPanelProperties) {
        shapedPanel.setOpaque(false);
        ComponentPainter componentPainter = shapedPanelProperties.getComponentPainter();
        if (componentPainter != null) {
            shapedPanel.setComponentPainter(componentPainter);
        } else if (color != null) {
            shapedPanel.setComponentPainter(SolidColorComponentPainter.BACKGROUND_COLOR_PAINTER);
        } else {
            shapedPanel.setComponentPainter(null);
        }
        shapedPanel.setVerticalFlip(shapedPanelProperties.getVerticalFlip());
        shapedPanel.setHorizontalFlip(shapedPanelProperties.getHorizontalFlip());
        shapedPanel.setDirection(this.properties.getTabAreaOrientation().getNextCW());
        shapedPanel.setClipChildren(shapedPanelProperties.getClipChildren());
    }

    private void setTabAreaLayoutConstraints(JComponent jComponent, int n, int n2, int n3, double d, double d2, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.fill = n3;
        this.constraints.weightx = d;
        this.constraints.weighty = d2;
        this.constraints.anchor = n4;
        this.tabAreaLayoutManager.setConstraints(jComponent, this.constraints);
    }

    private void doInsertTab(Tab tab, Point point, int n) {
        if (tab != null && !this.tabs.contains(tab)) {
            tab.setTabbedPanel(this);
            this.tabs.add(tab);
            if (point != null) {
                this.draggableComponentBox.insertDraggableComponent(tab.getDraggableComponent(), SwingUtilities.convertPoint(this, point, this.draggableComponentBox));
            } else {
                this.draggableComponentBox.insertDraggableComponent(tab.getDraggableComponent(), n);
            }
            this.updateTabProperties(tab);
            this.checkOnlyOneTab(true);
        }
    }

    private Tab findTab(DraggableComponent draggableComponent) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (((Tab)this.tabs.get(i)).getDraggableComponent() != draggableComponent) continue;
            return (Tab)this.tabs.get(i);
        }
        return null;
    }

    private void checkOnlyOneTab(boolean bl) {
        if (this.getTabCount() == 1) {
            this.draggableComponentBox.setScrollEnabled(false);
            this.updateScrollButtons();
        } else if (bl && this.getTabCount() == 2) {
            this.draggableComponentBox.setScrollEnabled(this.properties.getTabLayoutPolicy() == TabLayoutPolicy.SCROLLING);
            this.updateScrollButtons();
        }
    }

    private void setScrollButtonsVisible() {
        if (this.scrollButtonBox != null) {
            boolean bl = !this.tabAreaOrientation.isHorizontal() ? this.draggableComponentBox.getInnerSize().getWidth() > (double)this.calcScrollWidth() : this.draggableComponentBox.getInnerSize().getHeight() > (double)this.calcScrollHeight();
            this.scrollButtonBox.setVisible(bl);
            if (this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE) {
                this.dropDownList.setVisible(bl);
            }
            if (!bl) {
                this.scrollButtonBox.setButton1Enabled(false);
                this.scrollButtonBox.setButton2Enabled(true);
            }
        }
    }

    private int calcScrollWidth() {
        int n;
        Insets insets = this.tabAreaComponentsPanel.getInsets();
        boolean bl = this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE;
        boolean bl2 = bl ? ComponentUtil.isOnlyVisibleComponents(new Component[]{this.scrollButtonBox, this.dropDownList}) : ComponentUtil.isOnlyVisibleComponent(this.scrollButtonBox);
        int n2 = n = this.tabAreaComponentsPanel.isVisible() && bl2 ? insets.left + insets.right : 0;
        int n3 = this.tabAreaComponentsPanel.isVisible() ? (int)this.tabAreaComponentsPanel.getPreferredSize().getWidth() - n - (this.scrollButtonBox.isVisible() ? this.scrollButtonBox.getWidth() + (bl ? this.dropDownList.getWidth() : 0) : 0) : 0;
        Insets insets2 = this.tabAreaContainer.getInsets();
        return this.tabAreaContainer.getWidth() - n3 - insets2.left - insets2.right;
    }

    private int calcScrollHeight() {
        int n;
        Insets insets = this.tabAreaComponentsPanel.getInsets();
        boolean bl = this.listVisiblePolicy == TabDropDownListVisiblePolicy.TABS_NOT_VISIBLE;
        boolean bl2 = bl ? ComponentUtil.isOnlyVisibleComponents(new Component[]{this.scrollButtonBox, this.dropDownList}) : ComponentUtil.isOnlyVisibleComponent(this.scrollButtonBox);
        int n2 = n = this.tabAreaComponentsPanel.isVisible() && bl2 ? insets.top + insets.bottom : 0;
        int n3 = this.tabAreaComponentsPanel.isVisible() ? (int)this.tabAreaComponentsPanel.getPreferredSize().getHeight() - n - (this.scrollButtonBox.isVisible() ? this.scrollButtonBox.getHeight() + (bl ? this.dropDownList.getHeight() : 0) : 0) : 0;
        Insets insets2 = this.tabAreaContainer.getInsets();
        return this.tabAreaContainer.getHeight() - n3 - insets2.top - insets2.bottom;
    }

    private void updateScrollButtons() {
        ScrollButtonBox scrollButtonBox = this.scrollButtonBox;
        this.scrollButtonBox = this.draggableComponentBox.getScrollButtonBox();
        if (scrollButtonBox != this.scrollButtonBox) {
            if (scrollButtonBox != null) {
                this.tabAreaComponentsPanel.remove(scrollButtonBox);
            }
            if (this.scrollButtonBox != null) {
                this.scrollButtonBox.setButtons(this.properties.getButtonProperties().getScrollUpButtonProperties().applyTo(this.properties.getButtonProperties().getScrollUpButtonProperties().getFactory().createButton(this)), this.properties.getButtonProperties().getScrollDownButtonProperties().applyTo(this.properties.getButtonProperties().getScrollDownButtonProperties().getFactory().createButton(this)), this.properties.getButtonProperties().getScrollLeftButtonProperties().applyTo(this.properties.getButtonProperties().getScrollLeftButtonProperties().getFactory().createButton(this)), this.properties.getButtonProperties().getScrollRightButtonProperties().applyTo(this.properties.getButtonProperties().getScrollRightButtonProperties().getFactory().createButton(this)));
                this.scrollButtonBox.setVisible(false);
                this.tabAreaComponentsPanel.add((Component)this.scrollButtonBox, 0);
            }
        }
    }

    private void fireTabMoved(Tab tab) {
        if (this.listeners != null) {
            TabEvent tabEvent = new TabEvent(this, tab);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabMoved(tabEvent);
            }
        }
    }

    private void fireDraggedEvent(Tab tab, MouseEvent mouseEvent) {
        if (this.listeners != null) {
            TabDragEvent tabDragEvent = new TabDragEvent((Object)this, EventUtil.convert(mouseEvent, tab));
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDragged(tabDragEvent);
            }
        }
    }

    private void fireDroppedEvent(Tab tab, MouseEvent mouseEvent) {
        if (this.listeners != null) {
            TabDragEvent tabDragEvent = new TabDragEvent((Object)this, EventUtil.convert(mouseEvent, tab));
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDropped(tabDragEvent);
            }
        }
    }

    private void fireNotDroppedEvent(Tab tab) {
        if (this.listeners != null) {
            TabEvent tabEvent = new TabEvent(this, tab);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDragAborted(tabEvent);
            }
        }
    }

    private void fireSelectedEvent(Tab tab, Tab tab2) {
        if (this.listeners != null) {
            int n;
            TabStateChangedEvent tabStateChangedEvent = new TabStateChangedEvent(this, this, tab2, tab2, tab);
            Object[] objectArray = this.listeners.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                ((TabListener)objectArray[n]).tabDeselected(tabStateChangedEvent);
            }
            tabStateChangedEvent = new TabStateChangedEvent(this, this, tab, tab2, tab);
            objectArray = this.listeners.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                ((TabListener)objectArray[n]).tabSelected(tabStateChangedEvent);
            }
        }
    }

    private void fireHighlightedEvent(Tab tab, Tab tab2) {
        if (this.listeners != null) {
            int n;
            TabStateChangedEvent tabStateChangedEvent = new TabStateChangedEvent(this, this, tab2, tab2, tab);
            Object[] objectArray = this.listeners.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                ((TabListener)objectArray[n]).tabDehighlighted(tabStateChangedEvent);
            }
            tabStateChangedEvent = new TabStateChangedEvent(this, this, tab, tab2, tab);
            objectArray = this.listeners.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                ((TabListener)objectArray[n]).tabHighlighted(tabStateChangedEvent);
            }
        }
    }

    private void fireAddedEvent(Tab tab) {
        if (this.listeners != null) {
            TabEvent tabEvent = new TabEvent(this, tab);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabAdded(tabEvent);
            }
        }
    }

    private void fireRemovedEvent(Tab tab) {
        if (this.listeners != null) {
            TabRemovedEvent tabRemovedEvent = new TabRemovedEvent(this, tab, this);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabRemoved(tabRemovedEvent);
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 504) {
            if (!this.mouseEntered) {
                this.mouseEntered = true;
                super.processMouseEvent(mouseEvent);
            }
        } else if (mouseEvent.getID() == 505) {
            if (!this.contains(mouseEvent.getPoint())) {
                this.mouseEntered = false;
                super.processMouseEvent(mouseEvent);
            }
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    void doProcessMouseEvent(MouseEvent mouseEvent) {
        this.processMouseEvent(SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, this));
    }

    void doProcessMouseMotionEvent(MouseEvent mouseEvent) {
        this.processMouseMotionEvent(SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, this));
    }

    private void updateShadow() {
        if (this.contentPanel != null && this.properties.getShadowEnabled()) {
            Point point = SwingUtilities.convertPoint(this.tabAreaContainer, new Point(0, 0), this);
            this.repaint(point.x, point.y, this.tabAreaContainer.getWidth() + this.shadowSize, this.tabAreaContainer.getHeight() + this.shadowSize);
        }
    }

    private class ShadowPanel
    extends HoverablePanel {
        ShadowPanel() {
            super(new BorderLayout(), TabbedPanel.this.properties.getHoverListener());
            this.setOpaque(false);
            this.setCursor(null);
        }

        public boolean contains(int n, int n2) {
            return TabbedPanel.this.properties.getShadowEnabled() ? this.doContains(n, n2) : super.contains(n, n2);
        }

        public boolean inside(int n, int n2) {
            return TabbedPanel.this.properties.getShadowEnabled() ? this.doContains(n, n2) : super.inside(n, n2);
        }

        private boolean doContains(int n, int n2) {
            Dimension dimension = DimensionUtil.getInnerDimension(this.getSize(), this.getInsets());
            return n >= 0 && n2 >= 0 && (double)n < dimension.getWidth() && (double)n2 < dimension.getHeight();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (TabbedPanel.this.contentPanel == null || !TabbedPanel.this.properties.getShadowEnabled()) {
                return;
            }
            new ShadowPainter(this, TabbedPanel.this.componentsPanel, TabbedPanel.this.getHighlightedTab(), TabbedPanel.this.contentPanel, TabbedPanel.this.tabAreaComponentsPanel, TabbedPanel.this.tabAreaContainer, TabbedPanel.this.draggableComponentBox, TabbedPanel.this.properties.getTabAreaOrientation(), TabbedPanel.this.properties.getPaintTabAreaShadow(), TabbedPanel.this.shadowSize, TabbedPanel.this.properties.getShadowBlendAreaSize(), TabbedPanel.this.properties.getShadowColor(), TabbedPanel.this.properties.getShadowStrength(), TabbedPanel.this.getTabIndex(TabbedPanel.this.getHighlightedTab()) == TabbedPanel.this.getTabCount() - 1).paint(graphics);
        }
    }

    private class HoverablePanel
    extends HoverableShapedPanel {
        public HoverablePanel(LayoutManager layoutManager, HoverListener hoverListener) {
            super(layoutManager, hoverListener, TabbedPanel.this);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            TabbedPanel.this.doProcessMouseEvent(mouseEvent);
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            TabbedPanel.this.doProcessMouseMotionEvent(mouseEvent);
        }

        public boolean acceptHover(ArrayList arrayList) {
            return TabbedHoverUtil.acceptTabbedPanelHover(TabbedPanel.this.properties.getHoverPolicy(), arrayList, TabbedPanel.this, this);
        }
    }
}

