/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import javax.swing.JPanel;
import net.infonode.gui.layout.StackableLayout;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;

public class TabContentPanel
extends JPanel {
    private TabbedPanel tabbedPanel;

    public TabContentPanel(TabbedPanel tabbedPanel) {
        final StackableLayout stackableLayout = new StackableLayout(this);
        this.setLayout(stackableLayout);
        this.setOpaque(false);
        this.tabbedPanel = tabbedPanel;
        stackableLayout.setAutoShowFirstComponent(false);
        tabbedPanel.addTabListener(new TabAdapter(){

            public void tabSelected(TabStateChangedEvent tabStateChangedEvent) {
                stackableLayout.showComponent(tabStateChangedEvent.getTab() == null ? null : tabStateChangedEvent.getTab().getContentComponent());
            }

            public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
                if (tabRemovedEvent.getTab().getContentComponent() != null) {
                    TabContentPanel.this.remove(tabRemovedEvent.getTab().getContentComponent());
                }
            }

            public void tabAdded(TabEvent tabEvent) {
                if (tabEvent.getTab().getContentComponent() != null) {
                    TabContentPanel.this.add(tabEvent.getTab().getContentComponent());
                }
            }
        });
    }

    public TabbedPanel getTabbedPanel() {
        return this.tabbedPanel;
    }
}

