/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.infonode.properties.base.Property;
import net.infonode.properties.base.exception.InvalidPropertyTypeException;
import net.infonode.properties.propertymap.PropertyMapImpl;
import net.infonode.properties.propertymap.ref.PropertyMapRef;
import net.infonode.properties.propertymap.ref.PropertyMapRefDecoder;
import net.infonode.properties.propertymap.value.PropertyValue;
import net.infonode.util.Printer;
import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.collection.notifymap.ChangeNotifyMapListener;

public class PropertyRefValue
implements PropertyValue,
ChangeNotifyMapListener {
    private PropertyMapImpl map;
    private Property property;
    private PropertyMapRef propertyObjectRef;
    private Property propertyRef;
    private PropertyRefValue parentRef;

    public PropertyRefValue(PropertyMapImpl propertyMapImpl, Property property, PropertyMapRef propertyMapRef, Property property2, PropertyRefValue propertyRefValue) {
        if (!property.getType().isAssignableFrom(property2.getType())) {
            throw new InvalidPropertyTypeException(property, property2, "Can't create reference from Property '" + property + "' to property '" + property2 + "' because they are of incompatible types!");
        }
        this.map = propertyMapImpl;
        this.property = property;
        this.propertyObjectRef = propertyMapRef;
        this.propertyRef = property2;
        this.parentRef = propertyRefValue;
    }

    public void updateListener(boolean bl) {
        if (bl) {
            this.propertyObjectRef.getMap(this.map).getMap().addListener(this);
        } else {
            this.propertyObjectRef.getMap(this.map).getMap().removeListener(this);
        }
    }

    public PropertyValue getParent() {
        return this.parentRef;
    }

    public Object get(PropertyMapImpl propertyMapImpl) {
        PropertyMapImpl propertyMapImpl2 = this.propertyObjectRef.getMap(propertyMapImpl);
        PropertyValue propertyValue = (propertyMapImpl2 == null ? this.propertyObjectRef.getMap(this.map) : propertyMapImpl2).getValue(this.propertyRef);
        return propertyValue == null ? null : propertyValue.get(propertyMapImpl2);
    }

    public Object getWithDefault(PropertyMapImpl propertyMapImpl) {
        PropertyMapImpl propertyMapImpl2 = this.propertyObjectRef.getMap(propertyMapImpl);
        PropertyValue propertyValue = (propertyMapImpl2 == null ? this.propertyObjectRef.getMap(this.map) : propertyMapImpl2).getValueWithDefault(this.propertyRef);
        return propertyValue == null ? null : propertyValue.getWithDefault(propertyMapImpl2);
    }

    public PropertyValue getSubValue(PropertyMapImpl propertyMapImpl) {
        PropertyMapImpl propertyMapImpl2 = this.propertyObjectRef.getMap(propertyMapImpl);
        if (propertyMapImpl2 == null) {
            return null;
        }
        if (!propertyMapImpl2.getPropertyGroup().hasProperty(this.propertyRef)) {
            return null;
        }
        return new PropertyRefValue(propertyMapImpl, this.property, this.propertyObjectRef, this.propertyRef, this);
    }

    public void unset() {
        this.propertyObjectRef.getMap(this.map).getMap().removeListener(this);
    }

    public void entriesChanged(ConstMap constMap) {
        ValueChange valueChange = (ValueChange)constMap.get(this.propertyRef);
        if (valueChange != null) {
            this.map.firePropertyValueChanged(this.property, new ValueChange(valueChange.getOldValue(), this));
        }
    }

    public String toString() {
        return "ref -> " + this.propertyObjectRef + '.' + this.propertyRef;
    }

    public void dump(Printer printer) {
        printer.println(this.toString());
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        this.propertyObjectRef.write(objectOutputStream);
        objectOutputStream.writeUTF(this.propertyRef.getName());
    }

    public boolean isSerializable() {
        return true;
    }

    public static PropertyValue decode(ObjectInputStream objectInputStream, PropertyMapImpl propertyMapImpl, Property property) throws IOException {
        PropertyMapRef propertyMapRef = PropertyMapRefDecoder.decode(objectInputStream);
        String string = objectInputStream.readUTF();
        if (property == null || propertyMapRef == null) {
            return null;
        }
        Property property2 = propertyMapRef.getMap(propertyMapImpl).getPropertyGroup().getProperty(string);
        if (property2 == null) {
            return null;
        }
        return new PropertyRefValue(propertyMapImpl, property, propertyMapRef, property2, null);
    }

    public static void skip(ObjectInputStream objectInputStream) throws IOException {
        PropertyMapRefDecoder.decode(objectInputStream);
        objectInputStream.readUTF();
    }

    public PropertyValue copyTo(PropertyMapImpl propertyMapImpl) {
        return new PropertyRefValue(propertyMapImpl, this.property, this.propertyObjectRef, this.propertyRef, null);
    }
}

