/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.ComponentUtil;
import net.infonode.util.ColorUtil;

public class EtchedLineBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean drawTop;
    private boolean drawBottom;
    private boolean drawLeft;
    private boolean drawRight;
    private Insets insets;
    private Color highlightColor;
    private Color shadowColor;

    public EtchedLineBorder() {
        this(true, true, true, true);
    }

    public EtchedLineBorder(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(bl, bl2, bl3, bl4, null, null);
    }

    public EtchedLineBorder(boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color, Color color2) {
        this.drawBottom = bl3;
        this.drawLeft = bl2;
        this.drawRight = bl4;
        this.drawTop = bl;
        this.insets = new Insets(bl ? 2 : 0, bl2 ? 2 : 0, bl3 ? 2 : 0, bl4 ? 2 : 0);
        this.highlightColor = color;
        this.shadowColor = color2;
    }

    public Insets getBorderInsets(Component component) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = this.highlightColor == null ? ColorUtil.mult(ComponentUtil.getBackgroundColor(component), 1.7) : this.highlightColor;
        Color color2 = this.shadowColor == null ? ColorUtil.mult(ComponentUtil.getBackgroundColor(component), 0.5) : this.shadowColor;
        graphics.setColor(color);
        if (this.drawTop) {
            graphics.drawLine(n, n2 + 1, n + n3 - 1, n2 + 1);
        }
        if (this.drawLeft) {
            graphics.drawLine(n + 1, n2, n + 1, n2 + n4 - 1);
        }
        graphics.setColor(color2);
        if (this.drawBottom) {
            graphics.drawLine(n, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
        }
        if (this.drawRight) {
            graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2 + n4 - 1);
        }
        graphics.setColor(color);
        if (this.drawBottom) {
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        }
        if (this.drawRight) {
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        }
        graphics.setColor(color2);
        if (this.drawTop) {
            graphics.drawLine(n, n2, n + n3 - 1, n2);
        }
        if (this.drawLeft) {
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
        }
        graphics.setColor(ComponentUtil.getBackgroundColor(component));
        if (this.drawTop && this.drawRight) {
            graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 1, n2);
        }
        if (this.drawBottom && this.drawLeft) {
            graphics.drawLine(n, n2 + n4 - 1, n + 1, n2 + n4 - 2);
        }
    }
}

