/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.util.ColorUtil;

public class EdgeBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider topLeftColor;
    private ColorProvider bottomRightColor;
    private boolean drawTop;
    private boolean drawBottom;
    private boolean drawLeft;
    private boolean drawRight;
    private Insets insets;

    public EdgeBorder() {
        this(true, true, true, true);
    }

    public EdgeBorder(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(null, bl, bl2, bl3, bl4);
    }

    public EdgeBorder(Color color, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FixedColorProvider fixedColorProvider = color == null ? null : new FixedColorProvider(color);
        this.init(fixedColorProvider, fixedColorProvider, bl, bl2, bl3, bl4);
    }

    public EdgeBorder(ColorProvider colorProvider) {
        this.init(colorProvider, colorProvider, true, true, true, true);
    }

    public EdgeBorder(ColorProvider colorProvider, ColorProvider colorProvider2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.init(colorProvider, colorProvider2, bl, bl2, bl3, bl4);
    }

    private void init(ColorProvider colorProvider, ColorProvider colorProvider2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.topLeftColor = colorProvider;
        this.bottomRightColor = colorProvider2;
        this.drawTop = bl;
        this.drawBottom = bl2;
        this.drawLeft = bl3;
        this.drawRight = bl4;
        this.insets = new Insets(bl ? 1 : 0, bl3 ? 1 : 0, bl2 ? 1 : 0, bl4 ? 1 : 0);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = this.getColor(this.topLeftColor, component);
        Color color2 = this.getColor(this.bottomRightColor, component);
        if (color != null && color2 != null) {
            graphics.setColor(color);
            if (this.drawTop) {
                graphics.drawLine(n, n2, n + n3 - 1, n2);
            }
            if (this.drawLeft) {
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
            }
            graphics.setColor(color2);
            if (this.drawRight) {
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
            if (this.drawBottom) {
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private Color getColor(ColorProvider colorProvider, Component component) {
        Color color;
        Color color2 = color = colorProvider != null ? colorProvider.getColor() : null;
        if (color == null) {
            Color color3 = ComponentUtil.getBackgroundColor(component);
            return color3 == null ? null : ColorUtil.mult(color3, 0.7f);
        }
        return color;
    }
}

