/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultButtonModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.infonode.gui.PopupListListener;
import net.infonode.gui.UIManagerUtil;
import net.infonode.gui.panel.SimplePanel;

public class PopupList
extends SimplePanel {
    private Popup popup = new Popup();
    private ArrayList listeners = new ArrayList(1);

    public PopupList(AbstractButton abstractButton) {
        this.setLayout(new BoxLayout(this, 1));
        this.setButton(abstractButton);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ((PopupButtonModel)((AbstractButton)PopupList.this.getComponent(0)).getModel()).setPressedInternal(false);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ((PopupButtonModel)((AbstractButton)PopupList.this.getComponent(0)).getModel()).setPressedInternal(true);
            }
        });
    }

    public JList getList() {
        return this.popup.getList();
    }

    public void setButton(AbstractButton abstractButton) {
        if (this.getComponentCount() > 0) {
            AbstractButton abstractButton2 = (AbstractButton)this.getComponent(0);
            abstractButton2.removeMouseListener(this.popup.getMouseListener());
            abstractButton2.removeMouseMotionListener(this.popup.getMouseMotionListener());
            this.remove(abstractButton2);
        }
        this.add(abstractButton);
        abstractButton.setModel(new PopupButtonModel());
        abstractButton.setAutoscrolls(true);
        abstractButton.setFocusable(false);
        abstractButton.addMouseListener(this.popup.getMouseListener());
        abstractButton.addMouseMotionListener(this.popup.getMouseMotionListener());
    }

    public AbstractButton getButton() {
        return this.getComponentCount() == 0 ? null : (AbstractButton)this.getComponent(0);
    }

    public void updateUI() {
        super.updateUI();
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    public void addPopupListListener(PopupListListener popupListListener) {
        this.listeners.add(popupListListener);
    }

    public void removePopupListListener(PopupListListener popupListListener) {
        this.listeners.remove(popupListListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getList().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getList().removeListSelectionListener(listSelectionListener);
    }

    private void fireWillBecomeVisible() {
        Object[] objectArray = this.listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((PopupListListener)objectArray[i]).willBecomeVisible(this);
        }
    }

    static /* synthetic */ void access$400(PopupList popupList) {
        popupList.fireWillBecomeVisible();
    }

    private class Popup
    extends JPopupMenu {
        private JList list = new JList();
        private JScrollPane scrollPane = new JScrollPane(this.list, 20, 31);
        private int oldIndex;

        Popup() {
            this.setLayout(new BoxLayout(this, 1));
            this.scrollPane.setBorder(null);
            this.setBorderPainted(true);
            this.setBorder(new LineBorder(UIManagerUtil.getColor("controlDkShadow", Color.BLACK), 1));
            this.add(this.scrollPane);
            this.scrollPane.getViewport().setOpaque(false);
            this.list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        this.setVisible(false);
                    }
                }
            });
            this.update();
        }

        public MouseMotionListener getMouseMotionListener() {
            return new MouseMotionAdapter(this){
                private final /* synthetic */ Popup this$1;
                {
                    this.this$1 = popup;
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        Component component = (Component)mouseEvent.getSource();
                        Point point = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), Popup.access$000(this.this$1));
                        int n = Popup.access$100(this.this$1).locationToIndex(SwingUtilities.convertPoint(Popup.access$000(this.this$1), point, Popup.access$100(this.this$1)));
                        if (!component.contains(mouseEvent.getPoint()) && (Popup.access$000(this.this$1).contains(point) || point.getY() > (double)(Popup.access$000(this.this$1).getY() + Popup.access$000(this.this$1).getHeight()) || point.getY() < (double)Popup.access$000(this.this$1).getY())) {
                            Popup.access$100(this.this$1).setSelectedIndex(n);
                            Popup.access$100(this.this$1).ensureIndexIsVisible(n);
                        }
                    }
                }
            };
        }

        public MouseListener getMouseListener() {
            return new MouseAdapter(this){
                private final /* synthetic */ Popup this$1;
                {
                    this.this$1 = popup;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        if (this.this$1.isVisible()) {
                            this.this$1.setVisible(false);
                            return;
                        }
                        Popup.access$200(this.this$1);
                        Popup.access$000(this.this$1).setViewportView(null);
                        Popup.access$100(this.this$1).setValueIsAdjusting(true);
                        PopupList.access$400(Popup.access$300(this.this$1));
                        Popup.access$100(this.this$1).setVisibleRowCount(Math.min(Popup.access$100(this.this$1).getModel().getSize(), 8));
                        Popup.access$502(this.this$1, Popup.access$100(this.this$1).getSelectedIndex());
                        Popup.access$100(this.this$1).ensureIndexIsVisible(Popup.access$500(this.this$1));
                        Popup.access$000(this.this$1).setViewportView(Popup.access$100(this.this$1));
                        Component component = (Component)mouseEvent.getSource();
                        this.this$1.show(component, 0, component.getHeight());
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        if (!this.this$1.isVisible()) {
                            return;
                        }
                        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), Popup.access$000(this.this$1));
                        if (Popup.access$000(this.this$1).contains(point)) {
                            Popup.access$100(this.this$1).setValueIsAdjusting(false);
                        } else if (!((Component)mouseEvent.getSource()).contains(mouseEvent.getPoint())) {
                            Popup.access$100(this.this$1).setSelectedIndex(Popup.access$500(this.this$1));
                            Popup.access$100(this.this$1).setValueIsAdjusting(false);
                        }
                    }
                }
            };
        }

        public JList getList() {
            return this.list;
        }

        public void updateUI() {
            super.updateUI();
            this.setBorder(new LineBorder(UIManagerUtil.getColor("controlDkShadow", Color.BLACK), 1));
            if (this.list != null) {
                this.update();
            }
        }

        private void update() {
            this.list.setFont(UIManager.getFont("ComboBox.font"));
            this.list.setForeground(UIManagerUtil.getColor("ComboBox.foreground"));
            this.list.setBackground(UIManagerUtil.getColor("ComboBox.background", "control"));
            this.list.setSelectionForeground(UIManagerUtil.getColor("ComboBox.selectionForeground"));
            this.list.setSelectionBackground(UIManagerUtil.getColor("ComboBox.selectionBackground"));
            this.list.setBorder(null);
            this.scrollPane.getViewport().setOpaque(false);
            this.scrollPane.setBorder(null);
        }

        static /* synthetic */ JScrollPane access$000(Popup popup) {
            return popup.scrollPane;
        }

        static /* synthetic */ JList access$100(Popup popup) {
            return popup.list;
        }

        static /* synthetic */ void access$200(Popup popup) {
            popup.update();
        }

        static /* synthetic */ PopupList access$300(Popup popup) {
            return popup.PopupList.this;
        }

        static /* synthetic */ int access$502(Popup popup, int n) {
            popup.oldIndex = n;
            return popup.oldIndex;
        }

        static /* synthetic */ int access$500(Popup popup) {
            return popup.oldIndex;
        }
    }

    private class PopupButtonModel
    extends DefaultButtonModel {
        private boolean pressed;

        private PopupButtonModel() {
        }

        public boolean isPressed() {
            return super.isPressed() || this.pressed;
        }

        public boolean isArmed() {
            return super.isArmed() || this.pressed;
        }

        public void setPressedInternal(boolean bl) {
            this.pressed = bl;
            this.fireStateChanged();
        }
    }
}

