/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Container;
import java.awt.Cursor;
import java.util.HashMap;
import javax.swing.JComponent;
import net.infonode.util.Utils;

public class CursorManager {
    private static HashMap oldCursors = new HashMap();
    private static boolean toggleVisibility = true;
    private static boolean enabled = true;
    private static Cursor currentCursor = Cursor.getDefaultCursor();

    private CursorManager() {
    }

    public static void setGlobalCursor(JComponent jComponent, Cursor cursor) {
        Container container = jComponent.getTopLevelAncestor();
        if (container == null) {
            return;
        }
        if (!oldCursors.containsKey(container)) {
            oldCursors.put(container, container.getCursor());
            if (toggleVisibility) {
                jComponent.getRootPane().getGlassPane().setVisible(true);
            }
        }
        if (!Utils.equals(container.getCursor(), cursor)) {
            currentCursor = cursor;
            if (enabled) {
                container.setCursor(cursor);
            }
        }
    }

    public static Cursor getCurrentGlobalCursor() {
        return currentCursor;
    }

    public static void resetGlobalCursor(JComponent jComponent) {
        Container container = jComponent.getTopLevelAncestor();
        if (container != null && oldCursors.containsKey(container)) {
            currentCursor = (Cursor)oldCursors.remove(container);
            if (enabled) {
                container.setCursor(currentCursor);
            }
            if (toggleVisibility) {
                jComponent.getRootPane().getGlassPane().setVisible(false);
            }
        }
    }

    public static void setToggleGlassPaneVisibility(boolean bl) {
        toggleVisibility = bl;
    }

    public static boolean isToggleGlassPaneVisibility() {
        return toggleVisibility;
    }

    public static void setEnabled(boolean bl) {
        enabled = bl;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isGlobalCursorSet(JComponent jComponent) {
        Container container = jComponent.getTopLevelAncestor();
        return container != null && oldCursors.containsKey(container);
    }
}

