/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.util;

import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.WindowMenuUtil;

public final class DockingUtil {
    private DockingUtil() {
    }

    public static RootWindow createRootWindow(AbstractViewMap abstractViewMap, boolean bl) {
        return DockingUtil.createRootWindow(abstractViewMap, abstractViewMap, bl);
    }

    public static RootWindow createRootWindow(AbstractViewMap abstractViewMap, ViewSerializer viewSerializer, boolean bl) {
        TabWindow tabWindow = new TabWindow();
        for (int i = 0; i < abstractViewMap.getViewCount(); ++i) {
            tabWindow.addTab(abstractViewMap.getViewAtIndex(i));
        }
        tabWindow.setSelectedTab(0);
        RootWindow rootWindow = new RootWindow(viewSerializer, tabWindow);
        if (bl) {
            rootWindow.setPopupMenuFactory(WindowMenuUtil.createWindowMenuFactory(abstractViewMap, true));
        }
        return rootWindow;
    }

    public static boolean isAncestor(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        return dockingWindow2 != null && (dockingWindow == dockingWindow2 || DockingUtil.isAncestor(dockingWindow, dockingWindow2.getWindowParent()));
    }

    public static void addWindow(DockingWindow dockingWindow, RootWindow rootWindow) {
        if (rootWindow == null || dockingWindow.getRootWindow() == rootWindow) {
            return;
        }
        if (dockingWindow.getRootWindow() == null) {
            dockingWindow.restore();
            if (dockingWindow.getRootWindow() == rootWindow) {
                return;
            }
        }
        InternalDockingUtil.addToRootWindow(dockingWindow, rootWindow);
    }

    public static TabWindow getTabWindowFor(DockingWindow dockingWindow) {
        return dockingWindow instanceof TabWindow ? (TabWindow)dockingWindow : (dockingWindow.getWindowParent() != null && dockingWindow.getWindowParent() instanceof TabWindow ? (TabWindow)dockingWindow.getWindowParent() : null);
    }
}

