/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.SplitWindowProperties;
import net.infonode.properties.propertymap.PropertyMap;

public class SplitWindowItem
extends WindowItem {
    public static final SplitWindowProperties emptyProperties = new SplitWindowProperties();
    private boolean isHorizontal;
    private float dividerLocation;
    private SplitWindowProperties splitWindowProperties;
    private SplitWindowProperties parentProperties = emptyProperties;

    public SplitWindowItem() {
        this.splitWindowProperties = new SplitWindowProperties(emptyProperties);
    }

    public SplitWindowItem(SplitWindowItem splitWindowItem) {
        super(splitWindowItem);
        this.splitWindowProperties = new SplitWindowProperties(splitWindowItem.getSplitWindowProperties().getMap().copy(true, true));
        this.splitWindowProperties.getMap().replaceSuperMap(splitWindowItem.getParentSplitWindowProperties().getMap(), emptyProperties.getMap());
    }

    public SplitWindowItem(WindowItem windowItem, WindowItem windowItem2, boolean bl, float f) {
        this.addWindow(windowItem);
        this.addWindow(windowItem2);
        this.isHorizontal = bl;
        this.dividerLocation = f;
    }

    protected DockingWindow createWindow(ViewReader viewReader, ArrayList arrayList) {
        return arrayList.size() == 0 ? null : (arrayList.size() == 1 ? (DockingWindow)arrayList.get(0) : viewReader.createSplitWindow((DockingWindow)arrayList.get(0), (DockingWindow)arrayList.get(1), this));
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public float getDividerLocation() {
        return this.dividerLocation;
    }

    public void setHorizontal(boolean bl) {
        this.isHorizontal = bl;
    }

    public void setDividerLocation(float f) {
        this.dividerLocation = f;
    }

    public SplitWindowProperties getSplitWindowProperties() {
        return this.splitWindowProperties;
    }

    public SplitWindowProperties getParentSplitWindowProperties() {
        return this.parentProperties;
    }

    public void setParentSplitWindowProperties(SplitWindowProperties splitWindowProperties) {
        this.splitWindowProperties.getMap().replaceSuperMap(this.parentProperties.getMap(), splitWindowProperties.getMap());
        this.parentProperties = splitWindowProperties;
    }

    public WindowItem copy() {
        return new SplitWindowItem(this);
    }

    public void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
        objectOutputStream.writeInt(0);
        super.write(objectOutputStream, writeContext, viewWriter);
    }

    public void writeSettings(ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
        objectOutputStream.writeBoolean(this.isHorizontal);
        objectOutputStream.writeFloat(this.dividerLocation);
        super.writeSettings(objectOutputStream, writeContext);
    }

    public void readSettings(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        if (readContext.getVersion() >= 3) {
            this.isHorizontal = objectInputStream.readBoolean();
            this.dividerLocation = objectInputStream.readFloat();
        }
        super.readSettings(objectInputStream, readContext);
    }

    protected PropertyMap getPropertyObject() {
        return this.getSplitWindowProperties().getMap();
    }
}

