/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import madkit.TreeTools.GenericIconDescriptor;
import madkit.explorer.Icon;
import madkit.kernel.AbstractAgent;

public class IconPanel
extends JPanel {
    AbstractAgent ag;
    private Color BackGround = Color.white;
    private Color TextColor = Color.black;
    int Nb_Y;
    int Nb_X;
    int iconSize;
    int Nb_Icons;

    public IconPanel(AbstractAgent abstractAgent, int n) {
        super(new FlowLayout());
        this.ag = abstractAgent;
        this.setBackground(this.BackGround);
        this.iconSize = n;
        this.Nb_Icons = 0;
    }

    public void clear() {
        this.removeAll();
        this.Nb_Icons = 0;
        this.repaint();
    }

    public void addItem(GenericIconDescriptor genericIconDescriptor, String string) {
        Icon icon = new Icon(this.ag, genericIconDescriptor, string, this.iconSize, this);
        genericIconDescriptor.setArg((Object)icon);
        this.add(icon);
        ++this.Nb_Icons;
        this.setPreferredSize(new Dimension(this.iconSize, this.Nb_Icons * this.iconSize));
        this.repaint();
    }

    public void renameItem(GenericIconDescriptor genericIconDescriptor, String string, String string2) {
        Component[] componentArray = this.getComponents();
        int n = this.indexOf(string, componentArray);
        if (n != -1) {
            this.remove(n);
            Icon icon = (Icon)componentArray[n];
            if (string2 != null) {
                icon.name = string2;
                this.add((Component)icon, n);
                icon.setToolTipText(icon.name);
                icon.getDescriptor().setArg((Object)icon);
            }
            this.setPreferredSize(new Dimension(this.iconSize, this.Nb_Icons * this.iconSize));
            this.repaint();
        }
    }

    public void CopyItem(String string) {
        Component[] componentArray = this.getComponents();
        int n = this.indexOf(string, componentArray);
        if (n != -1) {
            this.remove(n);
            Icon icon = (Icon)componentArray[n];
            if (string != null) {
                icon.name = string;
                this.add((Component)icon, n);
                icon.setToolTipText(icon.name);
                icon.getDescriptor().setArg((Object)icon);
            }
            this.setPreferredSize(new Dimension(this.iconSize, this.Nb_Icons * this.iconSize));
            this.repaint();
        }
    }

    public int indexOf(String string, Component[] componentArray) {
        if (this.countItems() == 0) {
            return 0;
        }
        int n = -1;
        for (int i = 0; i <= this.countItems() - 1; ++i) {
            Icon icon = (Icon)componentArray[i];
            if (!icon.name.equals(string)) continue;
            n = i;
            componentArray[i] = icon;
        }
        return n;
    }

    public int countItems() {
        return this.getComponentCount();
    }

    public void simpleClick(AWTEvent aWTEvent) {
    }

    public void leftClick(AWTEvent aWTEvent) {
    }

    public void doubleClick(AWTEvent aWTEvent) {
    }

    public void rightClick(AWTEvent aWTEvent) {
        Icon icon = (Icon)aWTEvent.getSource();
        JPopupMenu jPopupMenu = icon.getDescriptor().getPopup();
        if (jPopupMenu == null) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        icon.getDescriptor().setArg((Object)icon);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        this.Nb_X = dimension.width / this.iconSize;
        this.Nb_Y = this.Nb_Icons / this.Nb_X;
        if (this.Nb_Icons % this.Nb_X != 0) {
            ++this.Nb_Y;
        }
        graphics.setColor(this.TextColor);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < this.countItems(); ++i) {
            int n = i % this.Nb_X;
            int n2 = i / this.Nb_X;
            componentArray[i].setSize(this.iconSize, this.iconSize);
            componentArray[i].setLocation(n * this.iconSize, n2 * this.iconSize);
            componentArray[i].setVisible(true);
        }
        graphics.setColor(color);
        this.setPreferredSize(new Dimension(this.iconSize, this.Nb_Y * this.iconSize));
    }
}

