/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JRootPane;
import madkit.explorer.ExplorerGUI;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.kernel.Utils;

public class ExplorerLauncher
extends Agent {
    boolean life;
    JRootPane display;

    public void activate() {
        this.life = true;
        this.println("Explorer Agent Activated");
        this.createGroup(true, "Landscape", null, null);
        this.requestRole("Landscape", "Explorer", null);
    }

    public void live() {
        while (this.life) {
            this.exitImmediatlyOnKill();
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    public void initGUI() {
        this.display = new ExplorerGUI(this);
        this.setGUIObject(this.display);
    }

    public void killExplorerAgent() {
        this.life = false;
        this.killAgent((AbstractAgent)this);
    }

    public void end() {
        this.println("Bye Bye !!");
        this.println("Explorer Agent Ended");
    }

    protected void handleMessage(Message message) {
        System.out.println("Handling message :" + message);
        if (message.getClass().getName().equals("SEdit.SEditMessage")) {
            try {
                Class clazz = Utils.loadClass((String)"SEdit.SEditTools");
                Class[] classArray = new Class[]{Utils.loadClass((String)"madkit.kernel.AbstractAgent"), Utils.loadClass((String)"madkit.kernel.Message")};
                Method method = clazz.getMethod("createStructure", classArray);
                method.invoke((Object)clazz, new Object[]{this, message});
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Error: SEdit not installed");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("Internal error with SEdit " + noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Internal error with SEdit " + invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Internal error with SEdit " + illegalAccessException);
            }
        } else if (message instanceof StringMessage) {
            this.handleMessage((StringMessage)message);
        }
    }

    protected void handleMessage(StringMessage stringMessage) {
    }
}

