/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import madkit.TreeTools.AbstractFileNode;
import madkit.TreeTools.GenericTreeNode;
import madkit.explorer.Explorer;
import madkit.explorer.ExplorerActions;
import madkit.explorer.ExplorerDirectoryFile;
import madkit.explorer.ExplorerGUI;
import madkit.explorer.FileIcon;

public class ExplorerActionDrop
implements DropTargetListener {
    protected JTree tree;
    protected String action;
    protected FileIcon icon;
    ExplorerGUI adaptee;
    private Explorer explorer;
    private File oldFile;
    private File newFile;
    public DropTarget dropTarget;
    private Point point;

    protected void execIcon(Explorer explorer, FileIcon fileIcon) {
        ExplorerActions.actionToolBar = "drop";
        this.action = "icon";
        this.explorer = explorer;
        this.icon = fileIcon;
        this.dropTarget = new DropTarget(this.explorer, 3, this, this.explorer.isEnabled(), null);
    }

    protected void execTree(ExplorerGUI explorerGUI) {
        ExplorerActions.actionToolBar = "Drop";
        ExplorerActions.actionBefore = "Drag";
        this.action = "tree";
        this.adaptee = explorerGUI;
        this.explorer = this.adaptee.explorer;
        this.tree = this.adaptee.tree.getTree();
        this.dropTarget = new DropTarget(this.tree, 3, this, this.tree.isEnabled(), null);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            System.out.println("Drage enter UNsupported");
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.point = dropTargetDropEvent.getLocation();
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dropTargetDropEvent.acceptDrop(3);
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                File file = (File)list.get(0);
                this.transfertFile(file);
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {
                dropTargetDropEvent.dropComplete(false);
            }
        } else {
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        this.tree.setCursor(Cursor.getDefaultCursor());
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void transfertFile(File file) {
        this.tree.setCursor(Cursor.getPredefinedCursor(3));
        this.oldFile = file;
        String string = null;
        string = this.explorer != null ? this.explorer.getAbsolutePath() : AbstractFileNode.getNameFromPath((String)this.oldFile.toString());
        if (this.action.equals("tree")) {
            string = this.findTreePath(this.oldFile);
        }
        this.tree.setToolTipText(string);
        this.newFile = new File(string + File.separator + this.oldFile.getName());
        ExplorerDirectoryFile explorerDirectoryFile = new ExplorerDirectoryFile(this.explorer, this.oldFile, this.newFile);
    }

    public String findTreePath(File file) {
        String string = null;
        TreePath treePath = this.tree.getPathForLocation(this.point.x, this.point.y);
        GenericTreeNode genericTreeNode = (GenericTreeNode)treePath.getLastPathComponent();
        if (genericTreeNode == null) {
            return null;
        }
        this.adaptee.explorer.setNode((AbstractFileNode)genericTreeNode);
        TreePath treePath2 = new TreePath(genericTreeNode.getPath());
        this.adaptee.tree.getTree().expandPath(treePath2);
        this.adaptee.tree.getTree().setSelectionPath(treePath2);
        string = this.adaptee.textField.getText();
        return string;
    }
}

