/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTree;
import madkit.TreeTools.GenericTreeNode;
import madkit.explorer.Explorer;
import madkit.explorer.ExplorerActionDrop;
import madkit.explorer.ExplorerActions;
import madkit.explorer.ExplorerGUI;
import madkit.explorer.ExplorerTransferableFile;
import madkit.explorer.FileIcon;

public class ExplorerActionDrag
extends JComponent {
    protected String path;
    protected ExplorerGUI adaptee;
    protected File file;
    GenericTreeNode node;
    MouseEvent e;
    DragSource dragSource;
    ExplorerActionDrop explorerActionDrop = new ExplorerActionDrop();
    Explorer explorer;
    FileIcon icon;

    public void execIcon(Explorer explorer, FileIcon fileIcon) {
        ExplorerActions.actionToolBar = "Drag";
        this.icon = fileIcon;
        this.explorer = explorer;
        this.file = new File(this.icon.name);
        this.transDrag();
        this.transIcon();
    }

    public void execTree(ExplorerGUI explorerGUI) {
        ExplorerActions.actionToolBar = "Drag";
        this.adaptee = explorerGUI;
        this.path = this.adaptee.textField.getText();
        this.transDrag();
        this.transTree();
    }

    protected void transDrag() {
        this.dragSource = DragSource.getDefaultDragSource();
    }

    protected void transIcon() {
        this.dragSource.createDefaultDragGestureRecognizer(this.icon, 3, new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                File[] fileArray = new File[]{ExplorerActionDrag.this.file};
                ExplorerTransferableFile explorerTransferableFile = new ExplorerTransferableFile(fileArray);
                if (explorerTransferableFile != null) {
                    dragGestureEvent.startDrag(null, explorerTransferableFile, new ExplorerDragSourceListener());
                    ExplorerActionDrag.this.explorerActionDrop.execIcon(ExplorerActionDrag.this.explorer, ExplorerActionDrag.this.icon);
                } else {
                    System.out.println("selection is null");
                }
            }
        });
    }

    protected void transTree() {
        JTree jTree = this.adaptee.tree.getTree();
        try {
            this.dragSource.createDefaultDragGestureRecognizer(jTree, 3, new DragGestureListener(){

                public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                    ExplorerActionDrag.this.file = new File(ExplorerActionDrag.this.path);
                    ExplorerActions.actionToolBar = "Drag";
                    File[] fileArray = new File[]{ExplorerActionDrag.this.file};
                    ExplorerTransferableFile explorerTransferableFile = new ExplorerTransferableFile(fileArray);
                    if (explorerTransferableFile != null) {
                        dragGestureEvent.startDrag(null, explorerTransferableFile, new ExplorerDragSourceListener());
                        ExplorerActionDrag.this.explorerActionDrop.execTree(ExplorerActionDrag.this.adaptee);
                    } else {
                        System.out.println("selection is null");
                    }
                }
            });
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class ExplorerDragSourceListener
    implements DragSourceListener {
        protected ExplorerDragSourceListener() {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess()) {
                System.out.println("DragDropEnd  DRAG " + dragSourceDropEvent.getDropAction());
            } else {
                System.out.println("DragDropEnd  No suceess " + dragSourceDropEvent.getDropAction());
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }
}

