/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDisplayer
extends DefaultHandler {
    private static Writer out;
    private String indentString = "    ";
    private int indentLevel = 0;

    public XmlDisplayer(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            out = new OutputStreamWriter((OutputStream)System.out, "UTF8");
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new File(string), (DefaultHandler)this);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    public void setDocumentLocator(Locator locator) {
        try {
            out.write("LOCATOR");
            out.write("\n SYS ID: " + locator.getSystemId());
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startDocument() throws SAXException {
        this.nl();
        this.nl();
        this.emit("START DOCUMENT");
        this.nl();
        this.emit("<?xml version='1.0' encoding='UTF-8'?>");
    }

    public void endDocument() throws SAXException {
        this.nl();
        this.emit("END DOCUMENT");
        try {
            this.nl();
            out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.indentLevel;
        this.nl();
        this.emit("ELEMENT: ");
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        this.emit("<" + string4);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                this.nl();
                this.emit("   ATTR: ");
                this.emit(string5);
                this.emit("\t\"");
                this.emit(attributes.getValue(i));
                this.emit("\"");
            }
        }
        if (attributes.getLength() > 0) {
            this.nl();
        }
        this.emit(">");
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.nl();
        this.emit("END_ELM: ");
        this.emit("</" + string2 + ">");
        --this.indentLevel;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.nl();
        this.emit("CHARS:   ");
        String string = new String(cArray, n, n2);
        if (!string.trim().equals("")) {
            this.emit(string);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.nl();
        this.emit("IGNORABLE");
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.nl();
        this.emit("PROCESS: ");
        this.emit("<?" + string + " " + string2 + "?>");
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private void emit(String string) throws SAXException {
        try {
            out.write(string);
            out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    private void nl() throws SAXException {
        String string = System.getProperty("line.separator");
        try {
            out.write(string);
            for (int i = 0; i < this.indentLevel; ++i) {
                out.write(this.indentString);
            }
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }
}

